/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.testing.junit.dwr;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHttpRequest
extends ScriptableObject {
    private String url;
    private String httpMethod;
    private int httpStatus;
    private String httpStatusText;
    private Map requestHeaders;
    private String userName;
    private String password;
    private String responseText;
    private Document responseXML;
    private int readyState;
    private NativeFunction readyStateChangeFunction;
    private boolean asyncFlag;
    private Thread asyncThread;
    private ServletUnitClient suc;
    private WebRequest request;
    private WebResponse response;
    private boolean localRequest = false;
    private HttpURLConnection connection;

    public void jsConstructor() {
        this.suc = (ServletUnitClient)Context.getCurrentContext().getThreadLocal((Object)"SERVLET_UNIT_CLIENT");
    }

    public String getClassName() {
        return "XMLHttpRequest";
    }

    public void jsFunction_setRequestHeader(String headerName, String value) {
        if (this.readyState > 1) {
            throw new IllegalStateException("request already in progress");
        }
        if (this.requestHeaders == null) {
            this.requestHeaders = new HashMap();
        }
        this.requestHeaders.put(headerName, value);
    }

    public Map<String, String[]> jsFunction_getAllResponseHeaders() {
        if (this.readyState < 3) {
            throw new IllegalStateException("must call send before getting response headers");
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String name : this.response.getHeaderFieldNames()) {
            map.put(name.toLowerCase(), this.response.getHeaderFields(name));
        }
        return map;
    }

    public String jsFunction_getResponseHeader(String headerName) {
        String[] theValues;
        String theValue = "";
        for (String value : theValues = this.jsFunction_getAllResponseHeaders().get(headerName.toLowerCase())) {
            theValue = (theValue.length() > 0 ? " " : "") + value;
        }
        return theValue;
    }

    public void jsFunction_open(String httpMethod, String url, boolean asyncFlag, String userName, String password) {
        if (this.readyState != 0) {
            throw new IllegalStateException("already open");
        }
        this.httpMethod = httpMethod;
        this.url = url;
        if (!this.url.startsWith("http://")) {
            this.url = "http://localhost" + (this.url.startsWith("/") ? "" : "/") + this.url;
        }
        this.localRequest = this.url.startsWith("http://localhost/");
        this.asyncFlag = asyncFlag;
        this.userName = "undefined".equals(userName) || "".equals(userName) ? null : userName;
        this.password = "undefined".equals(password) || "".equals(password) ? null : password;
        if (this.userName != null) {
            this.setAuthenticator();
        }
        this.setReadyState(1);
    }

    private void setAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(XMLHttpRequest.this.userName, XMLHttpRequest.this.password.toCharArray());
            }
        });
    }

    public void jsFunction_send(Object o) throws SAXException, MalformedURLException, IOException {
        String content = o == null ? "" : o.toString();
        this.doSend(content);
    }

    public void jsFunction_abort() {
        if (this.asyncThread != null) {
            this.asyncThread.interrupt();
        }
    }

    public int jsGet_readyState() {
        return this.readyState;
    }

    public String jsGet_responseText() {
        if (this.readyState < 2) {
            throw new IllegalStateException("request not yet sent");
        }
        return this.responseText;
    }

    public Document jsGet_responseXML() {
        if (this.responseXML == null && this.responseText != null) {
            this.convertResponse2DOM();
        }
        return this.responseXML;
    }

    private void convertResponse2DOM() {
        try {
            DOMParser parser = new DOMParser();
            StringReader sr = new StringReader(this.jsGet_responseText());
            parser.parse(new InputSource(sr));
            this.responseXML = parser.getDocument();
        }
        catch (SAXException e) {
            throw new RuntimeException("ex: " + e, e);
        }
        catch (IOException e) {
            throw new RuntimeException("ex: " + e, e);
        }
    }

    public int jsGet_status() {
        return this.httpStatus;
    }

    public String jsGet_statusText() {
        return this.httpStatusText;
    }

    public Object jsGet_onreadystatechange() {
        return this.readyStateChangeFunction;
    }

    public void jsSet_onreadystatechange(NativeFunction function) {
        this.readyStateChangeFunction = function;
    }

    private void doSend(String content) throws SAXException, MalformedURLException, IOException {
        this.connect(content);
        this.setRequestHeaders();
        this.sendRequest(content);
        if ("POST".equals(this.httpMethod) || "GET".equals(this.httpMethod)) {
            this.readResponse();
        }
        this.setReadyState(4);
    }

    private void connect(String content) throws MalformedURLException, IOException {
        if (this.httpMethod == "POST") {
            if (this.localRequest) {
                ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes());
                this.request = new PostMethodWebRequest(this.url, (InputStream)bis, null);
            } else {
                URL url = new URL(this.url);
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setDoInput(true);
                this.connection.setDoOutput(true);
                this.connection.setRequestMethod("POST");
            }
        } else if (this.localRequest) {
            this.request = new GetMethodWebRequest("http://localhost/" + this.url);
        } else {
            URL url = new URL(this.url);
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setDoInput(true);
            this.connection.setRequestMethod("GET");
        }
    }

    private void setRequestHeaders() {
        if (this.requestHeaders != null) {
            for (String header : this.requestHeaders.keySet()) {
                String value = (String)this.requestHeaders.get(header);
                if (this.localRequest) {
                    this.request.setHeaderField(header, value);
                    continue;
                }
                this.connection.setRequestProperty(header, value);
            }
        }
    }

    private void sendRequest(String content) throws SAXException {
        try {
            if ("POST".equals(this.httpMethod) || content.length() > 0) {
                if (this.localRequest) {
                    this.response = this.suc.getResponse(this.request);
                } else {
                    OutputStreamWriter out = new OutputStreamWriter(this.connection.getOutputStream(), "ASCII");
                    out.write(content);
                    out.flush();
                    out.close();
                }
            }
            if (this.localRequest) {
                this.httpStatus = this.response.getResponseCode();
                this.httpStatusText = this.response.getResponseMessage();
            } else {
                this.httpStatus = this.connection.getResponseCode();
                this.httpStatusText = this.connection.getResponseMessage();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e, e);
        }
        this.setReadyState(2);
    }

    private void readResponse() {
        try {
            if (this.localRequest) {
                this.responseText = this.response.getText();
            } else {
                int i;
                InputStream is = this.connection.getInputStream();
                StringBuffer sb = new StringBuffer();
                this.setReadyState(3);
                while ((i = is.read()) != -1) {
                    sb.append((char)i);
                }
                is.close();
                this.responseText = sb.toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e, e);
        }
    }

    private void setReadyState(int state) {
        this.readyState = state;
        this.callOnreadyStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnreadyStateChange() {
        if (this.readyStateChangeFunction != null) {
            Context cx = Context.enter();
            try {
                ScriptableObject scope = cx.initStandardObjects();
                this.readyStateChangeFunction.call(cx, (Scriptable)scope, (Scriptable)this, new Object[0]);
            }
            finally {
                Context.exit();
            }
        }
    }
}

