/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.BinaryOWLVersion;
import org.semanticweb.binaryowl.chunk.ChunkUtil;

public class BinaryOWLOntologyDocumentPreamble {
    public static final int MAGIC_NUMBER = ChunkUtil.toInt("BO2O");
    public static final BinaryOWLVersion DEFAULT_VERSION = BinaryOWLVersion.getVersion(3);
    private BinaryOWLVersion fileFormatVersion;

    public BinaryOWLOntologyDocumentPreamble() {
        this(DEFAULT_VERSION);
    }

    public BinaryOWLOntologyDocumentPreamble(DataInputStream dataInputStream) throws IOException, BinaryOWLParseException {
        this.read(dataInputStream);
    }

    private BinaryOWLOntologyDocumentPreamble(BinaryOWLVersion version) {
        this.fileFormatVersion = version;
    }

    private void read(DataInputStream dataInputStream) throws IOException, BinaryOWLParseException {
        int magicNumber = dataInputStream.readInt();
        if (magicNumber != MAGIC_NUMBER) {
            throw new BinaryOWLParseException("Corrupt file or not a binary OWL format (Magic Number Not Present)");
        }
        short version = dataInputStream.readShort();
        this.fileFormatVersion = BinaryOWLVersion.getVersion(version);
    }

    public BinaryOWLVersion getFileFormatVersion() {
        return this.fileFormatVersion;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(MAGIC_NUMBER);
        dos.writeShort(this.fileFormatVersion.getVersion());
    }
}

