/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.BinaryOWLVersion;
import org.semanticweb.binaryowl.change.OntologyChangeRecordRun;
import org.semanticweb.binaryowl.chunk.ChunkUtil;
import org.semanticweb.binaryowl.chunk.SkipSetting;
import org.semanticweb.binaryowl.chunk.TimeStampedMetadataChunk;
import org.semanticweb.binaryowl.lookup.IRILookupTable;
import org.semanticweb.binaryowl.lookup.LookupTable;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.change.AddAxiomData;
import org.semanticweb.owlapi.change.AddImportData;
import org.semanticweb.owlapi.change.AddOntologyAnnotationData;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.change.OWLOntologyChangeDataVisitor;
import org.semanticweb.owlapi.change.OWLOntologyChangeRecord;
import org.semanticweb.owlapi.change.RemoveAxiomData;
import org.semanticweb.owlapi.change.RemoveImportData;
import org.semanticweb.owlapi.change.RemoveOntologyAnnotationData;
import org.semanticweb.owlapi.change.SetOntologyIDData;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyChangeRecordList
implements TimeStampedMetadataChunk {
    private static final short VERSION_1 = 1;
    private static final short VERSION_2 = 2;
    private static final short VERSION_3 = 3;
    public static final int CHUNK_TYPE_MARKER = ChunkUtil.toInt("ochr");
    private static final int CHUNK_TYPE_AND_LENGTH_SIZE = 8;
    private long timestamp;
    private BinaryOWLMetadata metadata;
    private ImmutableList<OWLOntologyChangeRecord> changeRecords;

    public OntologyChangeRecordList(List<OWLOntologyChange> changes, long timestamp, BinaryOWLMetadata metadata) {
        this(timestamp, metadata, OntologyChangeRecordList.convertToChangeRecordList(changes));
    }

    private static List<OWLOntologyChangeRecord> convertToChangeRecordList(List<OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChangeRecord> records = new ArrayList<OWLOntologyChangeRecord>(changes.size() + 1);
        for (OWLOntologyChange change : changes) {
            records.add(change.getChangeRecord());
        }
        return records;
    }

    public OntologyChangeRecordList(long timestamp, BinaryOWLMetadata metadata, List<OWLOntologyChangeRecord> changeRecords) {
        this(timestamp, metadata, (ImmutableList<OWLOntologyChangeRecord>)ImmutableList.copyOf(changeRecords));
    }

    public OntologyChangeRecordList(long timestamp, BinaryOWLMetadata metadata, ImmutableList<OWLOntologyChangeRecord> changeRecords) {
        this.timestamp = timestamp;
        this.metadata = (BinaryOWLMetadata)Preconditions.checkNotNull((Object)metadata);
        this.changeRecords = (ImmutableList)Preconditions.checkNotNull(changeRecords);
    }

    public OntologyChangeRecordList(BinaryOWLInputStream inputStream, SkipSetting skipSetting) throws IOException, BinaryOWLParseException {
        this.read(inputStream, skipSetting);
    }

    @Override
    public int getChunkType() {
        return CHUNK_TYPE_MARKER;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public BinaryOWLMetadata getMetadata() {
        return this.metadata;
    }

    public List<OWLOntologyChangeRecord> getChangeRecords() {
        return this.changeRecords;
    }

    public List<OntologyChangeRecordRun> getRuns() {
        ArrayList<OntologyChangeRecordRun> result = new ArrayList<OntologyChangeRecordRun>();
        if (!this.changeRecords.isEmpty()) {
            OWLOntologyID currentRunId = null;
            ArrayList<OWLOntologyChangeData> runInfoList = new ArrayList<OWLOntologyChangeData>();
            for (OWLOntologyChangeRecord record : this.changeRecords) {
                if (currentRunId == null) {
                    currentRunId = record.getOntologyID();
                } else if (!currentRunId.equals((Object)record.getOntologyID())) {
                    result.add(new OntologyChangeRecordRun(currentRunId, new ArrayList<OWLOntologyChangeData>(runInfoList)));
                    currentRunId = record.getOntologyID();
                    runInfoList.clear();
                }
                runInfoList.add(record.getData());
            }
            result.add(new OntologyChangeRecordRun(currentRunId, new ArrayList<OWLOntologyChangeData>(runInfoList)));
        }
        return result;
    }

    public void write(BinaryOWLOutputStream os) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream bufDataOutputStream = new DataOutputStream(buf);
        IRILookupTable iriLookupTable = new IRILookupTable(this.getChangeSignature());
        LookupTable lookupTable = new LookupTable(iriLookupTable);
        BinaryOWLOutputStream bufOWLOutputStream = new BinaryOWLOutputStream(bufDataOutputStream, lookupTable, BinaryOWLVersion.getVersion(3));
        bufDataOutputStream.writeShort(3);
        lookupTable.getIRILookupTable().write(bufDataOutputStream);
        bufDataOutputStream.writeLong(this.timestamp);
        ByteArrayOutputStream metadataBuffer = new ByteArrayOutputStream();
        DataOutputStream metadataDataOutputStream = new DataOutputStream(metadataBuffer);
        BinaryOWLOutputStream metadataOWLOutputStream = new BinaryOWLOutputStream(metadataDataOutputStream, os.getVersion());
        this.metadata.write(metadataOWLOutputStream);
        bufDataOutputStream.writeInt(metadataBuffer.size());
        metadataBuffer.writeTo(bufDataOutputStream);
        List<OntologyChangeRecordRun> runs = this.getRuns();
        bufDataOutputStream.writeInt(runs.size());
        for (OntologyChangeRecordRun run : runs) {
            run.write(bufOWLOutputStream);
        }
        bufOWLOutputStream.flush();
        int bufferSize = buf.size();
        os.writeInt(bufferSize);
        os.writeInt(CHUNK_TYPE_MARKER);
        buf.writeTo(os);
    }

    private Set<OWLEntity> getChangeSignature() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        OWLOntologyChangeDataVisitor<Set<OWLEntity>, RuntimeException> visitor = new OWLOntologyChangeDataVisitor<Set<OWLEntity>, RuntimeException>(){

            public Set<OWLEntity> visit(AddAxiomData data) throws RuntimeException {
                return data.getAxiom().getSignature();
            }

            public Set<OWLEntity> visit(RemoveAxiomData data) throws RuntimeException {
                return data.getAxiom().getSignature();
            }

            public Set<OWLEntity> visit(AddOntologyAnnotationData data) throws RuntimeException {
                return data.getAnnotation().getSignature();
            }

            public Set<OWLEntity> visit(RemoveOntologyAnnotationData data) throws RuntimeException {
                return data.getAnnotation().getSignature();
            }

            public Set<OWLEntity> visit(SetOntologyIDData data) throws RuntimeException {
                return Collections.emptySet();
            }

            public Set<OWLEntity> visit(AddImportData data) throws RuntimeException {
                return Collections.emptySet();
            }

            public Set<OWLEntity> visit(RemoveImportData data) throws RuntimeException {
                return Collections.emptySet();
            }
        };
        for (OWLOntologyChangeRecord record : this.changeRecords) {
            result.addAll((Collection)record.getData().accept((OWLOntologyChangeDataVisitor)visitor));
        }
        return result;
    }

    private void read(BinaryOWLInputStream inputStream, SkipSetting skipSetting) throws IOException, BinaryOWLParseException {
        long startPos = inputStream.getBytesRead();
        int chunkSize = inputStream.readInt();
        int chunkTypeMarker = inputStream.readInt();
        if (chunkTypeMarker != CHUNK_TYPE_MARKER) {
            throw new BinaryOWLParseException("Expected chunk type 0x" + Integer.toHexString(CHUNK_TYPE_MARKER) + " but encountered 0x" + Integer.toHexString(chunkTypeMarker));
        }
        short versionNumber = inputStream.readShort();
        if (versionNumber != 1 && versionNumber != 2 && versionNumber != 3) {
            throw new BinaryOWLParseException("Invalid version specifier.  Found 0x" + Integer.toHexString(versionNumber) + " but expected 0x" + Integer.toHexString(1) + " or 0x" + Integer.toHexString(2));
        }
        inputStream.setVersion(BinaryOWLVersion.getVersion(versionNumber));
        if (versionNumber >= 2) {
            IRILookupTable iriLookupTable = inputStream.readIRILookupTable();
            LookupTable lookupTable = new LookupTable(iriLookupTable);
            inputStream.pushLookupTable(lookupTable);
        }
        this.timestamp = inputStream.readLong();
        int metadataSize = inputStream.readInt();
        if (skipSetting.isSkipMetadata()) {
            inputStream.skipBytes(metadataSize);
            this.metadata = new BinaryOWLMetadata();
        } else {
            this.metadata = new BinaryOWLMetadata(inputStream);
        }
        long curPos = inputStream.getBytesRead();
        if (skipSetting.isSkipData()) {
            int bytesToSkip = chunkSize - (int)(curPos - startPos) + 8;
            inputStream.skipBytes(bytesToSkip);
            this.changeRecords = ImmutableList.of();
        } else {
            this.changeRecords = OntologyChangeRecordList.readRecords(inputStream);
        }
        long nextPos = inputStream.getBytesRead();
        if (versionNumber == 2) {
            inputStream.popLookupTable();
        }
    }

    private static ImmutableList<OWLOntologyChangeRecord> readRecords(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        int numberOfRuns = inputStream.readInt();
        ImmutableList.Builder recordsBuilder = ImmutableList.builder();
        for (int i = 0; i < numberOfRuns; ++i) {
            OntologyChangeRecordRun run = new OntologyChangeRecordRun(inputStream);
            for (OWLOntologyChangeData info : run.getChangeDataList()) {
                recordsBuilder.add((Object)new OWLOntologyChangeRecord(run.getOntologyID(), info));
            }
        }
        return recordsBuilder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OntologyChangeRecordList(");
        sb.append(this.timestamp);
        sb.append(" ");
        sb.append(this.metadata);
        sb.append(" ");
        for (OWLOntologyChangeRecord record : this.changeRecords) {
            sb.append(" ");
            sb.append(record);
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }
}

