/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.OWLObjectBinaryTypeSelector;
import org.semanticweb.binaryowl.owlobject.serializer.IRISerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLAnnotationAssertionAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLAnnotationPropertyDomainAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLAnnotationPropertyRangeAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLAnnotationSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLAnonymousIndividualSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLAsymmetricObjectPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLClassAssertionAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataAllValuesFromSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataComplementOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataExactCardinalityRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataHasValueSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataIntersectionOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataMaxCardinalityRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataMinCardinalityRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataOneOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataPropertyAssertionAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataPropertyDomainAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataPropertyRangeAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataSomeValuesFromSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDataUnionOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDatatypeDefinitionAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDatatypeRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDeclarationSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDifferentIndividualsAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDisjointClassesAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDisjointDataPropertiesAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDisjointObjectPropertiesAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLDisjointUnionAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLEntitySerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLEquivalentClassesAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLEquivalentDataPropertiesAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLEquivalentObjectPropertiesAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLFacetRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLFunctionalDataPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLFunctionalObjectPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLHasKeyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLInverseFunctionalObjectPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLInverseObjectPropertiesAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLIrreflexiveObjectPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLLiteralSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLNegativeDataPropertyAssertionAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLNegativeObjectPropertyAssertionAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectAllValuesFromSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectComplementOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectExactCardinalityRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectHasSelfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectHasValueSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectIntersectionOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectInverseOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectMaxCardinalityRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectMinCardinalityRestrictionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectOneOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectPropertyAssertionSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectPropertyDomainSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectPropertyRangeAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectSomeValuesFromSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectUnionOfSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLOntologySerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLReflexiveObjectPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLSameIndividualAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLSubAnnotationPropertyOfAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLSubDataPropertyOfAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLSubObjectPropertyOfAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLSubPropertyChainOfAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLSubclassOfAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLSymmetricObjectPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.OWLTransitiveObjectPropertyAxiomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLBuiltInAtomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLClassAtomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLDataPropertyAtomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLDataRangeAtomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLDifferentIndividualsAtomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLIndividualArgumentSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLLiteralArgumentSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLObjectPropertyAtomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLRuleSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLSameIndividualAtomSerializer;
import org.semanticweb.binaryowl.owlobject.serializer.SWRLVariableSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

public class OWLObjectBinaryType<C extends OWLObject> {
    private static List<OWLObjectBinaryType<?>> values = new ArrayList();
    public static final OWLObjectBinaryType<OWLOntology> OWL_ONTOLOGY = OWLObjectBinaryType.getInstance(1, OWLOntology.class, new OWLOntologySerializer());
    public static final OWLObjectBinaryType<OWLDeclarationAxiom> OWL_DECLARATION = OWLObjectBinaryType.getInstance(2, OWLDeclarationAxiom.class, new OWLDeclarationSerializer());
    public static final OWLObjectBinaryType<IRI> IRI = OWLObjectBinaryType.getInstance(3, IRI.class, new IRISerializer());
    public static final OWLObjectBinaryType<OWLClass> OWL_CLASS = OWLObjectBinaryType.getInstance(4, OWLClass.class, new OWLEntitySerializer(EntityType.CLASS));
    public static final OWLObjectBinaryType<OWLObjectProperty> OWL_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(5, OWLObjectProperty.class, new OWLEntitySerializer(EntityType.OBJECT_PROPERTY));
    public static final OWLObjectBinaryType<OWLDataProperty> OWL_DATA_PROPERTY = OWLObjectBinaryType.getInstance(6, OWLDataProperty.class, new OWLEntitySerializer(EntityType.DATA_PROPERTY));
    public static final OWLObjectBinaryType<OWLAnnotationProperty> OWL_ANNOTATION_PROPERTY = OWLObjectBinaryType.getInstance(7, OWLAnnotationProperty.class, new OWLEntitySerializer(EntityType.ANNOTATION_PROPERTY));
    public static final OWLObjectBinaryType<OWLDatatype> OWL_DATATYPE = OWLObjectBinaryType.getInstance(8, OWLDatatype.class, new OWLEntitySerializer(EntityType.DATATYPE));
    public static final OWLObjectBinaryType<OWLNamedIndividual> OWL_NAMED_INDIVIDUAL = OWLObjectBinaryType.getInstance(9, OWLNamedIndividual.class, new OWLEntitySerializer(EntityType.NAMED_INDIVIDUAL));
    public static final OWLObjectBinaryType<OWLAnonymousIndividual> OWL_ANONYMOUS_INDIVIDUAL = OWLObjectBinaryType.getInstance(10, OWLAnonymousIndividual.class, new OWLAnonymousIndividualSerializer());
    public static final OWLObjectBinaryType<OWLLiteral> OWL_LITERAL = OWLObjectBinaryType.getInstance(11, OWLLiteral.class, new OWLLiteralSerializer());
    public static final OWLObjectBinaryType<OWLObjectInverseOf> OWL_OBJECT_INVERSE_OF = OWLObjectBinaryType.getInstance(12, OWLObjectInverseOf.class, new OWLObjectInverseOfSerializer());
    public static final OWLObjectBinaryType<OWLDataIntersectionOf> OWL_DATA_INTERSECTION_OF = OWLObjectBinaryType.getInstance(13, OWLDataIntersectionOf.class, new OWLDataIntersectionOfSerializer());
    public static final OWLObjectBinaryType<OWLDataUnionOf> OWL_DATA_UNION_OF = OWLObjectBinaryType.getInstance(14, OWLDataUnionOf.class, new OWLDataUnionOfSerializer());
    public static final OWLObjectBinaryType<OWLDataComplementOf> OWL_DATA_COMPLEMENT_OF = OWLObjectBinaryType.getInstance(15, OWLDataComplementOf.class, new OWLDataComplementOfSerializer());
    public static final OWLObjectBinaryType<OWLDataOneOf> OWL_DATA_ONE_OF = OWLObjectBinaryType.getInstance(16, OWLDataOneOf.class, new OWLDataOneOfSerializer());
    public static final OWLObjectBinaryType<OWLDatatypeRestriction> OWL_DATATYPE_RESTRICTION = OWLObjectBinaryType.getInstance(17, OWLDatatypeRestriction.class, new OWLDatatypeRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLFacetRestriction> OWL_FACET_RESTRICTION = OWLObjectBinaryType.getInstance(18, OWLFacetRestriction.class, new OWLFacetRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLObjectIntersectionOf> OWL_OBJECT_INTERSECTION_OF = OWLObjectBinaryType.getInstance(19, OWLObjectIntersectionOf.class, new OWLObjectIntersectionOfSerializer());
    public static final OWLObjectBinaryType<OWLObjectUnionOf> OWL_OBJECT_UNION_OF = OWLObjectBinaryType.getInstance(20, OWLObjectUnionOf.class, new OWLObjectUnionOfSerializer());
    public static final OWLObjectBinaryType<OWLObjectComplementOf> OWL_OBJECT_COMPLEMENT_OF = OWLObjectBinaryType.getInstance(21, OWLObjectComplementOf.class, new OWLObjectComplementOfSerializer());
    public static final OWLObjectBinaryType<OWLObjectOneOf> OWL_OBJECT_ONE_OF = OWLObjectBinaryType.getInstance(22, OWLObjectOneOf.class, new OWLObjectOneOfSerializer());
    public static final OWLObjectBinaryType<OWLObjectSomeValuesFrom> OWL_OBJECT_SOME_VALUES_FROM = OWLObjectBinaryType.getInstance(23, OWLObjectSomeValuesFrom.class, new OWLObjectSomeValuesFromSerializer());
    public static final OWLObjectBinaryType<OWLObjectAllValuesFrom> OWL_OBJECT_ALL_VALUES_FROM = OWLObjectBinaryType.getInstance(24, OWLObjectAllValuesFrom.class, new OWLObjectAllValuesFromSerializer());
    public static final OWLObjectBinaryType<OWLObjectHasValue> OWL_OBJECT_HAS_VALUE = OWLObjectBinaryType.getInstance(25, OWLObjectHasValue.class, new OWLObjectHasValueSerializer());
    public static final OWLObjectBinaryType<OWLObjectHasSelf> OWL_OBJECT_HAS_SELF = OWLObjectBinaryType.getInstance(26, OWLObjectHasSelf.class, new OWLObjectHasSelfSerializer());
    public static final OWLObjectBinaryType<OWLObjectMinCardinality> OWL_OBJECT_MIN_CARDINALITY = OWLObjectBinaryType.getInstance(27, OWLObjectMinCardinality.class, new OWLObjectMinCardinalityRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLObjectMaxCardinality> OWL_OBJECT_MAX_CARDINALITY = OWLObjectBinaryType.getInstance(28, OWLObjectMaxCardinality.class, new OWLObjectMaxCardinalityRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLObjectExactCardinality> OWL_OBJECT_EXACT_CARDINALITY = OWLObjectBinaryType.getInstance(29, OWLObjectExactCardinality.class, new OWLObjectExactCardinalityRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLDataSomeValuesFrom> OWL_DATA_SOME_VALUES_FROM = OWLObjectBinaryType.getInstance(30, OWLDataSomeValuesFrom.class, new OWLDataSomeValuesFromSerializer());
    public static final OWLObjectBinaryType<OWLDataAllValuesFrom> OWL_DATA_ALL_VALUES_FROM = OWLObjectBinaryType.getInstance(31, OWLDataAllValuesFrom.class, new OWLDataAllValuesFromSerializer());
    public static final OWLObjectBinaryType<OWLDataHasValue> OWL_DATA_HAS_VALUE = OWLObjectBinaryType.getInstance(32, OWLDataHasValue.class, new OWLDataHasValueSerializer());
    public static final OWLObjectBinaryType<OWLDataMinCardinality> OWL_DATA_MIN_CARDINALITY = OWLObjectBinaryType.getInstance(33, OWLDataMinCardinality.class, new OWLDataMinCardinalityRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLDataMaxCardinality> OWL_DATA_MAX_CARDINALITY = OWLObjectBinaryType.getInstance(34, OWLDataMaxCardinality.class, new OWLDataMaxCardinalityRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLDataExactCardinality> OWL_DATA_EXACT_CARDINALITY = OWLObjectBinaryType.getInstance(35, OWLDataExactCardinality.class, new OWLDataExactCardinalityRestrictionSerializer());
    public static final OWLObjectBinaryType<OWLSubClassOfAxiom> OWL_SUBCLASS_OF = OWLObjectBinaryType.getInstance(36, OWLSubClassOfAxiom.class, new OWLSubclassOfAxiomSerializer());
    public static final OWLObjectBinaryType<OWLEquivalentClassesAxiom> OWL_EQUIVALENT_CLASSES = OWLObjectBinaryType.getInstance(37, OWLEquivalentClassesAxiom.class, new OWLEquivalentClassesAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDisjointClassesAxiom> OWL_DISJOINT_CLASSES = OWLObjectBinaryType.getInstance(38, OWLDisjointClassesAxiom.class, new OWLDisjointClassesAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDisjointUnionAxiom> OWL_DISJOINT_UNION = OWLObjectBinaryType.getInstance(39, OWLDisjointUnionAxiom.class, new OWLDisjointUnionAxiomSerializer());
    public static final OWLObjectBinaryType<OWLSubObjectPropertyOfAxiom> OWL_SUB_OBJECT_PROPERTY_OF = OWLObjectBinaryType.getInstance(40, OWLSubObjectPropertyOfAxiom.class, new OWLSubObjectPropertyOfAxiomSerializer());
    public static final OWLObjectBinaryType<OWLSubPropertyChainOfAxiom> OWL_SUB_OBJECT_PROPERTY_CHAIN_OF = OWLObjectBinaryType.getInstance(41, OWLSubPropertyChainOfAxiom.class, new OWLSubPropertyChainOfAxiomSerializer());
    public static final OWLObjectBinaryType<OWLEquivalentObjectPropertiesAxiom> OWL_EQUIVALENT_OBJECT_PROPERTIES = OWLObjectBinaryType.getInstance(42, OWLEquivalentObjectPropertiesAxiom.class, new OWLEquivalentObjectPropertiesAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDisjointObjectPropertiesAxiom> OWL_DISJOINT_OBJECT_PROPERTIES = OWLObjectBinaryType.getInstance(43, OWLDisjointObjectPropertiesAxiom.class, new OWLDisjointObjectPropertiesAxiomSerializer());
    public static final OWLObjectBinaryType<OWLObjectPropertyDomainAxiom> OWL_OBJECT_PROPERTY_DOMAIN = OWLObjectBinaryType.getInstance(44, OWLObjectPropertyDomainAxiom.class, new OWLObjectPropertyDomainSerializer());
    public static final OWLObjectBinaryType<OWLObjectPropertyRangeAxiom> OWL_OBJECT_PROPERTY_RANGE = OWLObjectBinaryType.getInstance(45, OWLObjectPropertyRangeAxiom.class, new OWLObjectPropertyRangeAxiomSerializer());
    public static final OWLObjectBinaryType<OWLInverseObjectPropertiesAxiom> OWL_INVERSE_OBJECT_PROPERTIES = OWLObjectBinaryType.getInstance(46, OWLInverseObjectPropertiesAxiom.class, new OWLInverseObjectPropertiesAxiomSerializer());
    public static final OWLObjectBinaryType<OWLFunctionalObjectPropertyAxiom> OWL_FUNCTIONAL_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(47, OWLFunctionalObjectPropertyAxiom.class, new OWLFunctionalObjectPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLInverseFunctionalObjectPropertyAxiom> OWL_INVERSE_FUNCTIONAL_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(48, OWLInverseFunctionalObjectPropertyAxiom.class, new OWLInverseFunctionalObjectPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLReflexiveObjectPropertyAxiom> OWL_REFLEXIVE_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(49, OWLReflexiveObjectPropertyAxiom.class, new OWLReflexiveObjectPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLIrreflexiveObjectPropertyAxiom> OWL_IRREFLEXIVE_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(50, OWLIrreflexiveObjectPropertyAxiom.class, new OWLIrreflexiveObjectPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLSymmetricObjectPropertyAxiom> OWL_SYMMETRIC_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(51, OWLSymmetricObjectPropertyAxiom.class, new OWLSymmetricObjectPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLAsymmetricObjectPropertyAxiom> OWL_ASYMMETRIC_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(52, OWLAsymmetricObjectPropertyAxiom.class, new OWLAsymmetricObjectPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLTransitiveObjectPropertyAxiom> OWL_TRANSITIVE_OBJECT_PROPERTY = OWLObjectBinaryType.getInstance(53, OWLTransitiveObjectPropertyAxiom.class, new OWLTransitiveObjectPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLSubDataPropertyOfAxiom> OWL_SUB_DATA_PROPERTY_OF = OWLObjectBinaryType.getInstance(54, OWLSubDataPropertyOfAxiom.class, new OWLSubDataPropertyOfAxiomSerializer());
    public static final OWLObjectBinaryType<OWLEquivalentDataPropertiesAxiom> OWL_EQUIVALENT_DATA_PROPERTIES = OWLObjectBinaryType.getInstance(55, OWLEquivalentDataPropertiesAxiom.class, new OWLEquivalentDataPropertiesAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDisjointDataPropertiesAxiom> OWL_DISJOINT_DATA_PROPERTIES = OWLObjectBinaryType.getInstance(56, OWLDisjointDataPropertiesAxiom.class, new OWLDisjointDataPropertiesAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDataPropertyDomainAxiom> OWL_DATA_PROPERTY_DOMAIN = OWLObjectBinaryType.getInstance(57, OWLDataPropertyDomainAxiom.class, new OWLDataPropertyDomainAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDataPropertyRangeAxiom> OWL_DATA_PROPERTY_RANGE = OWLObjectBinaryType.getInstance(58, OWLDataPropertyRangeAxiom.class, new OWLDataPropertyRangeAxiomSerializer());
    public static final OWLObjectBinaryType<OWLFunctionalDataPropertyAxiom> OWL_FUNCTIONAL_DATA_PROPERTY = OWLObjectBinaryType.getInstance(59, OWLFunctionalDataPropertyAxiom.class, new OWLFunctionalDataPropertyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDatatypeDefinitionAxiom> OWL_DATATYPE_DEFINITION = OWLObjectBinaryType.getInstance(60, OWLDatatypeDefinitionAxiom.class, new OWLDatatypeDefinitionAxiomSerializer());
    public static final OWLObjectBinaryType<OWLHasKeyAxiom> OWL_HAS_KEY = OWLObjectBinaryType.getInstance(61, OWLHasKeyAxiom.class, new OWLHasKeyAxiomSerializer());
    public static final OWLObjectBinaryType<OWLSameIndividualAxiom> OWL_SAME_INDIVIDUAL = OWLObjectBinaryType.getInstance(62, OWLSameIndividualAxiom.class, new OWLSameIndividualAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDifferentIndividualsAxiom> OWL_DIFFERENT_INDIVIDUALS = OWLObjectBinaryType.getInstance(63, OWLDifferentIndividualsAxiom.class, new OWLDifferentIndividualsAxiomSerializer());
    public static final OWLObjectBinaryType<OWLClassAssertionAxiom> OWL_CLASS_ASSERTION = OWLObjectBinaryType.getInstance(64, OWLClassAssertionAxiom.class, new OWLClassAssertionAxiomSerializer());
    public static final OWLObjectBinaryType<OWLObjectPropertyAssertionAxiom> OWL_OBJECT_PROPERTY_ASSERTION = OWLObjectBinaryType.getInstance(65, OWLObjectPropertyAssertionAxiom.class, new OWLObjectPropertyAssertionSerializer());
    public static final OWLObjectBinaryType<OWLNegativeObjectPropertyAssertionAxiom> OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION = OWLObjectBinaryType.getInstance(66, OWLNegativeObjectPropertyAssertionAxiom.class, new OWLNegativeObjectPropertyAssertionAxiomSerializer());
    public static final OWLObjectBinaryType<OWLDataPropertyAssertionAxiom> OWL_DATA_PROPERTY_ASSERTION = OWLObjectBinaryType.getInstance(67, OWLDataPropertyAssertionAxiom.class, new OWLDataPropertyAssertionAxiomSerializer());
    public static final OWLObjectBinaryType<OWLNegativeDataPropertyAssertionAxiom> OWL_NEGATIVE_DATA_PROPERTY_ASSERTION = OWLObjectBinaryType.getInstance(68, OWLNegativeDataPropertyAssertionAxiom.class, new OWLNegativeDataPropertyAssertionAxiomSerializer());
    public static final OWLObjectBinaryType<OWLAnnotationAssertionAxiom> OWL_ANNOTATION_ASSERTION = OWLObjectBinaryType.getInstance(69, OWLAnnotationAssertionAxiom.class, new OWLAnnotationAssertionAxiomSerializer());
    public static final OWLObjectBinaryType<OWLSubAnnotationPropertyOfAxiom> OWL_SUB_ANNOTATION_PROPERTY_OF = OWLObjectBinaryType.getInstance(70, OWLSubAnnotationPropertyOfAxiom.class, new OWLSubAnnotationPropertyOfAxiomSerializer());
    public static final OWLObjectBinaryType<OWLAnnotationPropertyDomainAxiom> OWL_ANNOTATION_PROPERTY_DOMAIN = OWLObjectBinaryType.getInstance(71, OWLAnnotationPropertyDomainAxiom.class, new OWLAnnotationPropertyDomainAxiomSerializer());
    public static final OWLObjectBinaryType<OWLAnnotationPropertyRangeAxiom> OWL_ANNOTATION_PROPERTY_RANGE = OWLObjectBinaryType.getInstance(72, OWLAnnotationPropertyRangeAxiom.class, new OWLAnnotationPropertyRangeAxiomSerializer());
    public static final OWLObjectBinaryType<OWLAnnotation> OWL_ANNOTATION = OWLObjectBinaryType.getInstance(73, OWLAnnotation.class, new OWLAnnotationSerializer());
    public static final OWLObjectBinaryType<SWRLRule> SWRL_RULE = OWLObjectBinaryType.getInstance(74, SWRLRule.class, new SWRLRuleSerializer());
    public static final OWLObjectBinaryType<SWRLDifferentIndividualsAtom> SWRL_DIFFERENT_INDIVIDUALS_ATOM = OWLObjectBinaryType.getInstance(75, SWRLDifferentIndividualsAtom.class, new SWRLDifferentIndividualsAtomSerializer());
    public static final OWLObjectBinaryType<SWRLSameIndividualAtom> SWRL_SAME_INDIVIDUAL_ATOM = OWLObjectBinaryType.getInstance(76, SWRLSameIndividualAtom.class, new SWRLSameIndividualAtomSerializer());
    public static final OWLObjectBinaryType<SWRLClassAtom> SWRL_CLASS_ATOM = OWLObjectBinaryType.getInstance(77, SWRLClassAtom.class, new SWRLClassAtomSerializer());
    public static final OWLObjectBinaryType<SWRLDataRangeAtom> SWRL_DATA_RANGE_ATOM = OWLObjectBinaryType.getInstance(78, SWRLDataRangeAtom.class, new SWRLDataRangeAtomSerializer());
    public static final OWLObjectBinaryType<SWRLObjectPropertyAtom> SWRL_OBJECT_PROPERTY_ATOM = OWLObjectBinaryType.getInstance(79, SWRLObjectPropertyAtom.class, new SWRLObjectPropertyAtomSerializer());
    public static final OWLObjectBinaryType<SWRLDataPropertyAtom> SWRL_DATA_PROPERTY_ATOM = OWLObjectBinaryType.getInstance(80, SWRLDataPropertyAtom.class, new SWRLDataPropertyAtomSerializer());
    public static final OWLObjectBinaryType<SWRLBuiltInAtom> SWRL_BUILT_IN_ATOM = OWLObjectBinaryType.getInstance(81, SWRLBuiltInAtom.class, new SWRLBuiltInAtomSerializer());
    public static final OWLObjectBinaryType<SWRLVariable> SWRL_VARIABLE = OWLObjectBinaryType.getInstance(82, SWRLVariable.class, new SWRLVariableSerializer());
    public static final OWLObjectBinaryType<SWRLIndividualArgument> SWRL_INDIVIDUAL_ARGUMENT = OWLObjectBinaryType.getInstance(83, SWRLIndividualArgument.class, new SWRLIndividualArgumentSerializer());
    public static final OWLObjectBinaryType<SWRLLiteralArgument> SWRL_LITERAL_ARGUMENT = OWLObjectBinaryType.getInstance(84, SWRLLiteralArgument.class, new SWRLLiteralArgumentSerializer());
    private static OWLObjectBinaryTypeSelector selector;
    private byte marker;
    private Class<? extends OWLObject> cls;
    private OWLObjectSerializer<C> serializer;

    private static <C extends OWLObject> OWLObjectBinaryType<C> getInstance(int markerId, Class<C> cls, OWLObjectSerializer<C> serializer) {
        OWLObjectBinaryType<C> value = new OWLObjectBinaryType<C>(markerId, cls, serializer);
        values.add(value);
        return value;
    }

    public static List<OWLObjectBinaryType<?>> values() {
        return values;
    }

    private OWLObjectBinaryType(int marker, Class<C> c, OWLObjectSerializer<C> serializer) {
        this.marker = (byte)marker;
        this.cls = c;
        this.serializer = serializer;
    }

    public Class<? extends OWLObject> getOWLObjectClass() {
        return this.cls;
    }

    public byte getMarker() {
        return this.marker;
    }

    public OWLObjectSerializer<C> getSerializer() {
        return this.serializer;
    }

    private static <C extends OWLObject> OWLObjectBinaryType<C> getType(C object) {
        return (OWLObjectBinaryType)object.accept((OWLObjectVisitorEx)selector);
    }

    private static <T extends OWLObject> OWLObjectBinaryType<T> getType(byte typeMarker) {
        return values.get(typeMarker - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OWLObjectBinaryType(");
        sb.append("Marker(");
        sb.append(this.marker);
        sb.append(")");
        sb.append(" Class(");
        sb.append(this.cls.getSimpleName());
        sb.append(")");
        sb.append(")");
        return sb.toString();
    }

    private static void doIntegrityCheck() {
        Method[] methods = OWLObjectVisitor.class.getMethods();
        HashSet<String> typeValues = new HashSet<String>();
        HashSet<Byte> markers = new HashSet<Byte>();
        for (OWLObjectBinaryType<?> binaryType : OWLObjectBinaryType.values()) {
            String typeClassName = binaryType.getOWLObjectClass().getSimpleName();
            typeValues.add(typeClassName);
            if (markers.add(binaryType.getMarker())) continue;
            throw new RuntimeException("Duplicate marker found: " + binaryType);
        }
        for (Method method : methods) {
            Class<?>[] parameters = method.getParameterTypes();
            String simpleName = parameters[0].getSimpleName();
            if (typeValues.contains(simpleName)) continue;
            throw new RuntimeException("BinaryOWLObjectType not defined for " + simpleName);
        }
    }

    public static <C extends OWLObject> C read(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        byte typeMarker = inputStream.readByte();
        Preconditions.checkPositionIndex((int)typeMarker, (int)84, (String)("Invalid type marker: " + typeMarker));
        OWLObjectBinaryType type = OWLObjectBinaryType.getType(typeMarker);
        return (C)type.getSerializer().read(inputStream);
    }

    public static void write(OWLObject object, BinaryOWLOutputStream outputStream) throws IOException {
        OWLObjectBinaryType<OWLObject> type = OWLObjectBinaryType.getType(object);
        outputStream.writeByte(type.getMarker());
        OWLObjectSerializer<OWLObject> serializer = type.getSerializer();
        serializer.write(object, outputStream);
    }

    static {
        ArrayList vals = new ArrayList(values);
        Collections.sort(vals, new Comparator<OWLObjectBinaryType<?>>(){

            @Override
            public int compare(OWLObjectBinaryType<?> o1, OWLObjectBinaryType<?> o2) {
                return o1.getMarker() - o2.getMarker();
            }
        });
        values = Collections.unmodifiableList(vals);
        OWLObjectBinaryType.doIntegrityCheck();
        selector = new OWLObjectBinaryTypeSelector();
    }
}

