/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import java.io.IOException;
import java.nio.charset.Charset;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplNoCompression;

public class OWLLiteralSerializer
extends OWLObjectSerializer<OWLLiteral> {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte RDF_PLAIN_LITERAL_MARKER = 0;
    private static final byte XSD_STRING_MARKER = 1;
    private static final byte XSD_BOOLEAN_MARKER = 2;
    private static final byte OTHER_DATATYPE_MARKER = 3;
    private static final byte LANG_MARKER = 1;
    private static final byte NO_LANG_MARKER = 0;
    private static final OWLDatatype RDF_PLAIN_LITERAL_DATATYPE = new OWLDatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    private static final OWLDatatype XSD_STRING_DATATYPE = new OWLDatatypeImpl(OWL2Datatype.XSD_STRING.getIRI());
    private static final OWLDatatype XSD_BOOLEAN_DATATYPE = new OWLDatatypeImpl(OWL2Datatype.XSD_BOOLEAN.getIRI());
    private static final OWLLiteral BOOLEAN_TRUE = new OWLLiteralImplNoCompression("true", null, XSD_BOOLEAN_DATATYPE);
    private static final OWLLiteral BOOLEAN_FALSE = new OWLLiteralImplNoCompression("false", null, XSD_BOOLEAN_DATATYPE);

    @Override
    protected void writeObject(OWLLiteral object, BinaryOWLOutputStream outputStream) throws IOException {
        this.writeRawLiteral(outputStream, object);
    }

    @Override
    protected OWLLiteral readObject(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        return this.readRawLiteral(inputStream);
    }

    private OWLLiteral readRawLiteral(BinaryOWLInputStream is) throws IOException {
        byte typeMarker = is.readByte();
        if (typeMarker == 0) {
            byte langMarker = is.readByte();
            if (langMarker == 1) {
                String lang = is.readUTF();
                byte[] literalBytes = this.readBytes(is);
                return is.getDataFactory().getOWLLiteral(new String(literalBytes, UTF_8), lang);
            }
            if (langMarker == 0) {
                byte[] literalBytes = this.readBytes(is);
                return is.getDataFactory().getOWLLiteral(new String(literalBytes, UTF_8), RDF_PLAIN_LITERAL_DATATYPE);
            }
            throw new IOException("Unknown lang marker: " + langMarker);
        }
        if (typeMarker == 1) {
            byte[] literalBytes = this.readBytes(is);
            return is.getDataFactory().getOWLLiteral(new String(literalBytes, UTF_8), XSD_STRING_DATATYPE);
        }
        if (typeMarker == 2) {
            if (is.readBoolean()) {
                return BOOLEAN_TRUE;
            }
            return BOOLEAN_FALSE;
        }
        if (typeMarker == 3) {
            OWLDatatype datatype = is.readDatatypeIRI();
            byte[] literalBytes = this.readBytes(is);
            return is.getDataFactory().getOWLLiteral(new String(literalBytes, UTF_8), datatype);
        }
        throw new RuntimeException("Unknown type marker: " + typeMarker);
    }

    private void writeRawLiteral(BinaryOWLOutputStream outputStream, OWLLiteral literal) throws IOException {
        if (literal.getDatatype().equals(XSD_BOOLEAN_DATATYPE)) {
            outputStream.writeByte(2);
            outputStream.writeBoolean(literal.parseBoolean());
            return;
        }
        if (literal.isRDFPlainLiteral()) {
            outputStream.writeByte(0);
            if (literal.hasLang()) {
                outputStream.write(1);
                this.writeString(literal.getLang(), outputStream);
            } else {
                outputStream.writeByte(0);
            }
        } else if (literal.getDatatype().equals(XSD_STRING_DATATYPE)) {
            outputStream.writeByte(1);
        } else {
            outputStream.writeByte(3);
            outputStream.writeIRI(literal.getDatatype().getIRI());
        }
        byte[] literalBytes = literal instanceof OWLLiteralImplNoCompression ? ((OWLLiteralImplNoCompression)literal).getLiteral().getBytes(UTF_8) : literal.getLiteral().getBytes(UTF_8);
        this.writeBytes(literalBytes, outputStream);
    }

    private void writeString(String s, BinaryOWLOutputStream outputStream) throws IOException {
        outputStream.writeUTF(s);
    }

    private void writeBytes(byte[] bytes, BinaryOWLOutputStream os) throws IOException {
        if (os.getVersion().getVersion() <= 2) {
            if (bytes.length >= Short.MAX_VALUE) {
                throw new IOException("Cannot store byte array that is equal or longer to Short.MAX_VALUE");
            }
            os.writeShort(bytes.length);
            os.write(bytes);
        } else {
            os.writeVarInt(bytes.length);
            os.write(bytes);
        }
    }

    private byte[] readBytes(BinaryOWLInputStream is) throws IOException {
        if (is.getVersion().getVersion() <= 2) {
            short length = is.readShort();
            byte[] bytes = new byte[length];
            is.readFully(bytes);
            return bytes;
        }
        int length = is.readVarInt();
        byte[] bytes = new byte[length];
        is.readFully(bytes);
        return bytes;
    }
}

