/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.stream;

import com.google.common.io.CountingInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.BinaryOWLVersion;
import org.semanticweb.binaryowl.lookup.IRILookupTable;
import org.semanticweb.binaryowl.lookup.LookupTable;
import org.semanticweb.binaryowl.owlobject.OWLObjectBinaryType;
import org.semanticweb.binaryowl.stream.BinaryOWLStreamUtil;
import org.semanticweb.binaryowl.stream.VarInt;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class BinaryOWLInputStream
extends InputStream {
    private DataInputStream dataInput;
    private ArrayDeque<LookupTable> lookupTableStack;
    private OWLDataFactory dataFactory;
    private BinaryOWLVersion version;
    private ArrayList<OWLAnonymousIndividual> anonIndividualList = new ArrayList();
    private final CountingInputStream countingInputStream;
    private Map<Integer, OWLAnonymousIndividual> map = new HashMap<Integer, OWLAnonymousIndividual>();

    public BinaryOWLInputStream(InputStream inputStream, OWLDataFactory dataFactory, BinaryOWLVersion version) {
        this(inputStream, BinaryOWLInputStream.createEmptyLookupTable(dataFactory), dataFactory, version);
    }

    private static LookupTable createEmptyLookupTable(OWLDataFactory dataFactory) {
        return LookupTable.emptyLookupTable();
    }

    public BinaryOWLInputStream(InputStream inputStream, LookupTable lookupTable, OWLDataFactory dataFactory, BinaryOWLVersion version) {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.dataInput = new DataInputStream((InputStream)this.countingInputStream);
        this.lookupTableStack = new ArrayDeque();
        this.lookupTableStack.push(lookupTable);
        this.dataFactory = dataFactory;
        this.version = version;
    }

    public long getBytesRead() {
        return this.countingInputStream.getCount();
    }

    public void pushLookupTable(LookupTable lookupTable) {
        this.lookupTableStack.push(lookupTable);
    }

    public LookupTable popLookupTable() {
        if (this.lookupTableStack.size() == 1) {
            throw new RuntimeException("Cannot pop last LookupTable from the lookup table stack");
        }
        return this.lookupTableStack.pop();
    }

    private LookupTable peekLookupTable() {
        return this.lookupTableStack.peek();
    }

    public BinaryOWLVersion getVersion() {
        return this.version;
    }

    public void setVersion(BinaryOWLVersion version) {
        this.version = version;
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public <O extends OWLObject> O readOWLObject() throws IOException, BinaryOWLParseException {
        return (O)OWLObjectBinaryType.read(this);
    }

    public <O extends OWLObject> Set<O> readOWLObjects() throws IOException, BinaryOWLParseException {
        int length = BinaryOWLStreamUtil.readVariableLengthUnsignedInt(this.dataInput);
        if (length == 0) {
            return Collections.emptySet();
        }
        BinaryOWLStreamUtil.ListBackedSet result = new BinaryOWLStreamUtil.ListBackedSet(length + 2);
        for (int i = 0; i < length; ++i) {
            O object = this.readOWLObject();
            result.add(object);
        }
        return result;
    }

    public <O extends OWLObject> List<O> readOWLObjectList() throws IOException, BinaryOWLParseException {
        int size = BinaryOWLStreamUtil.readVariableLengthUnsignedInt(this.dataInput);
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<O> result = new ArrayList<O>();
        for (int i = 0; i < size; ++i) {
            O element = this.readOWLObject();
            result.add(element);
        }
        return result;
    }

    public IRI readIRI() throws IOException {
        return this.peekLookupTable().readIRI(this.dataInput);
    }

    public OWLClass readClassIRI() throws IOException {
        return this.peekLookupTable().readClassIRI(this.dataInput);
    }

    public OWLObjectProperty readObjectPropertyIRI() throws IOException {
        return this.peekLookupTable().readObjectPropertyIRI(this.dataInput);
    }

    public OWLDataProperty readDataPropertyIRI() throws IOException {
        return this.peekLookupTable().readDataPropertyIRI(this.dataInput);
    }

    public OWLAnnotationProperty readAnnotationPropertyIRI() throws IOException {
        return this.peekLookupTable().readAnnotationPropertyIRI(this.dataInput);
    }

    public OWLNamedIndividual readIndividualIRI() throws IOException {
        return this.peekLookupTable().readIndividualIRI(this.dataInput);
    }

    public OWLDatatype readDatatypeIRI() throws IOException {
        return this.peekLookupTable().readDatatypeIRI(this.dataInput);
    }

    public IRILookupTable readIRILookupTable() throws IOException {
        return new IRILookupTable(this.dataInput);
    }

    public OWLAnonymousIndividual readAnonymousIndividual() throws IOException {
        OWLAnonymousIndividual ind;
        int id = this.readInt();
        if (id > 100000) {
            return this.dataFactory.getOWLAnonymousIndividual(Integer.toString(id));
        }
        if (id == this.anonIndividualList.size()) {
            OWLAnonymousIndividual ind2 = this.dataFactory.getOWLAnonymousIndividual(Integer.toString(id));
            this.anonIndividualList.add(ind2);
            return ind2;
        }
        this.anonIndividualList.ensureCapacity(id);
        if (id < this.anonIndividualList.size()) {
            ind = this.anonIndividualList.get(id);
            if (ind == null) {
                ind = this.dataFactory.getOWLAnonymousIndividual(Integer.toString(id));
                this.anonIndividualList.set(id, ind);
            }
        } else {
            for (int i = this.anonIndividualList.size(); i < id + 1; ++i) {
                this.anonIndividualList.add(null);
            }
            ind = this.dataFactory.getOWLAnonymousIndividual(Integer.toString(id));
            this.anonIndividualList.set(id, ind);
        }
        return ind;
    }

    public boolean readBoolean() throws IOException {
        return this.dataInput.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataInput.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dataInput.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dataInput.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dataInput.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dataInput.readChar();
    }

    public int readInt() throws IOException {
        return this.dataInput.readInt();
    }

    public long readLong() throws IOException {
        return this.dataInput.readLong();
    }

    public float readFloat() throws IOException {
        return this.dataInput.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dataInput.readDouble();
    }

    @Deprecated
    public String readLine() throws IOException {
        return this.dataInput.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataInput.readUTF();
    }

    public void readFully(byte[] bytes) throws IOException {
        this.dataInput.readFully(bytes);
    }

    public void skipBytes(int n) throws IOException {
        this.dataInput.skipBytes(n);
    }

    @Override
    public int read() throws IOException {
        return this.dataInput.read();
    }

    public int readVarInt() throws IOException {
        return VarInt.readVarInt(this.dataInput);
    }
}

