/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.stream;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLVersion;
import org.semanticweb.binaryowl.lookup.LookupTable;
import org.semanticweb.binaryowl.owlobject.OWLObjectBinaryType;
import org.semanticweb.binaryowl.stream.BinaryOWLStreamUtil;
import org.semanticweb.binaryowl.stream.PassThroughSetTransformer;
import org.semanticweb.binaryowl.stream.SetTransformer;
import org.semanticweb.binaryowl.stream.VarInt;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLObject;

public class BinaryOWLOutputStream
extends OutputStream {
    private final DataOutput dataOutput;
    private final LookupTable lookupTable;
    private final BinaryOWLVersion version;
    private final SetTransformer setTransformer;

    public BinaryOWLOutputStream(OutputStream dataOutput, BinaryOWLVersion version) {
        this.dataOutput = dataOutput instanceof DataOutputStream ? (DataOutput)((Object)dataOutput) : new DataOutputStream(dataOutput);
        this.version = version;
        this.lookupTable = LookupTable.emptyLookupTable();
        this.setTransformer = new PassThroughSetTransformer();
    }

    public BinaryOWLOutputStream(DataOutput dataOutput, LookupTable lookupTable, BinaryOWLVersion version) {
        this.dataOutput = dataOutput;
        this.lookupTable = lookupTable;
        this.setTransformer = new PassThroughSetTransformer();
        this.version = version;
    }

    public BinaryOWLVersion getVersion() {
        return this.version;
    }

    public void writeOWLObject(OWLObject object) throws IOException {
        OWLObjectBinaryType.write(object, this);
    }

    public void writeOWLObjects(Set<? extends OWLObject> objects) throws IOException {
        int size = objects.size();
        BinaryOWLStreamUtil.writeCollectionSize(size, this.dataOutput);
        for (OWLObject oWLObject : this.setTransformer.transform(objects)) {
            this.writeOWLObject(oWLObject);
        }
    }

    public void writeOWLObjectList(List<? extends OWLObject> list) throws IOException {
        BinaryOWLStreamUtil.writeCollectionSize(list.size(), this.dataOutput);
        for (OWLObject oWLObject : list) {
            this.writeOWLObject(oWLObject);
        }
    }

    public void writeIRI(IRI iri) throws IOException {
        this.lookupTable.writeIRI(iri, this.dataOutput);
    }

    public void writeAnonymousIndividual(OWLAnonymousIndividual individual) throws IOException {
        int index = this.lookupTable.getAnonymousIndividualLookupTable().getIndex(individual);
        this.dataOutput.writeInt(index);
    }

    @Override
    public void write(int b) throws IOException {
        this.dataOutput.write(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.dataOutput.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.dataOutput.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.dataOutput.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.dataOutput.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.dataOutput.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.dataOutput.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.dataOutput.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.dataOutput.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.dataOutput.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.dataOutput.writeChars(s);
    }

    public void writeUTF(String s) throws IOException {
        this.dataOutput.writeUTF(s);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.dataOutput.write(bytes);
    }

    public void writeVarInt(int value) throws IOException {
        VarInt.writeVarInt(this.dataOutput, value);
    }
}

