/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.HermiT.structural.ExpressionManager;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OWLNormalization {
    protected final OWLDataFactory m_factory;
    protected final OWLAxioms m_axioms;
    protected final int m_firstReplacementIndex;
    protected final Map<OWLClassExpression, OWLClassExpression> m_definitions;
    protected final Map<OWLObjectOneOf, OWLClass> m_definitionsForNegativeNominals;
    protected final ExpressionManager m_expressionManager;
    protected final PLVisitor m_plVisitor;
    protected final Map<OWLDataRange, OWLDatatype> m_dataRangeDefinitions;

    public OWLNormalization(OWLDataFactory factory, OWLAxioms axioms, int firstReplacementIndex) {
        this.m_factory = factory;
        this.m_axioms = axioms;
        this.m_firstReplacementIndex = firstReplacementIndex;
        this.m_definitions = new HashMap<OWLClassExpression, OWLClassExpression>();
        this.m_definitionsForNegativeNominals = new HashMap<OWLObjectOneOf, OWLClass>();
        this.m_expressionManager = new ExpressionManager(this.m_factory);
        this.m_plVisitor = new PLVisitor();
        this.m_dataRangeDefinitions = new HashMap<OWLDataRange, OWLDatatype>();
    }

    public void processOntology(OWLOntology ontology) {
        OWLAPIStreamUtils.add(this.m_axioms.m_classes, (Stream)ontology.classesInSignature(Imports.INCLUDED));
        OWLAPIStreamUtils.add(this.m_axioms.m_objectProperties, (Stream)ontology.objectPropertiesInSignature(Imports.INCLUDED));
        OWLAPIStreamUtils.add(this.m_axioms.m_dataProperties, (Stream)ontology.dataPropertiesInSignature(Imports.INCLUDED));
        OWLAPIStreamUtils.add(this.m_axioms.m_namedIndividuals, (Stream)ontology.individualsInSignature(Imports.INCLUDED));
        this.processAxioms(ontology.logicalAxioms());
    }

    public void processAxioms(Stream<? extends OWLAxiom> axioms) {
        AxiomVisitor axiomVisitor = new AxiomVisitor();
        axioms.forEach(ax -> ax.accept((OWLAxiomVisitor)axiomVisitor));
        RuleNormalizer ruleNormalizer = new RuleNormalizer(this.m_axioms.m_rules, axiomVisitor.m_classExpressionInclusionsAsDisjunctions, axiomVisitor.m_dataRangeInclusionsAsDisjunctions);
        for (SWRLRule rule : axiomVisitor.m_rules) {
            ruleNormalizer.visit(rule);
        }
        this.normalizeInclusions(axiomVisitor.m_classExpressionInclusionsAsDisjunctions, axiomVisitor.m_dataRangeInclusionsAsDisjunctions);
    }

    protected void addFact(OWLIndividualAxiom axiom) {
        this.m_axioms.m_facts.add(axiom);
    }

    protected void addInclusion(OWLObjectPropertyExpression subObjectPropertyExpression, OWLObjectPropertyExpression superObjectPropertyExpression) {
        this.m_axioms.m_simpleObjectPropertyInclusions.add(Arrays.asList(subObjectPropertyExpression, superObjectPropertyExpression));
    }

    protected void addInclusion(OWLObjectPropertyExpression[] subObjectPropertyExpressions, OWLObjectPropertyExpression superObjectPropertyExpression) {
        for (int index = subObjectPropertyExpressions.length - 1; index >= 0; --index) {
            subObjectPropertyExpressions[index] = subObjectPropertyExpressions[index];
        }
        this.m_axioms.m_complexObjectPropertyInclusions.add(new OWLAxioms.ComplexObjectPropertyInclusion(subObjectPropertyExpressions, superObjectPropertyExpression));
    }

    protected void addInclusion(OWLDataPropertyExpression subDataPropertyExpression, OWLDataPropertyExpression superDataPropertyExpression) {
        this.m_axioms.m_dataPropertyInclusions.add(Arrays.asList(subDataPropertyExpression, superDataPropertyExpression));
    }

    protected void makeTransitive(OWLObjectPropertyExpression objectPropertyExpression) {
        this.m_axioms.m_complexObjectPropertyInclusions.add(new OWLAxioms.ComplexObjectPropertyInclusion(objectPropertyExpression));
    }

    protected void makeReflexive(OWLObjectPropertyExpression objectPropertyExpression) {
        this.m_axioms.m_reflexiveObjectProperties.add(objectPropertyExpression);
    }

    protected void makeIrreflexive(OWLObjectPropertyExpression objectPropertyExpression) {
        this.m_axioms.m_irreflexiveObjectProperties.add(objectPropertyExpression);
    }

    protected void makeAsymmetric(OWLObjectPropertyExpression objectPropertyExpression) {
        this.m_axioms.m_asymmetricObjectProperties.add(objectPropertyExpression);
    }

    protected static boolean isSimple(OWLClassExpression description) {
        return description instanceof OWLClass || description instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)description).getOperand() instanceof OWLClass;
    }

    protected static boolean isLiteral(OWLDataRange dr) {
        return OWLNormalization.isAtomic(dr) || OWLNormalization.isNegatedAtomic(dr);
    }

    protected static boolean isAtomic(OWLDataRange dr) {
        return dr instanceof OWLDatatype || dr instanceof OWLDatatypeRestriction || dr instanceof OWLDataOneOf;
    }

    protected static boolean isNegatedAtomic(OWLDataRange dr) {
        return dr instanceof OWLDataComplementOf && OWLNormalization.isAtomic(((OWLDataComplementOf)dr).getDataRange());
    }

    protected static boolean isNominal(OWLClassExpression description) {
        return description instanceof OWLObjectOneOf;
    }

    protected static boolean isNegatedOneNominal(OWLClassExpression description) {
        if (!(description instanceof OWLObjectComplementOf)) {
            return false;
        }
        OWLClassExpression operand = ((OWLObjectComplementOf)description).getOperand();
        if (!(operand instanceof OWLObjectOneOf)) {
            return false;
        }
        return ((OWLObjectOneOf)operand).individuals().count() == 1L;
    }

    protected void normalizeInclusions(List<List<OWLClassExpression>> inclusions, List<List<OWLDataRange>> dataRangeInclusions) {
        ClassExpressionNormalizer classExpressionNormalizer = new ClassExpressionNormalizer(inclusions, dataRangeInclusions);
        while (!inclusions.isEmpty()) {
            OWLClassExpression simplifiedDescription = this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified((OWLClassExpression)this.m_factory.getOWLObjectUnionOf((Collection)inclusions.remove(inclusions.size() - 1))));
            if (simplifiedDescription.isOWLThing()) continue;
            if (simplifiedDescription instanceof OWLObjectUnionOf) {
                OWLObjectUnionOf objectOr = (OWLObjectUnionOf)simplifiedDescription;
                List descriptions = OWLAPIStreamUtils.asList((Stream)objectOr.operands(), OWLClassExpression.class);
                if (this.distributeUnionOverAndObject(descriptions, inclusions) || this.optimizedNegativeOneOfTranslation(descriptions, this.m_axioms.m_facts)) continue;
                for (int index = 0; index < descriptions.size(); ++index) {
                    descriptions.set(index, ((OWLClassExpression)descriptions.get(index)).accept((OWLClassExpressionVisitorEx)classExpressionNormalizer));
                }
                this.m_axioms.m_conceptInclusions.add(descriptions);
                continue;
            }
            if (simplifiedDescription instanceof OWLObjectIntersectionOf) {
                OWLObjectIntersectionOf objectAnd = (OWLObjectIntersectionOf)simplifiedDescription;
                objectAnd.operands().forEach(c -> inclusions.add(Arrays.asList(c)));
                continue;
            }
            OWLClassExpression normalized = (OWLClassExpression)simplifiedDescription.accept((OWLClassExpressionVisitorEx)classExpressionNormalizer);
            this.m_axioms.m_conceptInclusions.add(Arrays.asList(normalized));
        }
        DataRangeNormalizer dataRangeNormalizer = new DataRangeNormalizer(dataRangeInclusions);
        while (!dataRangeInclusions.isEmpty()) {
            OWLDataRange simplifiedDescription = this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified((OWLDataRange)this.m_factory.getOWLDataUnionOf((Collection)dataRangeInclusions.remove(classExpressionNormalizer.m_newDataRangeInclusions.size() - 1))));
            if (simplifiedDescription.isTopDatatype()) continue;
            if (simplifiedDescription instanceof OWLDataUnionOf) {
                OWLDataUnionOf dataOr = (OWLDataUnionOf)simplifiedDescription;
                List descriptions = OWLAPIStreamUtils.asList((Stream)dataOr.operands(), OWLDataRange.class);
                if (this.distributeUnionOverAnd(descriptions, dataRangeInclusions)) continue;
                for (int index = 0; index < descriptions.size(); ++index) {
                    descriptions.set(index, ((OWLDataRange)descriptions.get(index)).accept((OWLDataVisitorEx)dataRangeNormalizer));
                }
                this.m_axioms.m_dataRangeInclusions.add(descriptions);
                continue;
            }
            if (simplifiedDescription instanceof OWLDataIntersectionOf) {
                OWLDataIntersectionOf dataAnd = (OWLDataIntersectionOf)simplifiedDescription;
                dataAnd.operands().forEach(d -> dataRangeInclusions.add(Arrays.asList(d)));
                continue;
            }
            OWLDataRange normalized = (OWLDataRange)simplifiedDescription.accept((OWLDataVisitorEx)dataRangeNormalizer);
            dataRangeInclusions.add(Arrays.asList(normalized));
        }
    }

    protected boolean distributeUnionOverAndObject(List<OWLClassExpression> descriptions, List<List<OWLClassExpression>> inclusions) {
        int andIndex = -1;
        for (int index = 0; index < descriptions.size(); ++index) {
            OWLClassExpression description2 = descriptions.get(index);
            if (OWLNormalization.isSimple(description2)) continue;
            if (description2 instanceof OWLObjectIntersectionOf) {
                if (andIndex == -1) {
                    andIndex = index;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (andIndex == -1) {
            return false;
        }
        OWLObjectIntersectionOf objectAnd = (OWLObjectIntersectionOf)descriptions.get(andIndex);
        int index = andIndex;
        objectAnd.operands().forEach(description -> {
            ArrayList<OWLClassExpression> newDescriptions = new ArrayList<OWLClassExpression>(descriptions);
            newDescriptions.set(index, (OWLClassExpression)description);
            inclusions.add(newDescriptions);
        });
        return true;
    }

    protected boolean distributeUnionOverAnd(List<OWLDataRange> descriptions, List<List<OWLDataRange>> inclusions) {
        int andIndex = -1;
        for (int index = 0; index < descriptions.size(); ++index) {
            OWLDataRange description = descriptions.get(index);
            if (OWLNormalization.isLiteral(description)) continue;
            if (description instanceof OWLDataIntersectionOf) {
                if (andIndex == -1) {
                    andIndex = index;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (andIndex == -1) {
            return false;
        }
        int indexToUse = andIndex;
        OWLDataIntersectionOf dataAnd = (OWLDataIntersectionOf)descriptions.get(andIndex);
        dataAnd.operands().forEach(d -> {
            ArrayList<OWLDataRange> newDescriptions = new ArrayList<OWLDataRange>(descriptions);
            newDescriptions.set(indexToUse, (OWLDataRange)d);
            inclusions.add(newDescriptions);
        });
        return true;
    }

    protected boolean optimizedNegativeOneOfTranslation(List<OWLClassExpression> descriptions, Collection<OWLIndividualAxiom> facts) {
        if (descriptions.size() == 2) {
            OWLObjectOneOf nominal = null;
            OWLClassExpression other = null;
            if (descriptions.get(0) instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)descriptions.get(0)).getOperand() instanceof OWLObjectOneOf) {
                nominal = (OWLObjectOneOf)((OWLObjectComplementOf)descriptions.get(0)).getOperand();
                other = descriptions.get(1);
            } else if (descriptions.get(1) instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)descriptions.get(1)).getOperand() instanceof OWLObjectOneOf) {
                other = descriptions.get(0);
                nominal = (OWLObjectOneOf)((OWLObjectComplementOf)descriptions.get(1)).getOperand();
            }
            if (nominal != null && (other instanceof OWLClass || other instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)other).getOperand() instanceof OWLClass)) {
                assert (other != null);
                OWLClassExpression finalother = other;
                nominal.individuals().forEach(i -> facts.add((OWLIndividualAxiom)this.m_factory.getOWLClassAssertionAxiom(finalother, i)));
                return true;
            }
        }
        return false;
    }

    protected OWLClassExpression getDefinitionFor(OWLClassExpression description, boolean[] alreadyExists, boolean forcePositive) {
        OWLClassExpression definition = this.m_definitions.get(description);
        if (definition == null || forcePositive && !(definition instanceof OWLClass)) {
            definition = this.m_factory.getOWLClass(IRI.create((String)"internal:def#", (String)("a" + (this.m_definitions.size() + this.m_firstReplacementIndex))));
            if (!forcePositive && !((Boolean)description.accept((OWLClassExpressionVisitorEx)this.m_plVisitor)).booleanValue()) {
                definition = this.m_factory.getOWLObjectComplementOf(definition);
            }
            this.m_definitions.put(description, definition);
            alreadyExists[0] = false;
        } else {
            alreadyExists[0] = true;
        }
        return definition;
    }

    protected OWLDatatype getDefinitionFor(OWLDataRange dr, boolean[] alreadyExists) {
        OWLDatatype definition = this.m_dataRangeDefinitions.get(dr);
        if (definition == null) {
            definition = this.m_factory.getOWLDatatype(IRI.create((String)"internal:defdata#", (String)("a" + this.m_dataRangeDefinitions.size())));
            this.m_dataRangeDefinitions.put(dr, definition);
            alreadyExists[0] = false;
        } else {
            alreadyExists[0] = true;
        }
        return definition;
    }

    protected OWLClassExpression getDefinitionFor(OWLClassExpression description, boolean[] alreadyExists) {
        return this.getDefinitionFor(description, alreadyExists, false);
    }

    protected OWLClass getClassFor(OWLClassExpression description, boolean[] alreadyExists) {
        return (OWLClass)this.getDefinitionFor(description, alreadyExists, true);
    }

    protected OWLClass getDefinitionForNegativeNominal(OWLObjectOneOf nominal, boolean[] alreadyExists) {
        OWLClass definition = this.m_definitionsForNegativeNominals.get(nominal);
        if (definition == null) {
            definition = this.m_factory.getOWLClass(IRI.create((String)"internal:nnq#", (String)("b" + this.m_definitionsForNegativeNominals.size())));
            this.m_definitionsForNegativeNominals.put(nominal, definition);
            alreadyExists[0] = false;
        } else {
            alreadyExists[0] = true;
        }
        return definition;
    }

    protected OWLClassExpression positive(OWLClassExpression description) {
        return this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified(description));
    }

    protected OWLClassExpression negative(OWLClassExpression description) {
        return this.m_expressionManager.getComplementNNF(this.m_expressionManager.getSimplified(description));
    }

    protected OWLDataRange positive(OWLDataRange dataRange) {
        return this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified(dataRange));
    }

    protected OWLDataRange negative(OWLDataRange dataRange) {
        return this.m_expressionManager.getComplementNNF(this.m_expressionManager.getSimplified(dataRange));
    }

    protected class PLVisitor
    implements OWLClassExpressionVisitorEx<Boolean> {
        protected PLVisitor() {
        }

        public <T> Boolean doDefault(T object) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLClass object) {
            if (object.isOWLThing()) {
                return Boolean.FALSE;
            }
            if (object.isOWLNothing()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectIntersectionOf object) {
            return object.operands().anyMatch(d -> (Boolean)d.accept((OWLClassExpressionVisitorEx)this));
        }

        public Boolean visit(OWLObjectUnionOf object) {
            return object.operands().anyMatch(d -> (Boolean)d.accept((OWLClassExpressionVisitorEx)this));
        }

        public Boolean visit(OWLObjectComplementOf object) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectAllValuesFrom object) {
            return (Boolean)((OWLClassExpression)object.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }

        public Boolean visit(OWLObjectMinCardinality object) {
            return object.getCardinality() > 0;
        }

        public Boolean visit(OWLObjectMaxCardinality object) {
            return object.getCardinality() > 0 ? Boolean.TRUE : (Boolean)OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)object.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }

        public Boolean visit(OWLObjectExactCardinality object) {
            return object.getCardinality() > 0 ? Boolean.TRUE : (Boolean)OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)object.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }
    }

    protected final class RuleNormalizer
    implements SWRLObjectVisitor {
        protected final Collection<OWLAxioms.DisjunctiveRule> m_rules;
        protected final Collection<List<OWLClassExpression>> m_classExpressionInclusions;
        protected final Collection<List<OWLDataRange>> m_dataRangeInclusions;
        protected final boolean[] m_alreadyExists;
        protected final List<SWRLAtom> m_bodyAtoms = new ArrayList<SWRLAtom>();
        protected final List<SWRLAtom> m_headAtoms = new ArrayList<SWRLAtom>();
        protected final Set<SWRLAtom> m_normalizedBodyAtoms = new HashSet<SWRLAtom>();
        protected final Set<SWRLAtom> m_normalizedHeadAtoms = new HashSet<SWRLAtom>();
        protected final Map<SWRLVariable, SWRLVariable> m_variableRepresentative = new HashMap<SWRLVariable, SWRLVariable>();
        protected final Map<OWLNamedIndividual, SWRLVariable> m_individualsToVariables = new HashMap<OWLNamedIndividual, SWRLVariable>();
        protected final Set<SWRLVariable> m_bodyDataRangeVariables = new HashSet<SWRLVariable>();
        protected final Set<SWRLVariable> m_headDataRangeVariables = new HashSet<SWRLVariable>();
        protected int m_newVariableIndex = 0;
        protected boolean m_isPositive;

        public RuleNormalizer(Collection<OWLAxioms.DisjunctiveRule> rules, Collection<List<OWLClassExpression>> classExpressionInclusionsFromRules, Collection<List<OWLDataRange>> newDataRangeInclusions) {
            this.m_rules = rules;
            this.m_classExpressionInclusions = classExpressionInclusionsFromRules;
            this.m_dataRangeInclusions = newDataRangeInclusions;
            this.m_alreadyExists = new boolean[1];
        }

        public void visit(SWRLRule rule) {
            for (SWRLAtom headAtom : OWLAPIStreamUtils.asList((Stream)rule.head())) {
                this.m_individualsToVariables.clear();
                this.m_bodyAtoms.clear();
                this.m_headAtoms.clear();
                this.m_variableRepresentative.clear();
                this.m_normalizedBodyAtoms.clear();
                this.m_normalizedHeadAtoms.clear();
                this.m_bodyDataRangeVariables.clear();
                this.m_headDataRangeVariables.clear();
                OWLAPIStreamUtils.add(this.m_bodyAtoms, (Stream)rule.body());
                this.m_headAtoms.add(headAtom);
                for (SWRLAtom atom : OWLAPIStreamUtils.asList((Stream)rule.body())) {
                    if (!(atom instanceof SWRLSameIndividualAtom)) continue;
                    this.m_bodyAtoms.remove(atom);
                    SWRLSameIndividualAtom sameIndividualAtom = (SWRLSameIndividualAtom)atom;
                    SWRLVariable variable1 = this.getVariableFor((SWRLIArgument)sameIndividualAtom.getFirstArgument());
                    SWRLIArgument argument2 = (SWRLIArgument)sameIndividualAtom.getSecondArgument();
                    if (argument2 instanceof SWRLVariable) {
                        this.m_variableRepresentative.put((SWRLVariable)argument2, variable1);
                        continue;
                    }
                    OWLIndividual individual = ((SWRLIndividualArgument)argument2).getIndividual();
                    if (individual.isAnonymous()) {
                        throw new IllegalArgumentException("Internal error: Rules with anonymous individuals are not supported. ");
                    }
                    this.m_individualsToVariables.put(individual.asOWLNamedIndividual(), variable1);
                    this.m_bodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)OWLNormalization.this.m_factory.getOWLObjectOneOf(new OWLIndividual[]{individual}), (SWRLIArgument)variable1));
                }
                this.m_isPositive = true;
                while (!this.m_headAtoms.isEmpty()) {
                    this.m_headAtoms.remove(0).accept((SWRLObjectVisitor)this);
                }
                this.m_isPositive = false;
                while (!this.m_bodyAtoms.isEmpty()) {
                    this.m_bodyAtoms.remove(0).accept((SWRLObjectVisitor)this);
                }
                if (!this.m_bodyDataRangeVariables.containsAll(this.m_headDataRangeVariables)) {
                    throw new IllegalArgumentException("A SWRL rule contains data range variables in the head, but not in the body, and this is not supported.");
                }
                this.m_rules.add(new OWLAxioms.DisjunctiveRule(this.m_normalizedBodyAtoms.toArray(new SWRLAtom[this.m_normalizedBodyAtoms.size()]), this.m_normalizedHeadAtoms.toArray(new SWRLAtom[this.m_normalizedHeadAtoms.size()])));
            }
        }

        public void visit(SWRLClassAtom at) {
            OWLClassExpression c = OWLNormalization.this.m_expressionManager.getSimplified(OWLNormalization.this.m_expressionManager.getNNF(at.getPredicate()));
            SWRLVariable variable = this.getVariableFor((SWRLIArgument)at.getArgument());
            if (this.m_isPositive) {
                if (c instanceof OWLClass) {
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom(c, (SWRLIArgument)variable));
                } else {
                    OWLClass definition = OWLNormalization.this.getClassFor(at.getPredicate(), this.m_alreadyExists);
                    if (!this.m_alreadyExists[0]) {
                        this.m_classExpressionInclusions.add(Arrays.asList(OWLNormalization.this.negative((OWLClassExpression)definition), at.getPredicate()));
                    }
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)definition, (SWRLIArgument)variable));
                }
            } else if (c instanceof OWLClass) {
                this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom(c, (SWRLIArgument)variable));
            } else {
                OWLClass definition = OWLNormalization.this.getClassFor(at.getPredicate(), this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_classExpressionInclusions.add(Arrays.asList(OWLNormalization.this.negative(at.getPredicate()), definition));
                }
                this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)definition, (SWRLIArgument)variable));
            }
        }

        public void visit(SWRLDataRangeAtom at) {
            OWLDataRange dr = at.getPredicate();
            SWRLDArgument argument = (SWRLDArgument)at.getArgument();
            if (!(argument instanceof SWRLVariable)) {
                throw new IllegalArgumentException("A SWRL rule contains a data range with an argument that is not a literal, and such rules are not supported.");
            }
            if (!this.m_isPositive) {
                dr = OWLNormalization.this.m_factory.getOWLDataComplementOf(dr);
            }
            if ((dr = OWLNormalization.this.m_expressionManager.getNNF(OWLNormalization.this.m_expressionManager.getSimplified(dr))) instanceof OWLDataIntersectionOf || dr instanceof OWLDataUnionOf) {
                OWLDatatype definition = OWLNormalization.this.getDefinitionFor(dr, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_dataRangeInclusions.add(Arrays.asList(OWLNormalization.this.negative((OWLDataRange)definition), dr));
                }
                dr = definition;
            }
            SWRLDataRangeAtom atom = OWLNormalization.this.m_factory.getSWRLDataRangeAtom(dr, argument);
            this.m_normalizedHeadAtoms.add((SWRLAtom)atom);
            this.m_headDataRangeVariables.add((SWRLVariable)argument);
        }

        public void visit(SWRLObjectPropertyAtom at) {
            SWRLVariable variable2;
            SWRLVariable variable1;
            OWLObjectPropertyExpression ope = at.getPredicate();
            OWLObjectProperty op = ope.getNamedProperty();
            if (ope.isAnonymous()) {
                variable1 = this.getVariableFor((SWRLIArgument)at.getSecondArgument());
                variable2 = this.getVariableFor((SWRLIArgument)at.getFirstArgument());
            } else {
                variable1 = this.getVariableFor((SWRLIArgument)at.getFirstArgument());
                variable2 = this.getVariableFor((SWRLIArgument)at.getSecondArgument());
            }
            SWRLObjectPropertyAtom newAtom = OWLNormalization.this.m_factory.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)op, (SWRLIArgument)variable1, (SWRLIArgument)variable2);
            if (this.m_isPositive) {
                this.m_normalizedHeadAtoms.add((SWRLAtom)newAtom);
            } else {
                this.m_normalizedBodyAtoms.add((SWRLAtom)newAtom);
            }
        }

        public void visit(SWRLDataPropertyAtom at) {
            OWLDataProperty dp = at.getPredicate().asOWLDataProperty();
            SWRLVariable variable1 = this.getVariableFor((SWRLIArgument)at.getFirstArgument());
            SWRLDArgument argument2 = (SWRLDArgument)at.getSecondArgument();
            if (argument2 instanceof SWRLVariable) {
                SWRLVariable variable2 = this.getVariableFor((SWRLIArgument)((SWRLVariable)argument2));
                if (this.m_isPositive) {
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)dp, (SWRLIArgument)variable1, (SWRLDArgument)variable2));
                    this.m_headDataRangeVariables.add(variable2);
                } else if (this.m_bodyDataRangeVariables.add(variable2)) {
                    this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)dp, (SWRLIArgument)variable1, (SWRLDArgument)variable2));
                } else {
                    SWRLVariable variable2Fresh = this.getFreshVariable();
                    this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)dp, (SWRLIArgument)variable1, (SWRLDArgument)variable2Fresh));
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDifferentIndividualsAtom((SWRLIArgument)variable2, (SWRLIArgument)variable2Fresh));
                }
            } else {
                OWLLiteral literal = ((SWRLLiteralArgument)argument2).getLiteral();
                SWRLClassAtom newAtom = OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)OWLNormalization.this.m_factory.getOWLDataHasValue((OWLDataPropertyExpression)dp, literal), (SWRLIArgument)variable1);
                if (this.m_isPositive) {
                    this.m_headAtoms.add((SWRLAtom)newAtom);
                } else {
                    this.m_bodyAtoms.add((SWRLAtom)newAtom);
                }
            }
        }

        public void visit(SWRLBuiltInAtom at) {
            throw new IllegalArgumentException("A SWRL rule uses a built-in atom, but built-in atoms are not supported yet.");
        }

        public void visit(SWRLSameIndividualAtom at) {
            if (!this.m_isPositive) {
                throw new IllegalStateException("Internal error: this SWRLSameIndividualAtom should have been processed earlier.");
            }
            this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLSameIndividualAtom((SWRLIArgument)this.getVariableFor((SWRLIArgument)at.getFirstArgument()), (SWRLIArgument)this.getVariableFor((SWRLIArgument)at.getSecondArgument())));
        }

        public void visit(SWRLDifferentIndividualsAtom at) {
            if (this.m_isPositive) {
                this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDifferentIndividualsAtom((SWRLIArgument)this.getVariableFor((SWRLIArgument)at.getFirstArgument()), (SWRLIArgument)this.getVariableFor((SWRLIArgument)at.getSecondArgument())));
            } else {
                this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLSameIndividualAtom((SWRLIArgument)this.getVariableFor((SWRLIArgument)at.getFirstArgument()), (SWRLIArgument)this.getVariableFor((SWRLIArgument)at.getSecondArgument())));
            }
        }

        public void visit(SWRLVariable variable) {
        }

        public void visit(SWRLIndividualArgument argument) {
        }

        public void visit(SWRLLiteralArgument argument) {
        }

        protected SWRLVariable getVariableFor(SWRLIArgument term) {
            SWRLVariable variable;
            if (term instanceof SWRLIndividualArgument) {
                OWLIndividual individual = ((SWRLIndividualArgument)term).getIndividual();
                if (individual.isAnonymous()) {
                    throw new IllegalArgumentException("Internal error: Rules with anonymous individuals are not supported. ");
                }
                variable = this.m_individualsToVariables.get(individual.asOWLNamedIndividual());
                if (variable == null) {
                    variable = this.getFreshVariable();
                    this.m_individualsToVariables.put(individual.asOWLNamedIndividual(), variable);
                    this.m_bodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)OWLNormalization.this.m_factory.getOWLObjectOneOf(new OWLIndividual[]{individual}), (SWRLIArgument)variable));
                }
            } else {
                variable = (SWRLVariable)term;
            }
            SWRLVariable representative = this.m_variableRepresentative.get(variable);
            if (representative == null) {
                return variable;
            }
            return representative;
        }

        protected SWRLVariable getFreshVariable() {
            SWRLVariable variable = OWLNormalization.this.m_factory.getSWRLVariable(IRI.create((String)"internal:swrl#", (String)("v" + this.m_newVariableIndex)));
            ++this.m_newVariableIndex;
            return variable;
        }
    }

    protected class Rule2FactConverter
    implements SWRLObjectVisitor {
        protected final boolean[] m_alreadyExists = new boolean[1];
        protected final Collection<List<OWLClassExpression>> m_newInclusions;
        protected int freshDataProperties = 0;
        protected int freshIndividuals = 0;

        public Rule2FactConverter(Collection<List<OWLClassExpression>> newInclusions) {
            this.m_newInclusions = newInclusions;
        }

        protected OWLNamedIndividual getFreshIndividual() {
            OWLNamedIndividual freshInd = OWLNormalization.this.m_factory.getOWLNamedIndividual(IRI.create((String)"internal:nom#", (String)("swrlfact" + this.freshIndividuals)));
            ++this.freshIndividuals;
            OWLNormalization.this.m_axioms.m_namedIndividuals.add(freshInd);
            return freshInd;
        }

        protected OWLDataProperty getFreshDataProperty() {
            ++this.freshDataProperties;
            return OWLNormalization.this.m_factory.getOWLDataProperty(IRI.create((String)"internal:freshDP#", (String)("p" + this.freshDataProperties)));
        }

        public void visit(SWRLClassAtom atom) {
            if (!(atom.getArgument() instanceof SWRLIndividualArgument)) {
                throw new IllegalArgumentException("A SWRL rule contains a head atom " + atom + " with a variable that does not occur in the body. ");
            }
            OWLIndividual ind = ((SWRLIndividualArgument)atom.getArgument()).getIndividual();
            if (ind.isAnonymous()) {
                this.throwAnonIndError((SWRLAtom)atom);
            }
            if (!OWLNormalization.isSimple(atom.getPredicate())) {
                OWLClassExpression definition = OWLNormalization.this.getDefinitionFor(atom.getPredicate(), this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), atom.getPredicate()));
                }
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(definition, (OWLIndividual)ind.asOWLNamedIndividual()));
            } else {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(atom.getPredicate(), (OWLIndividual)ind.asOWLNamedIndividual()));
            }
        }

        public void visit(SWRLDataRangeAtom atom) {
            if (atom.getArgument() instanceof SWRLVariable) {
                this.throwVarError((SWRLAtom)atom);
            }
            OWLLiteral lit = ((SWRLLiteralArgument)atom.getArgument()).getLiteral();
            OWLDataRange dr = atom.getPredicate();
            OWLNamedIndividual freshIndividual = this.getFreshIndividual();
            OWLDataProperty freshDP = this.getFreshDataProperty();
            OWLDataSomeValuesFrom some = OWLNormalization.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)freshDP, (OWLDataRange)OWLNormalization.this.m_factory.getOWLDataOneOf(new OWLLiteral[]{lit}));
            OWLClassExpression definition = OWLNormalization.this.getDefinitionFor((OWLClassExpression)some, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), some));
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(definition, (OWLIndividual)freshIndividual));
            this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)freshDP, dr)));
        }

        public void visit(SWRLObjectPropertyAtom atom) {
            if (!(atom.getFirstArgument() instanceof SWRLIndividualArgument) || !(atom.getSecondArgument() instanceof SWRLIndividualArgument)) {
                this.throwVarError((SWRLAtom)atom);
            }
            OWLObjectPropertyExpression ope = atom.getPredicate();
            OWLIndividual first = ((SWRLIndividualArgument)atom.getFirstArgument()).getIndividual();
            OWLIndividual second = ((SWRLIndividualArgument)atom.getSecondArgument()).getIndividual();
            if (first.isAnonymous() || second.isAnonymous()) {
                this.throwAnonIndError((SWRLAtom)atom);
            }
            if (ope.isAnonymous()) {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)ope.getNamedProperty(), (OWLIndividual)second.asOWLNamedIndividual(), (OWLIndividual)first.asOWLNamedIndividual()));
            } else {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)ope.asOWLObjectProperty(), (OWLIndividual)first.asOWLNamedIndividual(), (OWLIndividual)second.asOWLNamedIndividual()));
            }
        }

        public void visit(SWRLDataPropertyAtom atom) {
            OWLIndividual ind;
            if (!(atom.getSecondArgument() instanceof SWRLLiteralArgument)) {
                this.throwVarError((SWRLAtom)atom);
            }
            if (!(atom.getFirstArgument() instanceof SWRLIndividualArgument)) {
                this.throwVarError((SWRLAtom)atom);
            }
            if ((ind = ((SWRLIndividualArgument)atom.getFirstArgument()).getIndividual()).isAnonymous()) {
                this.throwAnonIndError((SWRLAtom)atom);
            }
            OWLLiteral lit = ((SWRLLiteralArgument)atom.getSecondArgument()).getLiteral();
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)atom.getPredicate().asOWLDataProperty(), (OWLIndividual)ind.asOWLNamedIndividual(), lit));
        }

        public void visit(SWRLBuiltInAtom atom) {
            throw new IllegalArgumentException("Error: A rule uses built-in atoms (" + atom + "), but built-in atoms are not supported yet. ");
        }

        public void visit(SWRLSameIndividualAtom atom) {
            HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
            for (SWRLArgument arg : OWLAPIStreamUtils.asList((Stream)atom.allArguments())) {
                OWLIndividual ind;
                if (!(arg instanceof SWRLIndividualArgument)) {
                    this.throwVarError((SWRLAtom)atom);
                }
                if ((ind = ((SWRLIndividualArgument)arg).getIndividual()).isAnonymous()) {
                    this.throwAnonIndError((SWRLAtom)atom);
                }
                inds.add(ind.asOWLNamedIndividual());
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLSameIndividualAxiom(inds));
        }

        public void visit(SWRLDifferentIndividualsAtom atom) {
            HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
            for (SWRLArgument arg : OWLAPIStreamUtils.asList((Stream)atom.allArguments())) {
                OWLIndividual ind;
                if (!(arg instanceof SWRLIndividualArgument)) {
                    this.throwVarError((SWRLAtom)atom);
                }
                if ((ind = ((SWRLIndividualArgument)arg).getIndividual()).isAnonymous()) {
                    this.throwAnonIndError((SWRLAtom)atom);
                }
                inds.add(ind.asOWLNamedIndividual());
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDifferentIndividualsAxiom(inds));
        }

        protected void throwAnonIndError(SWRLAtom atom) {
            throw new IllegalArgumentException("A SWRL rule contains a fact (" + atom + ") with an anonymous individual, which is not allowed. ");
        }

        protected void throwVarError(SWRLAtom atom) {
            throw new IllegalArgumentException("A SWRL rule contains a head atom (" + atom + ") with a variable that does not occur in the body. ");
        }
    }

    protected class DataRangeNormalizer
    implements OWLDataVisitorEx<OWLDataRange> {
        protected final Collection<List<OWLDataRange>> m_newDataRangeInclusions;
        protected final boolean[] m_alreadyExists;

        public DataRangeNormalizer(Collection<List<OWLDataRange>> newDataRangeInclusions) {
            this.m_newDataRangeInclusions = newDataRangeInclusions;
            this.m_alreadyExists = new boolean[1];
        }

        public OWLDataRange visit(OWLDatatype node) {
            return node;
        }

        public OWLDataRange visit(OWLDataComplementOf node) {
            return node;
        }

        public OWLDataRange visit(OWLDataOneOf node) {
            return node;
        }

        public OWLDataRange visit(OWLDataIntersectionOf object) {
            OWLDatatype definition = OWLNormalization.this.getDefinitionFor((OWLDataRange)object, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                object.operands().forEach(arg_0 -> this.lambda$visit$0((OWLDataRange)definition, arg_0));
            }
            return definition;
        }

        public OWLDataRange visit(OWLDataUnionOf node) {
            throw new IllegalStateException("OR should be broken down at the outermost level");
        }

        public OWLDataRange visit(OWLDatatypeRestriction node) {
            return node;
        }

        public OWLDataRange visit(OWLFacetRestriction node) {
            throw new IllegalStateException("Internal error: We shouldn't visit facet restrictions during normalization. ");
        }

        public OWLDataRange visit(OWLLiteral node) {
            throw new IllegalStateException("Internal error: We shouldn't visit typed literals during normalization. ");
        }

        private /* synthetic */ void lambda$visit$0(OWLDataRange definition, OWLDataRange d) {
            this.m_newDataRangeInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), d));
        }
    }

    protected class ClassExpressionNormalizer
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected final Collection<List<OWLClassExpression>> m_newInclusions;
        protected final Collection<List<OWLDataRange>> m_newDataRangeInclusions;
        protected final boolean[] m_alreadyExists;

        public ClassExpressionNormalizer(Collection<List<OWLClassExpression>> newInclusions, Collection<List<OWLDataRange>> newDataRangeInclusions) {
            this.m_newInclusions = newInclusions;
            this.m_newDataRangeInclusions = newDataRangeInclusions;
            this.m_alreadyExists = new boolean[1];
        }

        public OWLClassExpression visit(OWLClass object) {
            return object;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf object) {
            OWLClassExpression definition = OWLNormalization.this.getDefinitionFor((OWLClassExpression)object, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                object.operands().forEach(d -> this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), d)));
            }
            return definition;
        }

        public OWLClassExpression visit(OWLObjectUnionOf object) {
            throw new IllegalStateException("OR should be broken down at the outermost level");
        }

        public OWLClassExpression visit(OWLObjectComplementOf object) {
            if (OWLNormalization.isNominal(object.getOperand())) {
                OWLObjectOneOf objectOneOf = (OWLObjectOneOf)object.getOperand();
                OWLClass definition = OWLNormalization.this.getDefinitionForNegativeNominal(objectOneOf, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    objectOneOf.individuals().forEach(i -> OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom((OWLClassExpression)definition, i)));
                }
                return OWLNormalization.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)definition);
            }
            return object;
        }

        public OWLClassExpression visit(OWLObjectOneOf object) {
            if (object.individuals().anyMatch(IsAnonymous::isAnonymous)) {
                throw new IllegalArgumentException("Error: The class expression " + object + " contains anonymous individuals, which is not allowed in OWL 2 (erratum in first OWL 2 spec, to be fixed with next publication of minor corrections). ");
            }
            return object;
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom object) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(object.getProperty().getNamedProperty());
            OWLClassExpression filler = (OWLClassExpression)object.getFiller();
            if (OWLNormalization.isSimple(filler) || OWLNormalization.isNominal(filler)) {
                return object;
            }
            OWLClassExpression definition = OWLNormalization.this.getDefinitionFor(filler, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), filler));
            }
            return OWLNormalization.this.m_factory.getOWLObjectSomeValuesFrom(object.getProperty(), definition);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom object) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(object.getProperty().getNamedProperty());
            OWLClassExpression filler = (OWLClassExpression)object.getFiller();
            if (OWLNormalization.isSimple(filler) || OWLNormalization.isNominal(filler) || OWLNormalization.isNegatedOneNominal(filler)) {
                return object;
            }
            OWLClassExpression definition = OWLNormalization.this.getDefinitionFor(filler, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), filler));
            }
            return OWLNormalization.this.m_factory.getOWLObjectAllValuesFrom(object.getProperty(), definition);
        }

        public OWLClassExpression visit(OWLObjectHasValue object) {
            throw new IllegalStateException("Internal error: object value restrictions should have been simplified.");
        }

        public OWLClassExpression visit(OWLObjectHasSelf object) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(object.getProperty().getNamedProperty());
            return object;
        }

        public OWLClassExpression visit(OWLObjectMinCardinality object) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(object.getProperty().getNamedProperty());
            OWLClassExpression filler = (OWLClassExpression)object.getFiller();
            if (OWLNormalization.isSimple(filler)) {
                return object;
            }
            OWLClassExpression definition = OWLNormalization.this.getDefinitionFor(filler, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), filler));
            }
            return OWLNormalization.this.m_factory.getOWLObjectMinCardinality(object.getCardinality(), object.getProperty(), definition);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality object) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(object.getProperty().getNamedProperty());
            OWLClassExpression filler = (OWLClassExpression)object.getFiller();
            if (OWLNormalization.isSimple(filler)) {
                return object;
            }
            OWLClassExpression complementDescription = OWLNormalization.this.m_expressionManager.getComplementNNF(filler);
            OWLClassExpression definition = OWLNormalization.this.getDefinitionFor(complementDescription, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(Arrays.asList(OWLNormalization.this.negative(definition), complementDescription));
            }
            return OWLNormalization.this.m_factory.getOWLObjectMaxCardinality(object.getCardinality(), object.getProperty(), OWLNormalization.this.m_expressionManager.getComplementNNF(definition));
        }

        public OWLClassExpression visit(OWLObjectExactCardinality object) {
            throw new IllegalStateException("Internal error: exact object cardinality restrictions should have been simplified.");
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom object) {
            OWLDataRange filler = (OWLDataRange)object.getFiller();
            OWLDataPropertyExpression prop = object.getProperty();
            if (prop.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)object);
            }
            if (OWLNormalization.isLiteral(filler)) {
                return OWLNormalization.this.m_factory.getOWLDataSomeValuesFrom(object.getProperty(), filler);
            }
            OWLDatatype definition = OWLNormalization.this.getDefinitionFor(filler, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(Arrays.asList(OWLNormalization.this.negative((OWLDataRange)definition), filler));
            }
            return OWLNormalization.this.m_factory.getOWLDataSomeValuesFrom(object.getProperty(), (OWLDataRange)definition);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom object) {
            OWLDataRange filler = (OWLDataRange)object.getFiller();
            OWLDataPropertyExpression prop = object.getProperty();
            if (prop.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)object);
            }
            if (OWLNormalization.isLiteral(filler)) {
                return OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(prop, filler);
            }
            OWLDatatype definition = OWLNormalization.this.getDefinitionFor(filler, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(Arrays.asList(OWLNormalization.this.negative((OWLDataRange)definition), filler));
            }
            return OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(prop, (OWLDataRange)definition);
        }

        protected void throwInvalidTopDPUseError(OWLClassExpression ex) {
            throw new IllegalArgumentException("Error: In OWL 2 DL, owl:topDataProperty is only allowed to occur in the super property position of SubDataPropertyOf axioms, but the ontology contains an axiom with the class expression " + ex + " that violates this restriction.");
        }

        public OWLClassExpression visit(OWLDataHasValue object) {
            throw new IllegalStateException("Internal error: data value restrictions should have been simplified.");
        }

        public OWLClassExpression visit(OWLDataMinCardinality object) {
            OWLDataRange filler = (OWLDataRange)object.getFiller();
            OWLDataPropertyExpression prop = object.getProperty();
            if (prop.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)object);
            }
            if (OWLNormalization.isLiteral(filler)) {
                return OWLNormalization.this.m_factory.getOWLDataMinCardinality(object.getCardinality(), prop, filler);
            }
            OWLDatatype definition = OWLNormalization.this.getDefinitionFor(filler, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(Arrays.asList(OWLNormalization.this.negative((OWLDataRange)definition), filler));
            }
            return OWLNormalization.this.m_factory.getOWLDataMinCardinality(object.getCardinality(), prop, (OWLDataRange)definition);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality object) {
            OWLDataRange filler = (OWLDataRange)object.getFiller();
            OWLDataPropertyExpression prop = object.getProperty();
            if (prop.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)object);
            }
            if (OWLNormalization.isLiteral(filler)) {
                return OWLNormalization.this.m_factory.getOWLDataMaxCardinality(object.getCardinality(), prop, filler);
            }
            OWLDataRange complementDescription = OWLNormalization.this.m_expressionManager.getComplementNNF(filler);
            OWLDatatype definition = OWLNormalization.this.getDefinitionFor(complementDescription, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(Arrays.asList(OWLNormalization.this.negative((OWLDataRange)definition), filler));
            }
            return OWLNormalization.this.m_factory.getOWLDataMaxCardinality(object.getCardinality(), prop, OWLNormalization.this.m_expressionManager.getComplementNNF((OWLDataRange)definition));
        }

        public OWLClassExpression visit(OWLDataExactCardinality object) {
            throw new IllegalStateException("Internal error: exact data cardinality restrictions should have been simplified.");
        }
    }

    protected class AxiomVisitor
    implements OWLAxiomVisitor {
        protected final List<List<OWLClassExpression>> m_classExpressionInclusionsAsDisjunctions = new ArrayList<List<OWLClassExpression>>();
        protected final List<List<OWLDataRange>> m_dataRangeInclusionsAsDisjunctions = new ArrayList<List<OWLDataRange>>();
        protected final Collection<SWRLRule> m_rules = new HashSet<SWRLRule>();
        protected final boolean[] m_alreadyExists = new boolean[1];

        public void visit(OWLSubClassOfAxiom axiom) {
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative(axiom.getSubClass()), OWLNormalization.this.positive(axiom.getSuperClass())));
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            OWLClassExpression first;
            Iterator iterator = axiom.classExpressions().iterator();
            OWLClassExpression last = first = (OWLClassExpression)iterator.next();
            while (iterator.hasNext()) {
                OWLClassExpression next = (OWLClassExpression)iterator.next();
                this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative(last), OWLNormalization.this.positive(next)));
                last = next;
            }
            if (last != first) {
                this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative(last), OWLNormalization.this.positive(first)));
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            int i;
            if (axiom.classExpressions().count() <= 1L) {
                throw new IllegalArgumentException("Error: Parsed " + axiom.toString() + ". A DisjointClasses axiom in OWL 2 DL must have at least two classes as parameters. ");
            }
            List descriptions = OWLAPIStreamUtils.asList((Stream)axiom.classExpressions());
            for (i = 0; i < descriptions.size(); ++i) {
                descriptions.set(i, OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)descriptions.get(i)));
            }
            for (i = 0; i < descriptions.size() - 1; ++i) {
                for (int j = i + 1; j < descriptions.size(); ++j) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList((OWLClassExpression)descriptions.get(i), (OWLClassExpression)descriptions.get(j)));
                }
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            int i;
            OWLClassExpression complementNNF;
            List classExpressions = OWLAPIStreamUtils.asList((Stream)axiom.classExpressions());
            ArrayList<OWLClassExpression> inclusion = new ArrayList<OWLClassExpression>(classExpressions);
            if (!inclusion.contains(complementNNF = OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)axiom.getOWLClass()))) {
                inclusion.add(complementNNF);
            }
            this.m_classExpressionInclusionsAsDisjunctions.add(inclusion);
            for (OWLClassExpression description : classExpressions) {
                this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative(description), axiom.getOWLClass()));
            }
            for (i = 0; i < classExpressions.size(); ++i) {
                classExpressions.set(i, OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)classExpressions.get(i)));
            }
            for (i = 0; i < classExpressions.size(); ++i) {
                for (int j = i + 1; j < classExpressions.size(); ++j) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList((OWLClassExpression)classExpressions.get(i), (OWLClassExpression)classExpressions.get(j)));
                }
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isOWLBottomObjectProperty() && !((OWLObjectPropertyExpression)axiom.getSuperProperty()).isOWLTopObjectProperty()) {
                OWLNormalization.this.addInclusion((OWLObjectPropertyExpression)axiom.getSubProperty(), (OWLObjectPropertyExpression)axiom.getSuperProperty());
            }
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getSubProperty()).getNamedProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getSuperProperty()).getNamedProperty());
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            List subPropertyChain = axiom.getPropertyChain();
            if (!this.containsBottomObjectProperty(subPropertyChain) && !axiom.getSuperProperty().isOWLTopObjectProperty()) {
                OWLObjectPropertyExpression superObjectPropertyExpression = axiom.getSuperProperty();
                if (subPropertyChain.size() == 1) {
                    OWLNormalization.this.addInclusion((OWLObjectPropertyExpression)subPropertyChain.get(0), superObjectPropertyExpression);
                } else if (subPropertyChain.size() == 2 && ((OWLObjectPropertyExpression)subPropertyChain.get(0)).equals(superObjectPropertyExpression) && ((OWLObjectPropertyExpression)subPropertyChain.get(1)).equals(superObjectPropertyExpression)) {
                    OWLNormalization.this.makeTransitive(axiom.getSuperProperty());
                } else {
                    if (subPropertyChain.isEmpty()) {
                        throw new IllegalArgumentException("Error: In OWL 2 DL, an empty property chain in property chain axioms is not allowed, but the ontology contains an axiom that the empty chain is a subproperty of " + superObjectPropertyExpression + ".");
                    }
                    OWLObjectPropertyExpression[] subObjectProperties = new OWLObjectPropertyExpression[subPropertyChain.size()];
                    subPropertyChain.toArray(subObjectProperties);
                    OWLNormalization.this.addInclusion(subObjectProperties, superObjectPropertyExpression);
                }
            }
            for (OWLObjectPropertyExpression objectPropertyExpression : subPropertyChain) {
                OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(objectPropertyExpression.getNamedProperty());
            }
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(axiom.getSuperProperty().getNamedProperty());
        }

        protected boolean containsBottomObjectProperty(List<OWLObjectPropertyExpression> properties) {
            for (OWLObjectPropertyExpression property : properties) {
                if (!property.isOWLBottomObjectProperty()) continue;
                return true;
            }
            return false;
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            List objectPropertyExpressions = OWLAPIStreamUtils.asList((Stream)axiom.properties());
            if (objectPropertyExpressions.size() > 1) {
                OWLObjectPropertyExpression first;
                Iterator iterator = objectPropertyExpressions.iterator();
                OWLObjectPropertyExpression last = first = (OWLObjectPropertyExpression)iterator.next();
                while (iterator.hasNext()) {
                    OWLObjectPropertyExpression next = (OWLObjectPropertyExpression)iterator.next();
                    OWLNormalization.this.addInclusion(last, next);
                    last = next;
                }
                OWLNormalization.this.addInclusion(last, first);
            }
            for (OWLObjectPropertyExpression objectPropertyExpression : objectPropertyExpressions) {
                OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(objectPropertyExpression.getNamedProperty());
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            List list = OWLAPIStreamUtils.asList((Stream)axiom.properties());
            for (int i = 0; i < list.size(); ++i) {
                OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)list.get(i)).getNamedProperty());
            }
            OWLNormalization.this.m_axioms.m_disjointObjectProperties.add(list);
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            OWLObjectPropertyExpression first = axiom.getFirstProperty();
            OWLObjectPropertyExpression second = axiom.getSecondProperty();
            OWLNormalization.this.addInclusion(first, second.getInverseProperty());
            OWLNormalization.this.addInclusion(second, first.getInverseProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(first.getNamedProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(second.getNamedProperty());
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            OWLObjectAllValuesFrom allPropertyNohting = OWLNormalization.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)OWLNormalization.this.m_factory.getOWLNothing());
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.positive((OWLClassExpression)axiom.getDomain()), allPropertyNohting));
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            OWLObjectAllValuesFrom allPropertyRange = OWLNormalization.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), OWLNormalization.this.positive((OWLClassExpression)axiom.getRange()));
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(allPropertyRange));
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.m_factory.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)axiom.getProperty())));
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.m_factory.getOWLObjectMaxCardinality(1, ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty())));
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            OWLNormalization.this.makeReflexive((OWLObjectPropertyExpression)axiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            OWLNormalization.this.makeIrreflexive((OWLObjectPropertyExpression)axiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            OWLObjectPropertyExpression objectProperty = (OWLObjectPropertyExpression)axiom.getProperty();
            OWLNormalization.this.addInclusion(objectProperty, objectProperty.getInverseProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            OWLNormalization.this.makeAsymmetric((OWLObjectPropertyExpression)axiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            OWLNormalization.this.makeTransitive((OWLObjectPropertyExpression)axiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            OWLDataPropertyExpression subDataProperty = (OWLDataPropertyExpression)axiom.getSubProperty();
            this.checkTopDataPropertyUse(subDataProperty, (OWLAxiom)axiom);
            OWLDataPropertyExpression superDataProperty = (OWLDataPropertyExpression)axiom.getSuperProperty();
            if (!subDataProperty.isOWLBottomDataProperty() && !superDataProperty.isOWLTopDataProperty()) {
                OWLNormalization.this.addInclusion(subDataProperty, superDataProperty);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            OWLDataPropertyExpression first;
            axiom.properties().forEach(p -> this.checkTopDataPropertyUse((OWLDataPropertyExpression)p, (OWLAxiom)axiom));
            Iterator iterator = axiom.properties().iterator();
            OWLDataPropertyExpression last = first = (OWLDataPropertyExpression)iterator.next();
            while (iterator.hasNext()) {
                OWLDataPropertyExpression next = (OWLDataPropertyExpression)iterator.next();
                OWLNormalization.this.addInclusion(last, next);
                last = next;
            }
            if (first != last) {
                OWLNormalization.this.addInclusion(last, first);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            List dataProperties = OWLAPIStreamUtils.asList((Stream)axiom.properties());
            dataProperties.forEach(p -> this.checkTopDataPropertyUse((OWLDataPropertyExpression)p, (OWLAxiom)axiom));
            OWLNormalization.this.m_axioms.m_disjointDataProperties.add(dataProperties);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            OWLDataPropertyExpression dataProperty = (OWLDataPropertyExpression)axiom.getProperty();
            this.checkTopDataPropertyUse(dataProperty, (OWLAxiom)axiom);
            OWLDataComplementOf dataNothing = OWLNormalization.this.m_factory.getOWLDataComplementOf((OWLDataRange)OWLNormalization.this.m_factory.getTopDatatype());
            OWLDataAllValuesFrom allPropertyDataNothing = OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(dataProperty, (OWLDataRange)dataNothing);
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.positive((OWLClassExpression)axiom.getDomain()), allPropertyDataNothing));
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            OWLDataPropertyExpression dataProperty = (OWLDataPropertyExpression)axiom.getProperty();
            this.checkTopDataPropertyUse(dataProperty, (OWLAxiom)axiom);
            OWLDataAllValuesFrom allPropertyRange = OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(dataProperty, OWLNormalization.this.positive((OWLDataRange)axiom.getRange()));
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(allPropertyRange));
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            OWLDataPropertyExpression dataProperty = (OWLDataPropertyExpression)axiom.getProperty();
            this.checkTopDataPropertyUse(dataProperty, (OWLAxiom)axiom);
            this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.m_factory.getOWLDataMaxCardinality(1, dataProperty)));
        }

        protected void checkTopDataPropertyUse(OWLDataPropertyExpression dataPropertyExpression, OWLAxiom axiom) {
            if (dataPropertyExpression.isOWLTopDataProperty()) {
                throw new IllegalArgumentException("Error: In OWL 2 DL, owl:topDataProperty is only allowed to occur in the super property position of SubDataPropertyOf axioms, but the ontology contains an axiom " + axiom + " that violates this condition.");
            }
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            if (axiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException(this.noAnons((OWLAxiom)axiom));
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)axiom);
        }

        protected String noAnons(OWLAxiom axiom) {
            return "The axiom " + axiom + " contains anonymous individuals, which is not allowed in OWL 2. ";
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            if (axiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException(this.noAnons((OWLAxiom)axiom));
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)axiom);
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            OWLDataOneOf oneOf;
            OWLDataSomeValuesFrom someValuesFrom;
            OWLDataRange dataRange;
            OWLClassExpression classExpression = axiom.getClassExpression();
            if (classExpression instanceof OWLDataHasValue) {
                OWLDataHasValue hasValue = (OWLDataHasValue)classExpression;
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDataPropertyAssertionAxiom(hasValue.getProperty(), axiom.getIndividual(), (OWLLiteral)hasValue.getFiller()));
                return;
            }
            if (classExpression instanceof OWLDataSomeValuesFrom && (dataRange = (OWLDataRange)(someValuesFrom = (OWLDataSomeValuesFrom)classExpression).getFiller()) instanceof OWLDataOneOf && (oneOf = (OWLDataOneOf)dataRange).values().count() == 1L) {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDataPropertyAssertionAxiom(someValuesFrom.getProperty(), axiom.getIndividual(), (OWLLiteral)oneOf.values().iterator().next()));
                return;
            }
            if (!OWLNormalization.isSimple(classExpression = OWLNormalization.this.positive(classExpression))) {
                OWLClassExpression definition = OWLNormalization.this.getDefinitionFor(classExpression, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative(definition), classExpression));
                }
                classExpression = definition;
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(classExpression, axiom.getIndividual()));
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)axiom.getProperty(), axiom.getSubject(), (OWLIndividual)axiom.getObject()));
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            if (axiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException("The axiom " + axiom + " contains anonymous individuals, which is not allowed in OWL 2 DL. ");
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)axiom.getProperty(), axiom.getSubject(), (OWLIndividual)axiom.getObject()));
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.checkTopDataPropertyUse((OWLDataPropertyExpression)axiom.getProperty(), (OWLAxiom)axiom);
            OWLNormalization.this.addFact((OWLIndividualAxiom)axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.checkTopDataPropertyUse((OWLDataPropertyExpression)axiom.getProperty(), (OWLAxiom)axiom);
            if (axiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException("The axiom " + axiom + " contains anonymous individuals, which is not allowed in OWL 2 DL. ");
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)axiom);
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            OWLNormalization.this.m_axioms.m_definedDatatypesIRIs.add(axiom.getDatatype().getIRI().toString());
            this.m_dataRangeInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative((OWLDataRange)axiom.getDatatype()), OWLNormalization.this.positive(axiom.getDataRange())));
            this.m_dataRangeInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative(axiom.getDataRange()), OWLNormalization.this.positive((OWLDataRange)axiom.getDatatype())));
        }

        public void visit(OWLHasKeyAxiom axiom) {
            axiom.dataPropertyExpressions().forEach(d -> this.checkTopDataPropertyUse((OWLDataPropertyExpression)d, (OWLAxiom)axiom));
            OWLClassExpression description = OWLNormalization.this.positive(axiom.getClassExpression());
            if (!OWLNormalization.isSimple(description)) {
                OWLClassExpression definition = OWLNormalization.this.getDefinitionFor(description, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(Arrays.asList(OWLNormalization.this.negative(definition), description));
                }
                description = definition;
            }
            OWLNormalization.this.m_axioms.m_hasKeys.add(OWLNormalization.this.m_factory.getOWLHasKeyAxiom(description, (Collection)OWLAPIStreamUtils.asList((Stream)axiom.propertyExpressions())));
            axiom.objectPropertyExpressions().forEach(p -> OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(p.getNamedProperty()));
        }

        public void visit(SWRLRule rule) {
            rule.body().filter(atom -> atom instanceof SWRLDataPropertyAtom).forEach(atom -> this.checkTopDataPropertyUse(((SWRLDataPropertyAtom)atom).getPredicate(), (OWLAxiom)rule));
            rule.head().filter(atom -> atom instanceof SWRLDataPropertyAtom).forEach(atom -> this.checkTopDataPropertyUse(((SWRLDataPropertyAtom)atom).getPredicate(), (OWLAxiom)rule));
            if (rule.body().count() == 0L) {
                Rule2FactConverter r2fConverter = new Rule2FactConverter(this.m_classExpressionInclusionsAsDisjunctions);
                rule.head().forEach(at -> at.accept((SWRLObjectVisitor)r2fConverter));
            } else {
                this.m_rules.add(rule);
            }
        }
    }
}

