/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.graph.Graph;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import rationals.Automaton;
import rationals.State;
import rationals.Transition;

public class ObjectPropertyInclusionManager {
    private static final String COULD_NOT_CREATE_AUTOMATON = "Could not create automaton";
    protected final Map<OWLObjectPropertyExpression, Automaton> m_automataByProperty = new HashMap<OWLObjectPropertyExpression, Automaton>();

    public ObjectPropertyInclusionManager(OWLAxioms axioms) {
        this.createAutomata(this.m_automataByProperty, axioms.m_complexObjectPropertyExpressions, axioms.m_simpleObjectPropertyInclusions, axioms.m_complexObjectPropertyInclusions);
    }

    public int rewriteNegativeObjectPropertyAssertions(OWLDataFactory factory, OWLAxioms axioms, int _replacementIndex) {
        int replacementIndex = _replacementIndex;
        HashSet<OWLNegativeObjectPropertyAssertionAxiom> redundantFacts = new HashSet<OWLNegativeObjectPropertyAssertionAxiom>();
        HashSet<OWLClassAssertionAxiom> additionalFacts = new HashSet<OWLClassAssertionAxiom>();
        for (OWLIndividualAxiom axiom : axioms.m_facts) {
            OWLNegativeObjectPropertyAssertionAxiom negAssertion;
            OWLObjectPropertyExpression prop;
            if (!(axiom instanceof OWLNegativeObjectPropertyAssertionAxiom) || !axioms.m_complexObjectPropertyExpressions.contains(prop = (OWLObjectPropertyExpression)(negAssertion = (OWLNegativeObjectPropertyAssertionAxiom)axiom).getProperty())) continue;
            OWLIndividual individual = (OWLIndividual)negAssertion.getObject();
            IRI iri = individual.asOWLNamedIndividual().getIRI();
            OWLClass individualConcept = factory.getOWLClass(IRI.create((String)("internal:nom#" + iri.getNamespace()), (String)iri.getFragment()));
            OWLObjectComplementOf notIndividualConcept = factory.getOWLObjectComplementOf((OWLClassExpression)individualConcept);
            OWLObjectAllValuesFrom allNotIndividualConcept = factory.getOWLObjectAllValuesFrom(prop, (OWLClassExpression)notIndividualConcept);
            OWLClass definition = factory.getOWLClass(IRI.create((String)"internal:def#", (String)("a" + replacementIndex++)));
            axioms.m_conceptInclusions.add(Arrays.asList(factory.getOWLObjectComplementOf((OWLClassExpression)definition), allNotIndividualConcept));
            additionalFacts.add(factory.getOWLClassAssertionAxiom((OWLClassExpression)definition, negAssertion.getSubject()));
            additionalFacts.add(factory.getOWLClassAssertionAxiom((OWLClassExpression)individualConcept, individual));
            redundantFacts.add(negAssertion);
        }
        axioms.m_facts.addAll(additionalFacts);
        axioms.m_facts.removeAll(redundantFacts);
        return replacementIndex;
    }

    /*
     * WARNING - void declaration
     */
    public void rewriteAxioms(OWLDataFactory dataFactory, OWLAxioms axioms, int _firstReplacementIndex) {
        int firstReplacementIndex = _firstReplacementIndex;
        for (OWLObjectPropertyExpression objectPropertyExpression : axioms.m_asymmetricObjectProperties) {
            if (!axioms.m_complexObjectPropertyExpressions.contains(objectPropertyExpression)) continue;
            throw new IllegalArgumentException("Non-simple property '" + objectPropertyExpression + "' or its inverse appears in asymmetric object property axiom.");
        }
        for (OWLObjectPropertyExpression objectPropertyExpression : axioms.m_irreflexiveObjectProperties) {
            if (!axioms.m_complexObjectPropertyExpressions.contains(objectPropertyExpression)) continue;
            throw new IllegalArgumentException("Non-simple property '" + objectPropertyExpression + "' or its inverse appears in irreflexive object property axiom.");
        }
        axioms.m_disjointObjectProperties.forEach(c -> c.forEach(p -> {
            if (axioms.m_complexObjectPropertyExpressions.contains(p)) {
                throw new IllegalArgumentException("Non-simple property '" + p + "' or its inverse appears in disjoint properties axiom.");
            }
        }));
        HashMap<OWLObjectAllValuesFrom, void> replacedDescriptions = new HashMap<OWLObjectAllValuesFrom, void>();
        for (List<OWLClassExpression> list : axioms.m_conceptInclusions) {
            for (int index = 0; index < list.size(); ++index) {
                void var12_17;
                Object objectProperty;
                OWLObjectAllValuesFrom objectAll;
                OWLObjectHasSelf objectSelfRestriction;
                OWLClassExpression classExpression = list.get(index);
                if (classExpression instanceof OWLObjectCardinalityRestriction) {
                    OWLObjectCardinalityRestriction objectCardinalityRestriction = (OWLObjectCardinalityRestriction)classExpression;
                    OWLObjectPropertyExpression objectPropertyExpression = objectCardinalityRestriction.getProperty();
                    if (axioms.m_complexObjectPropertyExpressions.contains(objectPropertyExpression)) {
                        throw new IllegalArgumentException("Non-simple property '" + objectPropertyExpression + "' or its inverse appears in the cardinality restriction '" + objectCardinalityRestriction + "'.");
                    }
                } else if (classExpression instanceof OWLObjectHasSelf && axioms.m_complexObjectPropertyExpressions.contains((objectSelfRestriction = (OWLObjectHasSelf)classExpression).getProperty())) {
                    throw new IllegalArgumentException("Non-simple property '" + objectSelfRestriction.getProperty() + "' or its inverse appears in the Self restriction '" + objectSelfRestriction + "'.");
                }
                if (!(classExpression instanceof OWLObjectAllValuesFrom) || ((OWLClassExpression)(objectAll = (OWLObjectAllValuesFrom)classExpression).getFiller()).equals(dataFactory.getOWLThing()) || !this.m_automataByProperty.containsKey(objectProperty = objectAll.getProperty())) continue;
                OWLClassExpression oWLClassExpression = (OWLClassExpression)replacedDescriptions.get(objectAll);
                if (oWLClassExpression == null) {
                    void var12_21;
                    OWLClass oWLClass = dataFactory.getOWLClass(IRI.create((String)"internal:all#", (String)("a" + firstReplacementIndex++)));
                    if (objectAll.getFiller() instanceof OWLObjectComplementOf || ((OWLClassExpression)objectAll.getFiller()).equals(dataFactory.getOWLNothing())) {
                        OWLClassExpression oWLClassExpression2 = oWLClass.getComplementNNF();
                    }
                    replacedDescriptions.put(objectAll, var12_21);
                }
                list.set(index, (OWLClassExpression)var12_17);
            }
        }
        for (Map.Entry entry : replacedDescriptions.entrySet()) {
            Automaton automaton = this.m_automataByProperty.get(((OWLObjectAllValuesFrom)entry.getKey()).getProperty());
            boolean isOfNegativePolarity = entry.getValue() instanceof OWLObjectComplementOf;
            HashMap statesToConcepts = new HashMap();
            for (Object e : automaton.states()) {
                State state = (State)e;
                if (state.isInitial()) {
                    statesToConcepts.put(state, entry.getValue());
                    continue;
                }
                OWLClass stateConcept = dataFactory.getOWLClass(IRI.create((String)"internal:all#", (String)("a" + firstReplacementIndex++)));
                if (isOfNegativePolarity) {
                    stateConcept = stateConcept.getComplementNNF();
                }
                statesToConcepts.put(state, stateConcept);
            }
            for (Object e : automaton.delta()) {
                Transition transition = (Transition)e;
                OWLClassExpression fromStateConcept = ((OWLClassExpression)statesToConcepts.get(transition.start())).getComplementNNF();
                OWLClassExpression toStateConcept = (OWLClassExpression)statesToConcepts.get(transition.end());
                if (transition.label() == null) {
                    axioms.m_conceptInclusions.add(Arrays.asList(fromStateConcept, toStateConcept));
                    continue;
                }
                OWLObjectAllValuesFrom consequentAll = dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)transition.label(), toStateConcept);
                axioms.m_conceptInclusions.add(Arrays.asList(fromStateConcept, consequentAll));
            }
            OWLClassExpression filler = (OWLClassExpression)((OWLObjectAllValuesFrom)entry.getKey()).getFiller();
            for (State finalStateObject : automaton.terminals()) {
                OWLClassExpression finalStateConceptComplement = ((OWLClassExpression)statesToConcepts.get(finalStateObject)).getComplementNNF();
                if (filler.isOWLNothing()) {
                    axioms.m_conceptInclusions.add(Arrays.asList(finalStateConceptComplement));
                    continue;
                }
                axioms.m_conceptInclusions.add(Arrays.asList(finalStateConceptComplement, filler));
            }
        }
    }

    protected void createAutomata(Map<OWLObjectPropertyExpression, Automaton> automataByProperty, Set<OWLObjectPropertyExpression> complexObjectPropertyExpressions, Collection<List<OWLObjectPropertyExpression>> simpleObjectPropertyInclusions, Collection<OWLAxioms.ComplexObjectPropertyInclusion> complexObjectPropertyInclusions) {
        Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> equivalentPropertiesMap = this.findEquivalentProperties(simpleObjectPropertyInclusions);
        Set<OWLObjectPropertyExpression> symmetricObjectProperties = ObjectPropertyInclusionManager.findSymmetricProperties(simpleObjectPropertyInclusions);
        Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> inversePropertiesMap = this.buildInversePropertiesMap(simpleObjectPropertyInclusions);
        Graph<OWLObjectPropertyExpression> propertyDependencyGraph = this.buildPropertyOrdering(simpleObjectPropertyInclusions, complexObjectPropertyInclusions, equivalentPropertiesMap);
        this.checkForRegularity(propertyDependencyGraph, equivalentPropertiesMap);
        Object complexPropertiesDependencyGraph = propertyDependencyGraph.clone();
        HashSet<OWLObjectPropertyExpression> transitiveProperties = new HashSet<OWLObjectPropertyExpression>();
        Map<OWLObjectPropertyExpression, Automaton> individualAutomata = this.buildIndividualAutomata((Graph<OWLObjectPropertyExpression>)complexPropertiesDependencyGraph, complexObjectPropertyInclusions, equivalentPropertiesMap, transitiveProperties);
        Set<OWLObjectPropertyExpression> simpleProperties = this.findSimpleProperties((Graph<OWLObjectPropertyExpression>)complexPropertiesDependencyGraph, individualAutomata);
        propertyDependencyGraph.removeElements(simpleProperties);
        ((Graph)complexPropertiesDependencyGraph).removeElements(simpleProperties);
        complexObjectPropertyExpressions.addAll(((Graph)complexPropertiesDependencyGraph).getElements());
        for (List<OWLObjectPropertyExpression> inclusion : simpleObjectPropertyInclusions) {
            if (!complexObjectPropertyExpressions.contains(inclusion.get(0)) || !individualAutomata.containsKey(inclusion.get(1))) continue;
            Automaton auto = individualAutomata.get(inclusion.get(1));
            Transition transition = new Transition(auto.initials().iterator().next(), inclusion.get(0), auto.terminals().iterator().next());
            auto.addTransition(transition, "Could not create automaton for property at the bottom of hierarchy (simple property).");
        }
        HashSet<OWLObjectPropertyExpression> inverseOfComplexProperties = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression complexProp : complexObjectPropertyExpressions) {
            inverseOfComplexProperties.add(complexProp.getInverseProperty());
        }
        complexObjectPropertyExpressions.addAll(inverseOfComplexProperties);
        this.connectAllAutomata(automataByProperty, propertyDependencyGraph, inversePropertiesMap, individualAutomata, symmetricObjectProperties, transitiveProperties);
        HashMap<OWLObjectPropertyExpression, Automaton> individualAutomataForEquivRoles = new HashMap<OWLObjectPropertyExpression, Automaton>();
        for (OWLObjectPropertyExpression propExprWithAutomaton : automataByProperty.keySet()) {
            if (equivalentPropertiesMap.get(propExprWithAutomaton) == null) continue;
            Automaton autoOfPropExpr = automataByProperty.get(propExprWithAutomaton);
            for (OWLObjectPropertyExpression equivProp : equivalentPropertiesMap.get(propExprWithAutomaton)) {
                OWLObjectPropertyExpression inverseEquivProp;
                if (!equivProp.equals(propExprWithAutomaton) && !automataByProperty.containsKey(equivProp)) {
                    Automaton automatonOfEquivalent = (Automaton)autoOfPropExpr.clone();
                    individualAutomataForEquivRoles.put(equivProp, automatonOfEquivalent);
                    simpleProperties.remove(equivProp);
                    complexObjectPropertyExpressions.add(equivProp);
                }
                if ((inverseEquivProp = equivProp.getInverseProperty()).equals(propExprWithAutomaton) || automataByProperty.containsKey(inverseEquivProp)) continue;
                Automaton automatonOfEquivalent = (Automaton)autoOfPropExpr.clone();
                individualAutomataForEquivRoles.put(inverseEquivProp, this.getMirroredCopy(automatonOfEquivalent));
                simpleProperties.remove(inverseEquivProp);
                complexObjectPropertyExpressions.add(inverseEquivProp);
            }
        }
        automataByProperty.putAll(individualAutomataForEquivRoles);
    }

    private static Set<OWLObjectPropertyExpression> findSymmetricProperties(Collection<List<OWLObjectPropertyExpression>> simpleObjectPropertyInclusions) {
        HashSet<OWLObjectPropertyExpression> symmetricProperties = new HashSet<OWLObjectPropertyExpression>();
        for (List<OWLObjectPropertyExpression> inclusion : simpleObjectPropertyInclusions) {
            if (!inclusion.get(1).getInverseProperty().equals(inclusion.get(0)) && !inclusion.get(1).equals(inclusion.get(0).getInverseProperty())) continue;
            symmetricProperties.add(inclusion.get(0));
            symmetricProperties.add(inclusion.get(0).getInverseProperty());
        }
        return symmetricProperties;
    }

    protected Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> buildInversePropertiesMap(Collection<List<OWLObjectPropertyExpression>> simpleObjectPropertyInclusions) {
        HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> inversePropertiesMap = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        for (List<OWLObjectPropertyExpression> inclusion : simpleObjectPropertyInclusions) {
            Set<OWLObjectPropertyExpression> inverseProperties;
            if (inclusion.get(1) instanceof OWLObjectInverseOf) {
                inverseProperties = (HashSet<OWLObjectPropertyExpression>)inversePropertiesMap.get(inclusion.get(0));
                if (inverseProperties == null) {
                    inverseProperties = new HashSet<OWLObjectPropertyExpression>();
                }
                inverseProperties.add(inclusion.get(1).getInverseProperty());
                inversePropertiesMap.put(inclusion.get(0), inverseProperties);
                inverseProperties = (Set)inversePropertiesMap.get(inclusion.get(1).getInverseProperty());
                if (inverseProperties == null) {
                    inverseProperties = new HashSet();
                }
                inverseProperties.add(inclusion.get(0));
                inversePropertiesMap.put(inclusion.get(1).getInverseProperty(), inverseProperties);
                continue;
            }
            if (!(inclusion.get(0) instanceof OWLObjectInverseOf)) continue;
            inverseProperties = (Set)inversePropertiesMap.get(inclusion.get(1));
            if (inverseProperties == null) {
                inverseProperties = new HashSet();
            }
            inverseProperties.add(inclusion.get(0).getInverseProperty());
            inversePropertiesMap.put(inclusion.get(1), inverseProperties);
            inverseProperties = (Set)inversePropertiesMap.get(inclusion.get(0).getInverseProperty());
            if (inverseProperties == null) {
                inverseProperties = new HashSet();
            }
            inverseProperties.add(inclusion.get(1));
            inversePropertiesMap.put(inclusion.get(0).getInverseProperty(), inverseProperties);
        }
        return inversePropertiesMap;
    }

    protected Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> findEquivalentProperties(Collection<List<OWLObjectPropertyExpression>> simpleObjectPropertyInclusions) {
        Graph<OWLObjectPropertyExpression> propertyDependencyGraph = new Graph<OWLObjectPropertyExpression>();
        HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> equivalentObjectPropertiesMapping = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        for (List<OWLObjectPropertyExpression> inclusion : simpleObjectPropertyInclusions) {
            if (inclusion.get(0).equals(inclusion.get(1)) || inclusion.get(0).equals(inclusion.get(1).getInverseProperty())) continue;
            propertyDependencyGraph.addEdge(inclusion.get(0), inclusion.get(1));
        }
        propertyDependencyGraph.transitivelyClose();
        for (OWLObjectPropertyExpression objExpr : propertyDependencyGraph.getElements()) {
            if (!propertyDependencyGraph.getSuccessors(objExpr).contains(objExpr) && !propertyDependencyGraph.getSuccessors(objExpr).contains(objExpr.getInverseProperty())) continue;
            HashSet<OWLObjectPropertyExpression> equivPropertiesSet = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectPropertyExpression succ : propertyDependencyGraph.getSuccessors(objExpr)) {
                if (succ.equals(objExpr) || !propertyDependencyGraph.getSuccessors(succ).contains(objExpr) && !propertyDependencyGraph.getSuccessors(succ).contains(objExpr.getInverseProperty())) continue;
                equivPropertiesSet.add(succ);
            }
            equivalentObjectPropertiesMapping.put(objExpr, equivPropertiesSet);
        }
        return equivalentObjectPropertiesMapping;
    }

    protected Set<OWLObjectPropertyExpression> findSimpleProperties(Graph<OWLObjectPropertyExpression> complexPropertiesDependencyGraph, Map<OWLObjectPropertyExpression, Automaton> individualAutomata) {
        HashSet<OWLObjectPropertyExpression> simpleProperties = new HashSet<OWLObjectPropertyExpression>();
        Object complexPropertiesDependencyGraphWithInverses = complexPropertiesDependencyGraph.clone();
        for (OWLObjectPropertyExpression complexProperty1 : complexPropertiesDependencyGraph.getElements()) {
            for (OWLObjectPropertyExpression complexProperty2 : complexPropertiesDependencyGraph.getSuccessors(complexProperty1)) {
                ((Graph)complexPropertiesDependencyGraphWithInverses).addEdge(complexProperty1.getInverseProperty(), complexProperty2.getInverseProperty());
            }
        }
        Graph<OWLObjectPropertyExpression> invertedGraph = ((Graph)complexPropertiesDependencyGraphWithInverses).getInverse();
        invertedGraph.transitivelyClose();
        for (OWLObjectPropertyExpression properties : invertedGraph.getElements()) {
            boolean hasComplexSubproperty = false;
            for (OWLObjectPropertyExpression subDependingProperties : invertedGraph.getSuccessors(properties)) {
                if (!individualAutomata.containsKey(subDependingProperties) && !individualAutomata.containsKey(subDependingProperties.getInverseProperty())) continue;
                hasComplexSubproperty = true;
                break;
            }
            if (hasComplexSubproperty || individualAutomata.containsKey(properties) || individualAutomata.containsKey(properties.getInverseProperty())) continue;
            simpleProperties.add(properties);
        }
        return simpleProperties;
    }

    protected void connectAllAutomata(Map<OWLObjectPropertyExpression, Automaton> completeAutomata, Graph<OWLObjectPropertyExpression> propertyDependencyGraph, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> inversePropertiesMap, Map<OWLObjectPropertyExpression, Automaton> individualAutomata, Set<OWLObjectPropertyExpression> symmetricObjectProperties, Set<OWLObjectPropertyExpression> transitiveProperties) {
        Object transClosedGraph = propertyDependencyGraph.clone();
        ((Graph)transClosedGraph).transitivelyClose();
        HashSet<Object> propertiesToStartRecursion = new HashSet<Object>();
        for (Object owlProp : ((Graph)transClosedGraph).getElements()) {
            if (!((Graph)transClosedGraph).getSuccessors(owlProp).isEmpty()) continue;
            propertiesToStartRecursion.add(owlProp);
        }
        Graph<OWLObjectPropertyExpression> inversePropertyDependencyGraph = propertyDependencyGraph.getInverse();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : propertiesToStartRecursion) {
            this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression, inversePropertiesMap, individualAutomata, completeAutomata, inversePropertyDependencyGraph, symmetricObjectProperties, transitiveProperties);
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : individualAutomata.keySet()) {
            if (completeAutomata.containsKey(oWLObjectPropertyExpression)) continue;
            Automaton propertyAutomaton = individualAutomata.get(oWLObjectPropertyExpression);
            if (completeAutomata.containsKey(oWLObjectPropertyExpression.getInverseProperty()) && inversePropertyDependencyGraph.getElements().contains(oWLObjectPropertyExpression.getInverseProperty()) || individualAutomata.containsKey(oWLObjectPropertyExpression.getInverseProperty())) {
                Automaton inversePropertyAutomaton = completeAutomata.get(oWLObjectPropertyExpression.getInverseProperty());
                if (inversePropertyAutomaton == null) {
                    inversePropertyAutomaton = individualAutomata.get(oWLObjectPropertyExpression.getInverseProperty());
                }
                this.increaseAutomatonWithInversePropertyAutomaton(propertyAutomaton, inversePropertyAutomaton);
            }
            completeAutomata.put(oWLObjectPropertyExpression, propertyAutomaton);
        }
        HashMap<OWLObjectPropertyExpression, Automaton> extraCompleteAutomataForInverseProperties = new HashMap<OWLObjectPropertyExpression, Automaton>();
        for (OWLObjectPropertyExpression property : completeAutomata.keySet()) {
            if (completeAutomata.containsKey(property.getInverseProperty())) continue;
            extraCompleteAutomataForInverseProperties.put(property.getInverseProperty(), this.getMirroredCopy(completeAutomata.get(property)));
        }
        completeAutomata.putAll(extraCompleteAutomataForInverseProperties);
        extraCompleteAutomataForInverseProperties.clear();
        for (OWLObjectPropertyExpression property : completeAutomata.keySet()) {
            if (!completeAutomata.containsKey(property) || completeAutomata.containsKey(property.getInverseProperty())) continue;
            extraCompleteAutomataForInverseProperties.put(property.getInverseProperty(), this.getMirroredCopy(completeAutomata.get(property)));
        }
        completeAutomata.putAll(extraCompleteAutomataForInverseProperties);
        extraCompleteAutomataForInverseProperties.clear();
        for (OWLObjectPropertyExpression propExprWithAutomaton : completeAutomata.keySet()) {
            if (inversePropertiesMap.get(propExprWithAutomaton) == null) continue;
            Automaton autoOfPropExpr = completeAutomata.get(propExprWithAutomaton);
            for (OWLObjectPropertyExpression inverseProp : inversePropertiesMap.get(propExprWithAutomaton)) {
                Automaton automatonOfInverse = completeAutomata.get(inverseProp);
                if (automatonOfInverse != null) {
                    this.increaseAutomatonWithInversePropertyAutomaton(autoOfPropExpr, automatonOfInverse);
                    extraCompleteAutomataForInverseProperties.put(propExprWithAutomaton, autoOfPropExpr);
                    continue;
                }
                automatonOfInverse = this.getMirroredCopy(autoOfPropExpr);
                extraCompleteAutomataForInverseProperties.put(inverseProp, automatonOfInverse);
            }
        }
        completeAutomata.putAll(extraCompleteAutomataForInverseProperties);
    }

    protected void increaseAutomatonWithInversePropertyAutomaton(Automaton propertyAutomaton, Automaton inversePropertyAutomaton) {
        State initialState = propertyAutomaton.initials().iterator().next();
        State finalState = propertyAutomaton.terminals().iterator().next();
        Transition transition = propertyAutomaton.deltaFrom(initialState, finalState).iterator().next();
        this.automataConnector(propertyAutomaton, this.getMirroredCopy(inversePropertyAutomaton), transition);
    }

    protected Automaton buildCompleteAutomataForProperties(OWLObjectPropertyExpression propertyToBuildAutomatonFor, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> inversePropertiesMap, Map<OWLObjectPropertyExpression, Automaton> individualAutomata, Map<OWLObjectPropertyExpression, Automaton> completeAutomata, Graph<OWLObjectPropertyExpression> inversedPropertyDependencyGraph, Set<OWLObjectPropertyExpression> symmetricObjectProperties, Set<OWLObjectPropertyExpression> transitiveProperties) {
        if (completeAutomata.containsKey(propertyToBuildAutomatonFor)) {
            return completeAutomata.get(propertyToBuildAutomatonFor);
        }
        if (completeAutomata.containsKey(propertyToBuildAutomatonFor.getInverseProperty()) && !individualAutomata.containsKey(propertyToBuildAutomatonFor)) {
            Automaton mirroredCopy = this.getMirroredCopy(completeAutomata.get(propertyToBuildAutomatonFor.getInverseProperty()));
            completeAutomata.put(propertyToBuildAutomatonFor, mirroredCopy);
            return mirroredCopy;
        }
        if (inversedPropertyDependencyGraph.getSuccessors(propertyToBuildAutomatonFor).isEmpty() && inversedPropertyDependencyGraph.getSuccessors(propertyToBuildAutomatonFor.getInverseProperty()).isEmpty()) {
            Automaton automatonForLeafProperty = individualAutomata.get(propertyToBuildAutomatonFor);
            if (automatonForLeafProperty == null) {
                Set<OWLObjectPropertyExpression> inverses = inversePropertiesMap.get(propertyToBuildAutomatonFor);
                boolean noInversePropertyWithAutomaton = true;
                if (inverses != null) {
                    for (OWLObjectPropertyExpression inverse : inverses) {
                        if (!individualAutomata.containsKey(inverse) || inverse.equals(propertyToBuildAutomatonFor)) continue;
                        automatonForLeafProperty = this.getMirroredCopy(this.buildCompleteAutomataForProperties(inverse, inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties));
                        automatonForLeafProperty = this.minimizeAndNormalizeAutomaton(automatonForLeafProperty);
                        completeAutomata.put(propertyToBuildAutomatonFor, automatonForLeafProperty);
                        noInversePropertyWithAutomaton = false;
                        break;
                    }
                } else if (individualAutomata.containsKey(propertyToBuildAutomatonFor.getInverseProperty())) {
                    automatonForLeafProperty = this.getMirroredCopy(this.buildCompleteAutomataForProperties(propertyToBuildAutomatonFor.getInverseProperty(), inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties));
                    if (!completeAutomata.containsKey(propertyToBuildAutomatonFor)) {
                        automatonForLeafProperty = this.minimizeAndNormalizeAutomaton(automatonForLeafProperty);
                        completeAutomata.put(propertyToBuildAutomatonFor, automatonForLeafProperty);
                    } else {
                        automatonForLeafProperty = completeAutomata.get(propertyToBuildAutomatonFor);
                    }
                    noInversePropertyWithAutomaton = false;
                }
                if (noInversePropertyWithAutomaton) {
                    automatonForLeafProperty = new Automaton();
                    State initial = automatonForLeafProperty.addState(true, false);
                    State accepting = automatonForLeafProperty.addState(false, true);
                    Transition transition = new Transition(initial, propertyToBuildAutomatonFor, accepting);
                    automatonForLeafProperty.addTransition(transition, "Could not create automaton for property at the bottom of hierarchy (simple property).");
                    this.finalizeConstruction(completeAutomata, propertyToBuildAutomatonFor, automatonForLeafProperty, symmetricObjectProperties, transitiveProperties);
                }
            } else if (propertyToBuildAutomatonFor.getInverseProperty().isAnonymous() && individualAutomata.containsKey(propertyToBuildAutomatonFor.getInverseProperty())) {
                Automaton inversePropertyAutomaton = this.buildCompleteAutomataForProperties(propertyToBuildAutomatonFor.getInverseProperty(), inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties);
                this.increaseAutomatonWithInversePropertyAutomaton(automatonForLeafProperty, this.getMirroredCopy(inversePropertyAutomaton));
                if (!completeAutomata.containsKey(propertyToBuildAutomatonFor)) {
                    this.finalizeConstruction(completeAutomata, propertyToBuildAutomatonFor, automatonForLeafProperty, symmetricObjectProperties, transitiveProperties);
                } else {
                    automatonForLeafProperty = completeAutomata.get(propertyToBuildAutomatonFor);
                }
            } else {
                this.increaseWithDefinedInverseIfNecessary(propertyToBuildAutomatonFor, automatonForLeafProperty, inversePropertiesMap, individualAutomata);
                this.finalizeConstruction(completeAutomata, propertyToBuildAutomatonFor, automatonForLeafProperty, symmetricObjectProperties, transitiveProperties);
            }
            return automatonForLeafProperty;
        }
        Automaton biggerPropertyAutomaton = individualAutomata.get(propertyToBuildAutomatonFor);
        if (biggerPropertyAutomaton == null) {
            biggerPropertyAutomaton = new Automaton();
            State initialState = biggerPropertyAutomaton.addState(true, false);
            State finalState = biggerPropertyAutomaton.addState(false, true);
            Transition transition = new Transition(initialState, propertyToBuildAutomatonFor, finalState);
            biggerPropertyAutomaton.addTransition(transition, COULD_NOT_CREATE_AUTOMATON);
            for (OWLObjectPropertyExpression smallerProperty : inversedPropertyDependencyGraph.getSuccessors(propertyToBuildAutomatonFor)) {
                Automaton smallerPropertyAutomaton = this.buildCompleteAutomataForProperties(smallerProperty, inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties);
                this.automataConnector(biggerPropertyAutomaton, smallerPropertyAutomaton, transition);
                Transition t = new Transition(initialState, smallerProperty, finalState);
                biggerPropertyAutomaton.addTransition(t, COULD_NOT_CREATE_AUTOMATON);
            }
            if (propertyToBuildAutomatonFor.getInverseProperty().isAnonymous() && individualAutomata.containsKey(propertyToBuildAutomatonFor.getInverseProperty())) {
                Automaton inversePropertyAutomaton = this.buildCompleteAutomataForProperties(propertyToBuildAutomatonFor.getInverseProperty(), inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties);
                this.increaseAutomatonWithInversePropertyAutomaton(biggerPropertyAutomaton, this.getMirroredCopy(inversePropertyAutomaton));
                if (!completeAutomata.containsKey(propertyToBuildAutomatonFor)) {
                    this.finalizeConstruction(completeAutomata, propertyToBuildAutomatonFor, biggerPropertyAutomaton, symmetricObjectProperties, transitiveProperties);
                } else {
                    biggerPropertyAutomaton = completeAutomata.get(propertyToBuildAutomatonFor);
                }
            } else {
                this.increaseWithDefinedInverseIfNecessary(propertyToBuildAutomatonFor, biggerPropertyAutomaton, inversePropertiesMap, individualAutomata);
                if (!completeAutomata.containsKey(propertyToBuildAutomatonFor)) {
                    this.finalizeConstruction(completeAutomata, propertyToBuildAutomatonFor, biggerPropertyAutomaton, symmetricObjectProperties, transitiveProperties);
                } else {
                    biggerPropertyAutomaton = completeAutomata.get(propertyToBuildAutomatonFor);
                }
            }
        } else {
            for (OWLObjectPropertyExpression smallerProperty : inversedPropertyDependencyGraph.getSuccessors(propertyToBuildAutomatonFor)) {
                boolean someInternalTransitionMatched = false;
                for (Transition transitionObject : biggerPropertyAutomaton.delta()) {
                    Transition transition = transitionObject;
                    if (transition.label() == null || !transition.label().equals(smallerProperty)) continue;
                    Automaton smallerPropertyAutomaton = this.buildCompleteAutomataForProperties(smallerProperty, inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties);
                    if (smallerPropertyAutomaton.delta().size() != 1) {
                        this.automataConnector(biggerPropertyAutomaton, smallerPropertyAutomaton, transition);
                    }
                    someInternalTransitionMatched = true;
                }
                if (someInternalTransitionMatched) continue;
                Automaton smallerPropertyAutomaton = this.buildCompleteAutomataForProperties(smallerProperty, inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties);
                Transition initial2TerminalTransition = biggerPropertyAutomaton.deltaFrom(biggerPropertyAutomaton.initials().iterator().next(), biggerPropertyAutomaton.terminals().iterator().next()).iterator().next();
                this.automataConnector(biggerPropertyAutomaton, smallerPropertyAutomaton, initial2TerminalTransition);
            }
        }
        if (propertyToBuildAutomatonFor.getInverseProperty().isAnonymous() && individualAutomata.containsKey(propertyToBuildAutomatonFor.getInverseProperty())) {
            Automaton inversePropertyAutomaton = this.buildCompleteAutomataForProperties(propertyToBuildAutomatonFor.getInverseProperty(), inversePropertiesMap, individualAutomata, completeAutomata, inversedPropertyDependencyGraph, symmetricObjectProperties, transitiveProperties);
            this.increaseAutomatonWithInversePropertyAutomaton(biggerPropertyAutomaton, this.getMirroredCopy(inversePropertyAutomaton));
            if (!completeAutomata.containsKey(propertyToBuildAutomatonFor)) {
                this.finalizeConstruction(completeAutomata, propertyToBuildAutomatonFor, biggerPropertyAutomaton, symmetricObjectProperties, transitiveProperties);
            } else {
                biggerPropertyAutomaton = completeAutomata.get(propertyToBuildAutomatonFor);
            }
        } else {
            this.increaseWithDefinedInverseIfNecessary(propertyToBuildAutomatonFor, biggerPropertyAutomaton, inversePropertiesMap, individualAutomata);
            if (!completeAutomata.containsKey(propertyToBuildAutomatonFor)) {
                this.finalizeConstruction(completeAutomata, propertyToBuildAutomatonFor, biggerPropertyAutomaton, symmetricObjectProperties, transitiveProperties);
            } else {
                biggerPropertyAutomaton = completeAutomata.get(propertyToBuildAutomatonFor);
            }
        }
        return biggerPropertyAutomaton;
    }

    private void finalizeConstruction(Map<OWLObjectPropertyExpression, Automaton> completeAutomata, OWLObjectPropertyExpression propertyToBuildAutomatonFor, Automaton biggerPropertyAutomaton, Set<OWLObjectPropertyExpression> symmetricObjectProperties, Set<OWLObjectPropertyExpression> transitiveProperties) {
        if (transitiveProperties.contains(propertyToBuildAutomatonFor.getInverseProperty())) {
            Transition transition = new Transition(biggerPropertyAutomaton.terminals().iterator().next(), null, biggerPropertyAutomaton.initials().iterator().next());
            biggerPropertyAutomaton.addTransition(transition, "Could not create automaton for symmetric property: " + propertyToBuildAutomatonFor);
        }
        if (symmetricObjectProperties.contains(propertyToBuildAutomatonFor)) {
            Transition basicTransition = new Transition(biggerPropertyAutomaton.initials().iterator().next(), propertyToBuildAutomatonFor.getInverseProperty(), biggerPropertyAutomaton.terminals().iterator().next());
            this.automataConnector(biggerPropertyAutomaton, this.getMirroredCopy(biggerPropertyAutomaton), basicTransition);
        }
        Automaton bga = this.minimizeAndNormalizeAutomaton(biggerPropertyAutomaton);
        completeAutomata.put(propertyToBuildAutomatonFor, bga);
        completeAutomata.put(propertyToBuildAutomatonFor.getInverseProperty(), this.getMirroredCopy(bga));
    }

    protected void increaseWithDefinedInverseIfNecessary(OWLObjectPropertyExpression propertyToBuildAutomatonFor, Automaton leafPropertyAutomaton, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> inversePropertiesMap, Map<OWLObjectPropertyExpression, Automaton> individualAutomata) {
        Set<OWLObjectPropertyExpression> inverses = inversePropertiesMap.get(propertyToBuildAutomatonFor);
        if (inverses != null) {
            Automaton inversePropertyAutomaton = null;
            for (OWLObjectPropertyExpression inverse : inverses) {
                if (!individualAutomata.containsKey(inverse) || inverse.equals(propertyToBuildAutomatonFor)) continue;
                inversePropertyAutomaton = individualAutomata.get(inverse);
                this.increaseAutomatonWithInversePropertyAutomaton(leafPropertyAutomaton, inversePropertyAutomaton);
            }
        } else if (individualAutomata.containsKey(propertyToBuildAutomatonFor.getInverseProperty())) {
            Automaton autoOfInv_Role = individualAutomata.get(propertyToBuildAutomatonFor.getInverseProperty());
            this.increaseAutomatonWithInversePropertyAutomaton(leafPropertyAutomaton, autoOfInv_Role);
        }
    }

    protected Automaton minimizeAndNormalizeAutomaton(Automaton automaton) {
        return automaton;
    }

    protected void useStandardAutomataConnector(Automaton biggerPropertyAutomaton, Automaton smallerPropertyAutomaton, Transition transition) {
        Map<State, State> stateMapper = this.getDisjointUnion(biggerPropertyAutomaton, smallerPropertyAutomaton);
        State initialState = transition.start();
        State finalState = transition.end();
        State oldStartOfSmaller = stateMapper.get(smallerPropertyAutomaton.initials().iterator().next());
        State oldFinalOfSmaller = stateMapper.get(smallerPropertyAutomaton.terminals().iterator().next());
        Transition t1 = new Transition(initialState, null, oldStartOfSmaller);
        Transition t2 = new Transition(oldFinalOfSmaller, null, finalState);
        biggerPropertyAutomaton.addTransition(t1, "Could not build the Complete Automata of non-Simple Properties");
        biggerPropertyAutomaton.addTransition(t2, "Could not build the Complete Automata of non-Simple Properties");
    }

    protected void automataConnector(Automaton biggerPropertyAutomaton, Automaton smallerPropertyAutomaton, Transition transition) {
        this.useStandardAutomataConnector(biggerPropertyAutomaton, smallerPropertyAutomaton, transition);
    }

    protected Set<Transition> deltaToState(Automaton smallerPropertyAutomaton, State state) {
        HashSet<Transition> incommingTrans = new HashSet<Transition>();
        for (Transition transitionObject : smallerPropertyAutomaton.delta()) {
            Transition transition = transitionObject;
            if (!transition.end().equals(state)) continue;
            incommingTrans.add(transition);
        }
        return incommingTrans;
    }

    protected Graph<OWLObjectPropertyExpression> buildPropertyOrdering(Collection<List<OWLObjectPropertyExpression>> simpleObjectPropertyInclusions, Collection<OWLAxioms.ComplexObjectPropertyInclusion> complexObjectPropertyInclusions, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> equivalentPropertiesMap) {
        Graph<OWLObjectPropertyExpression> propertyDependencyGraph = new Graph<OWLObjectPropertyExpression>();
        for (List<OWLObjectPropertyExpression> list : simpleObjectPropertyInclusions) {
            if (list.get(0).equals(list.get(1)) || list.get(0).equals(list.get(1).getInverseProperty()) || equivalentPropertiesMap.get(list.get(0)) != null && equivalentPropertiesMap.get(list.get(0)).contains(list.get(1))) continue;
            propertyDependencyGraph.addEdge(list.get(0), list.get(1));
        }
        for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : complexObjectPropertyInclusions) {
            OWLObjectPropertyExpression owlSuperProperty = complexObjectPropertyInclusion.m_superObjectProperty;
            OWLObjectPropertyExpression owlSubPropertyInChain = null;
            OWLObjectPropertyExpression[] owlSubProperties = complexObjectPropertyInclusion.m_subObjectProperties;
            if (owlSubProperties.length != 2 && owlSuperProperty.equals(owlSubProperties[0]) && owlSuperProperty.equals(owlSubProperties[owlSubProperties.length - 1])) {
                throw new IllegalArgumentException("The given property hierarchy is not regular.");
            }
            for (int i = 0; i < owlSubProperties.length; ++i) {
                owlSubPropertyInChain = owlSubProperties[i];
                if (owlSubProperties.length != 2 && i > 0 && i < owlSubProperties.length - 1 && (owlSubPropertyInChain.equals(owlSuperProperty) || equivalentPropertiesMap.containsKey(owlSuperProperty) && equivalentPropertiesMap.get(owlSuperProperty).contains(owlSubPropertyInChain))) {
                    throw new IllegalArgumentException("The given property hierarchy is not regular.");
                }
                if (owlSubPropertyInChain.getInverseProperty().equals(owlSuperProperty)) {
                    throw new IllegalArgumentException("The given property hierarchy is not regular.");
                }
                if (owlSubPropertyInChain.equals(owlSuperProperty)) continue;
                propertyDependencyGraph.addEdge(owlSubPropertyInChain, owlSuperProperty);
            }
        }
        return propertyDependencyGraph;
    }

    protected void checkForRegularity(Graph<OWLObjectPropertyExpression> propertyDependencyGraph, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> equivalentPropertiesMap) {
        Object regularityCheckGraph = propertyDependencyGraph.clone();
        boolean trimmed = false;
        do {
            trimmed = false;
            Object regularityCheckGraphTemp = ((Graph)regularityCheckGraph).clone();
            for (OWLObjectPropertyExpression prop : ((Graph)regularityCheckGraphTemp).getElements()) {
                for (OWLObjectPropertyExpression succProp : ((Graph)regularityCheckGraphTemp).getSuccessors(prop)) {
                    if (!equivalentPropertiesMap.containsKey(prop) || !equivalentPropertiesMap.get(prop).contains(succProp)) continue;
                    for (OWLObjectPropertyExpression succPropSucc : ((Graph)regularityCheckGraphTemp).getSuccessors(succProp)) {
                        if (prop.equals(succPropSucc)) continue;
                        ((Graph)regularityCheckGraph).addEdge(prop, succPropSucc);
                    }
                    trimmed = true;
                    ((Graph)regularityCheckGraph).getSuccessors(prop).remove(succProp);
                }
            }
        } while (trimmed);
        ((Graph)regularityCheckGraph).transitivelyClose();
        for (OWLObjectPropertyExpression prop : ((Graph)regularityCheckGraph).getElements()) {
            Set<OWLObjectPropertyExpression> successors = ((Graph)regularityCheckGraph).getSuccessors(prop);
            if (!successors.contains(prop) && !successors.contains(prop.getInverseProperty())) continue;
            throw new IllegalArgumentException("The given property hierarchy is not regular.\nThere is a cyclic dependency involving property " + prop);
        }
    }

    protected Map<OWLObjectPropertyExpression, Automaton> buildIndividualAutomata(Graph<OWLObjectPropertyExpression> complexPropertiesDependencyGraph, Collection<OWLAxioms.ComplexObjectPropertyInclusion> complexObjectPropertyInclusions, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> equivalentPropertiesMap, Set<OWLObjectPropertyExpression> transitiveProperties) {
        HashMap<OWLObjectPropertyExpression, Automaton> automataMap = new HashMap<OWLObjectPropertyExpression, Automaton>();
        for (OWLAxioms.ComplexObjectPropertyInclusion inclusion : complexObjectPropertyInclusions) {
            OWLObjectPropertyExpression transitionLabel;
            int i;
            State fromState;
            OWLObjectPropertyExpression[] subObjectProperties = inclusion.m_subObjectProperties;
            OWLObjectPropertyExpression superObjectProperty = inclusion.m_superObjectProperty;
            Automaton automaton = null;
            State initialState = null;
            State finalState = null;
            if (!automataMap.containsKey(superObjectProperty)) {
                automaton = new Automaton();
                initialState = automaton.addState(true, false);
                finalState = automaton.addState(false, true);
                automaton.addTransition(new Transition(initialState, superObjectProperty, finalState), COULD_NOT_CREATE_AUTOMATON);
            } else {
                automaton = (Automaton)automataMap.get(superObjectProperty);
                initialState = automaton.initials().iterator().next();
                finalState = automaton.terminals().iterator().next();
            }
            if (subObjectProperties.length == 2 && subObjectProperties[0].equals(superObjectProperty) && subObjectProperties[1].equals(superObjectProperty)) {
                automaton.addTransition(new Transition(finalState, null, initialState), COULD_NOT_CREATE_AUTOMATON);
                transitiveProperties.add(superObjectProperty);
            } else if (subObjectProperties[0].equals(superObjectProperty)) {
                fromState = finalState;
                for (i = 1; i < subObjectProperties.length - 1; ++i) {
                    transitionLabel = subObjectProperties[i];
                    if (equivalentPropertiesMap.containsKey(superObjectProperty) && equivalentPropertiesMap.get(superObjectProperty).contains(transitionLabel)) {
                        transitionLabel = superObjectProperty;
                    }
                    fromState = this.addNewTransition(automaton, fromState, transitionLabel);
                }
                transitionLabel = subObjectProperties[subObjectProperties.length - 1];
                if (equivalentPropertiesMap.containsKey(superObjectProperty) && equivalentPropertiesMap.get(superObjectProperty).contains(transitionLabel)) {
                    transitionLabel = superObjectProperty;
                }
                automaton.addTransition(new Transition(fromState, transitionLabel, finalState), COULD_NOT_CREATE_AUTOMATON);
            } else if (subObjectProperties[subObjectProperties.length - 1].equals(superObjectProperty)) {
                fromState = initialState;
                for (i = 0; i < subObjectProperties.length - 2; ++i) {
                    transitionLabel = subObjectProperties[i];
                    if (equivalentPropertiesMap.containsKey(superObjectProperty) && equivalentPropertiesMap.get(superObjectProperty).contains(transitionLabel)) {
                        transitionLabel = superObjectProperty;
                    }
                    fromState = this.addNewTransition(automaton, fromState, transitionLabel);
                }
                transitionLabel = subObjectProperties[subObjectProperties.length - 2];
                if (equivalentPropertiesMap.containsKey(superObjectProperty) && equivalentPropertiesMap.get(superObjectProperty).contains(transitionLabel)) {
                    transitionLabel = superObjectProperty;
                }
                automaton.addTransition(new Transition(fromState, transitionLabel, initialState), COULD_NOT_CREATE_AUTOMATON);
            } else {
                fromState = initialState;
                for (i = 0; i < subObjectProperties.length - 1; ++i) {
                    transitionLabel = subObjectProperties[i];
                    if (equivalentPropertiesMap.containsKey(superObjectProperty) && equivalentPropertiesMap.get(superObjectProperty).contains(transitionLabel)) {
                        transitionLabel = superObjectProperty;
                    }
                    fromState = this.addNewTransition(automaton, fromState, transitionLabel);
                }
                transitionLabel = subObjectProperties[subObjectProperties.length - 1];
                if (equivalentPropertiesMap.containsKey(superObjectProperty) && equivalentPropertiesMap.get(superObjectProperty).contains(transitionLabel)) {
                    transitionLabel = superObjectProperty;
                }
                automaton.addTransition(new Transition(fromState, transitionLabel, finalState), COULD_NOT_CREATE_AUTOMATON);
            }
            automataMap.put(superObjectProperty, automaton);
        }
        for (OWLAxioms.ComplexObjectPropertyInclusion inclusion : complexObjectPropertyInclusions) {
            OWLObjectPropertyExpression superpropertyExpression = inclusion.m_superObjectProperty;
            OWLObjectPropertyExpression[] subpropertyExpression = inclusion.m_subObjectProperties;
            if (subpropertyExpression.length != 2 || !subpropertyExpression[0].equals(superpropertyExpression) || !subpropertyExpression[1].equals(superpropertyExpression) || complexPropertiesDependencyGraph.getElements().contains(superpropertyExpression) || automataMap.containsKey(superpropertyExpression.getInverseProperty())) continue;
            complexPropertiesDependencyGraph.addEdge(superpropertyExpression, superpropertyExpression);
            Automaton propertyAutomaton = (Automaton)automataMap.get(superpropertyExpression);
            automataMap.put(superpropertyExpression.getInverseProperty(), this.getMirroredCopy(propertyAutomaton));
        }
        OWLDataFactory df = OWLManager.createOWLOntologyManager().getOWLDataFactory();
        OWLObjectProperty topOP = df.getOWLTopObjectProperty();
        if (!automataMap.keySet().contains(topOP)) {
            Automaton automaton = new Automaton();
            State initialState = automaton.addState(true, false);
            State finalState = automaton.addState(false, true);
            automaton.addTransition(new Transition(initialState, topOP, finalState), COULD_NOT_CREATE_AUTOMATON);
            automaton.addTransition(new Transition(finalState, null, initialState), COULD_NOT_CREATE_AUTOMATON);
            automataMap.put((OWLObjectPropertyExpression)topOP, automaton);
        }
        return automataMap;
    }

    protected Map<State, State> getDisjointUnion(Automaton automaton1, Automaton automaton2) {
        HashMap<State, State> stateMapperUnionInverse = new HashMap<State, State>();
        for (State state : automaton2.states()) {
            stateMapperUnionInverse.put(state, automaton1.addState(false, false));
        }
        for (Object object : automaton2.delta()) {
            Transition transition = (Transition)object;
            automaton1.addTransition(new Transition((State)stateMapperUnionInverse.get(transition.start()), transition.label(), (State)stateMapperUnionInverse.get(transition.end())), "Could not create disjoint union of automata");
        }
        return stateMapperUnionInverse;
    }

    protected Automaton getMirroredCopy(Automaton automaton) {
        Automaton mirroredCopy = new Automaton();
        HashMap<State, State> map = new HashMap<State, State>();
        Iterator<Object> iterator = automaton.states().iterator();
        while (iterator.hasNext()) {
            State state;
            State state2 = state = iterator.next();
            map.put(state2, mirroredCopy.addState(state2.isTerminal(), state2.isInitial()));
        }
        for (Object object : automaton.delta()) {
            Transition transition = (Transition)object;
            Object label = transition.label();
            if (label instanceof OWLObjectPropertyExpression) {
                label = ((OWLObjectPropertyExpression)label).getInverseProperty();
            }
            mirroredCopy.addTransition(new Transition((State)map.get(transition.end()), label, (State)map.get(transition.start())), null);
        }
        return mirroredCopy;
    }

    protected State addNewTransition(Automaton automaton, State fromState, OWLObjectPropertyExpression objectPropertyExpression) {
        OWLObjectPropertyExpression propertyOfChain = objectPropertyExpression;
        State toState = automaton.addState(false, false);
        automaton.addTransition(new Transition(fromState, propertyOfChain, toState), COULD_NOT_CREATE_AUTOMATON);
        return toState;
    }
}

