/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionFactory {
    private static final String MISBEHAVING_TRIPLE_COMPARATOR = "Misbehaving triple comparator, leaving triples unsorted";
    private static final String COMPARISON_METHOD = "Comparison method violates its general contract!";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CollectionFactory.class.getName());
    private static final AtomicInteger EXPECTEDTHREADS = new AtomicInteger(1);

    public static <T extends Comparable<T>> void sortOptionallyComparables(@Nonnull List<T> toReturn) {
        try {
            Collections.sort(toReturn);
        }
        catch (IllegalArgumentException e) {
            if (!e.getMessage().contains(COMPARISON_METHOD)) {
                throw e;
            }
            LOGGER.warn(MISBEHAVING_TRIPLE_COMPARATOR, (Throwable)e);
        }
    }

    public static void sortOptionally(@Nonnull List<? extends OWLObject> toReturn) {
        try {
            Collections.sort(toReturn);
        }
        catch (IllegalArgumentException e) {
            if (!e.getMessage().contains(COMPARISON_METHOD)) {
                throw e;
            }
            LOGGER.warn(MISBEHAVING_TRIPLE_COMPARATOR, (Throwable)e);
        }
    }

    @Nonnull
    public static <T extends Comparable<T>> List<T> sortOptionallyComparables(@Nonnull Collection<T> toReturn) {
        ArrayList<T> list = new ArrayList<T>(toReturn);
        try {
            Collections.sort(list);
        }
        catch (IllegalArgumentException e) {
            if (!e.getMessage().contains(COMPARISON_METHOD)) {
                throw e;
            }
            LOGGER.warn(MISBEHAVING_TRIPLE_COMPARATOR, (Throwable)e);
        }
        return list;
    }

    @Nonnull
    public static <T extends OWLObject> List<T> sortOptionally(@Nonnull Collection<T> toReturn) {
        ArrayList<T> list = new ArrayList<T>(toReturn);
        try {
            Collections.sort(list);
        }
        catch (IllegalArgumentException e) {
            if (!e.getMessage().contains(COMPARISON_METHOD)) {
                throw e;
            }
            LOGGER.warn(MISBEHAVING_TRIPLE_COMPARATOR, (Throwable)e);
        }
        return list;
    }

    @Nonnull
    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    public static void setExpectedThreads(int value) {
        EXPECTEDTHREADS.set(value);
    }

    public static int getExpectedThreads() {
        return EXPECTEDTHREADS.get();
    }

    @Nonnull
    public static <T> Set<T> createSet() {
        return new HashSet();
    }

    @Nonnull
    public static <T> Set<T> createLinkedSet() {
        return new LinkedHashSet();
    }

    @Nonnull
    public static <T> List<T> createList() {
        return new ArrayList();
    }

    @Nonnull
    public static <T> List<T> createSyncList() {
        return new CopyOnWriteArrayList();
    }

    @Nonnull
    public static <T> List<T> list(Iterable<T> i) {
        return Lists.newArrayList(i);
    }

    @Nonnull
    @SafeVarargs
    public static <T> List<T> list(T ... i) {
        return Lists.newArrayList((Object[])i);
    }

    @Nonnull
    public static <T> List<T> list(T i) {
        return Collections.singletonList(i);
    }

    @Nonnull
    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    @Nonnull
    public static <T> Set<T> createSet(@Nonnull Collection<T> c) {
        return new HashSet<T>(c);
    }

    @Nonnull
    public static <T> Set<T> createSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    @Nonnull
    public static <K, V> Map<K, V> createMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, WeakReference<V>> createSyncWeakMap() {
        return Collections.synchronizedMap(new WeakHashMap());
    }

    @Nonnull
    @SafeVarargs
    public static <T> Set<T> createSet(T ... elements) {
        return Sets.newHashSet((Object[])elements);
    }

    @Nonnull
    public static <T> Set<T> createSet(@Nonnull T element) {
        Set<T> result = CollectionFactory.createSet();
        result.add(element);
        return result;
    }

    @Nonnull
    public static <T> Set<T> createSyncSet() {
        ConcurrentHashMap internalMap = CollectionFactory.createSyncMap();
        return Collections.newSetFromMap(internalMap);
    }

    @Nonnull
    public static <K, V> ConcurrentHashMap<K, V> createSyncMap() {
        return new ConcurrentHashMap(16, 0.75f, EXPECTEDTHREADS.get());
    }

    @Nonnull
    public static <T> Set<T> getCopyOnRequestSet(Collection<T> source) {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(source);
    }

    @Nonnull
    public static <T> Set<T> getCopyOnRequestSetFromMutableCollection(@Nullable Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        return new ConditionalCopySet<T>(source, true);
    }

    @Nonnull
    public static <T> Set<T> getCopyOnRequestSetFromImmutableCollection(@Nullable Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        return new ConditionalCopySet<T>(source, false);
    }

    public static class ConditionalCopySet<T>
    implements Set<T> {
        private static final int MAXCONTAINS = 10;
        private boolean copyDone = false;
        protected Collection<T> delegate;
        private int containsCounter = 0;

        public ConditionalCopySet(@Nonnull Collection<T> source, boolean listCopy) {
            this.delegate = listCopy ? new ArrayList<T>(source) : source;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConditionalCopySet) {
                return this.delegate.containsAll(((ConditionalCopySet)obj).delegate) && ((ConditionalCopySet)obj).delegate.containsAll(this.delegate);
            }
            if (obj instanceof Collection) {
                return this.delegate.containsAll((Collection)obj) && ((Collection)obj).containsAll(this.delegate);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean add(T e) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.addAll(c);
        }

        @Override
        public void clear() {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>();
            }
            this.delegate.clear();
        }

        @Override
        public boolean contains(Object o) {
            ++this.containsCounter;
            if (this.containsCounter >= 10 && !this.copyDone) {
                this.checkDelegate();
            }
            return this.delegate.contains(o);
        }

        private void checkDelegate() {
            if (!(this.delegate instanceof Set)) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            ++this.containsCounter;
            if (this.containsCounter >= 10 && !this.copyDone) {
                this.checkDelegate();
            }
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        @Nonnull
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.retainAll(c);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        @Nonnull
        public <Type> Type[] toArray(Type[] a) {
            return this.delegate.toArray(a);
        }
    }
}

