/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class CommonBaseIRIMapper
implements OWLOntologyIRIMapper {
    private final IRI base;
    private final Map<IRI, IRI> iriMap = new HashMap<IRI, IRI>();

    public CommonBaseIRIMapper(IRI base) {
        this.base = OWLAPIPreconditions.checkNotNull(base, "base cannot be null");
    }

    public void addMapping(IRI ontologyIRI, String localName) {
        OWLAPIPreconditions.checkNotNull(localName, "localName cannot be null");
        OWLAPIPreconditions.checkNotNull(ontologyIRI, "ontologyIRI cannot be null");
        IRI documentIRI = this.base.resolve(localName);
        this.iriMap.put(ontologyIRI, documentIRI);
    }

    @Override
    @Nullable
    public IRI getDocumentIRI(IRI ontologyIRI) {
        OWLAPIPreconditions.checkNotNull(ontologyIRI, "ontologyIRI cannot be null");
        return this.iriMap.get(ontologyIRI);
    }
}

