/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.change.AddAxiomData;
import org.semanticweb.owlapi.change.AxiomChangeData;
import org.semanticweb.owlapi.change.RemoveAxiomData;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class OWLObjectTransformer<T> {
    private final Function<T, T> transformer;
    private final Predicate<Object> predicate;
    private final Class<T> witness;
    private final OWLDataFactory df;

    public OWLObjectTransformer(Predicate<Object> predicate, Function<T, T> transformer, OWLDataFactory df, Class<T> witness) {
        this.predicate = OWLAPIPreconditions.checkNotNull(predicate, "predicate cannot be null");
        this.transformer = OWLAPIPreconditions.checkNotNull(transformer, "transformer cannot be null");
        this.df = OWLAPIPreconditions.checkNotNull(df, "df cannot be null");
        this.witness = OWLAPIPreconditions.checkNotNull(witness, "witness cannot be null");
    }

    public List<AxiomChangeData> change(OWLObject o) {
        OWLAPIPreconditions.checkNotNull(o, "o cannot be null");
        ArrayList<AxiomChangeData> changes = new ArrayList<AxiomChangeData>();
        Visitor<T> v = new Visitor<T>(new ArrayList<OWLOntologyChange>(), changes, this.predicate, this.transformer, this.df, this.witness);
        o.accept(v);
        return changes;
    }

    public List<OWLOntologyChange> change(OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        ArrayList<AxiomChangeData> changes = new ArrayList<AxiomChangeData>();
        ArrayList<OWLOntologyChange> ontologyChanges = new ArrayList<OWLOntologyChange>();
        Visitor<T> v = new Visitor<T>(ontologyChanges, changes, this.predicate, this.transformer, this.df, this.witness);
        ontology.accept(v);
        for (AxiomChangeData change : changes) {
            ontologyChanges.add(change.createOntologyChange(ontology));
        }
        return ontologyChanges;
    }

    private static class Visitor<T>
    implements OWLObjectVisitorEx<Object> {
        private final List<AxiomChangeData> changes;
        private final List<OWLOntologyChange> ontologyChanges;
        private final Predicate<Object> predicate;
        private final Function<T, T> transformer;
        private final Class<T> witness;
        private final OWLDataFactory df;

        Visitor(List<OWLOntologyChange> ontologyChanges, List<AxiomChangeData> changes, Predicate<Object> predicate, Function<T, T> transformer, OWLDataFactory df, Class<T> witness) {
            this.changes = changes;
            this.ontologyChanges = ontologyChanges;
            this.predicate = predicate;
            this.transformer = transformer;
            this.df = df;
            this.witness = witness;
        }

        @Nullable
        protected OWLAxiom checkAxiom(OWLAxiom axiom) {
            OWLAxiom transform;
            if (this.witness.isInstance(axiom) && this.update(transform = (OWLAxiom)this.transformer.apply(axiom), axiom) == transform) {
                return transform;
            }
            return null;
        }

        protected OWLAxiom update(OWLAxiom transform, OWLAxiom axiom) {
            if (!axiom.equals(transform)) {
                this.changes.add(new RemoveAxiomData(axiom));
                this.changes.add(new AddAxiomData(transform));
                return transform;
            }
            return axiom;
        }

        @Nullable
        protected <Q> Q check(Q o) {
            T transform;
            if (this.witness.isInstance(o) && (transform = this.transformer.apply(this.witness.cast(o))) != o) {
                return (Q)transform;
            }
            return null;
        }

        protected <Q extends OWLObject> Q t(Q t) {
            return (Q)((OWLObject)t.accept(this));
        }

        protected OWLFacet t(OWLFacet t) {
            return (OWLFacet)this.transformer.apply(t);
        }

        protected <Q extends OWLObject> Collection<Q> t(Stream<Q> c) {
            return OWLAPIStreamUtils.asList(c.map(this::t));
        }

        protected <Q extends OWLObject> List<Q> t(List<Q> c) {
            ArrayList<OWLObject> list = new ArrayList<OWLObject>();
            for (OWLObject t : c) {
                list.add(this.t(t));
            }
            return list;
        }

        @Override
        public Object visit(OWLDeclarationAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDeclarationAxiom(this.t(axiom.getEntity()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDatatypeDefinitionAxiom(this.t(axiom.getDatatype()), this.t(axiom.getDataRange()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLAnnotationAssertionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)this.t((OWLObject)axiom.getSubject()), this.t(axiom.getAnnotation()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLSubAnnotationPropertyOfAxiom(this.t(axiom.getSubProperty()), this.t(axiom.getSuperProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLAnnotationPropertyDomainAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLAnnotationPropertyDomainAxiom((OWLAnnotationProperty)this.t((OWLObject)axiom.getProperty()), (IRI)this.t((OWLObject)axiom.getDomain()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLAnnotationPropertyRangeAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLAnnotationPropertyRangeAxiom((OWLAnnotationProperty)this.t((OWLObject)axiom.getProperty()), (IRI)this.t((OWLObject)axiom.getRange()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLSubClassOfAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLSubClassOfAxiom(this.t(axiom.getSubClass()), this.t(axiom.getSuperClass()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLIndividual)this.t(axiom.getObject()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDisjointClassesAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDisjointClassesAxiom(this.t(axiom.classExpressions()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDataPropertyDomainAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.t((OWLObject)axiom.getProperty()), (OWLClassExpression)this.t((OWLObject)axiom.getDomain()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLObjectPropertyDomainAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), (OWLClassExpression)this.t((OWLObject)axiom.getDomain()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLEquivalentObjectPropertiesAxiom(this.t(axiom.properties()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLLiteral)this.t(axiom.getObject()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDifferentIndividualsAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDifferentIndividualsAxiom(this.t(axiom.individuals()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDisjointDataPropertiesAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDisjointDataPropertiesAxiom(this.t(axiom.properties()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDisjointObjectPropertiesAxiom(this.t(axiom.properties()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLObjectPropertyRangeAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), (OWLClassExpression)this.t((OWLObject)axiom.getRange()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLObjectPropertyAssertionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLIndividual)this.t(axiom.getObject()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLSubObjectPropertyOfAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getSubProperty()), (OWLObjectPropertyExpression)this.t((OWLObject)axiom.getSuperProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDisjointUnionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDisjointUnionAxiom(this.t(axiom.getOWLClass()), this.t(axiom.classExpressions()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDataPropertyRangeAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.t((OWLObject)axiom.getProperty()), (OWLDataRange)this.t((OWLObject)axiom.getRange()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLFunctionalDataPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLEquivalentDataPropertiesAxiom(this.t(axiom.properties()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLClassAssertionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLClassAssertionAxiom(this.t(axiom.getClassExpression()), this.t(axiom.getIndividual()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLEquivalentClassesAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLEquivalentClassesAxiom(this.t(axiom.classExpressions()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLDataPropertyAssertionAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLLiteral)this.t(axiom.getObject()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLSubDataPropertyOfAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.t((OWLObject)axiom.getSubProperty()), (OWLDataPropertyExpression)this.t((OWLObject)axiom.getSuperProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLSameIndividualAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLSameIndividualAxiom(this.t(axiom.individuals()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLSubPropertyChainOfAxiom(this.t(axiom.getPropertyChain()), this.t(axiom.getSuperProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLInverseObjectPropertiesAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLInverseObjectPropertiesAxiom(this.t(axiom.getFirstProperty()), this.t(axiom.getSecondProperty()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLHasKeyAxiom axiom) {
            return this.visitAxiom(axiom, () -> this.df.getOWLHasKeyAxiom(this.t(axiom.getClassExpression()), this.t(axiom.propertyExpressions()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(SWRLRule axiom) {
            return this.visitAxiom(axiom, () -> this.df.getSWRLRule(this.t(axiom.body()), this.t(axiom.head()), this.t(axiom.annotations())));
        }

        @Override
        public Object visit(OWLClass ce) {
            return this.visit(ce, () -> this.df.getOWLClass(this.t(ce.getIRI())));
        }

        @Override
        public Object visit(OWLObjectIntersectionOf ce) {
            return this.visit(ce, () -> this.df.getOWLObjectIntersectionOf(this.t(ce.operands())));
        }

        @Override
        public Object visit(OWLObjectUnionOf ce) {
            return this.visit(ce, () -> this.df.getOWLObjectUnionOf(this.t(ce.operands())));
        }

        @Override
        public Object visit(OWLObjectComplementOf ce) {
            return this.visit(ce, () -> this.df.getOWLObjectComplementOf(this.t(ce.getOperand())));
        }

        @Override
        public Object visit(OWLObjectSomeValuesFrom ce) {
            return this.visit(ce, () -> this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLObjectAllValuesFrom ce) {
            return this.visit(ce, () -> this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLObjectHasValue ce) {
            return this.visit(ce, () -> this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLIndividual)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLObjectMinCardinality ce) {
            return this.visit(ce, () -> this.df.getOWLObjectMinCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLObjectExactCardinality ce) {
            return this.visit(ce, () -> this.df.getOWLObjectExactCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLObjectMaxCardinality ce) {
            return this.visit(ce, () -> this.df.getOWLObjectMaxCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLObjectHasSelf ce) {
            return this.visit(ce, () -> this.df.getOWLObjectHasSelf(this.t(ce.getProperty())));
        }

        @Override
        public Object visit(OWLObjectOneOf ce) {
            return this.visit(ce, () -> this.df.getOWLObjectOneOf(this.t(ce.individuals())));
        }

        @Override
        public Object visit(OWLDataSomeValuesFrom ce) {
            return this.visit(ce, () -> this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLDataAllValuesFrom ce) {
            return this.visit(ce, () -> this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLDataHasValue ce) {
            return this.visit(ce, () -> this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLLiteral)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLDataMinCardinality ce) {
            return this.visit(ce, () -> this.df.getOWLDataMinCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLDataExactCardinality ce) {
            return this.visit(ce, () -> this.df.getOWLDataExactCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLDataMaxCardinality ce) {
            return this.visit(ce, () -> this.df.getOWLDataMaxCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller())));
        }

        @Override
        public Object visit(OWLDatatype node) {
            return this.visit(node, () -> this.df.getOWLDatatype(this.t(node.getIRI())));
        }

        @Override
        public Object visit(OWLDataComplementOf node) {
            return this.visit(node, () -> this.df.getOWLDataComplementOf(this.t(node.getDataRange())));
        }

        @Override
        public Object visit(OWLDataOneOf node) {
            return this.visit(node, () -> this.df.getOWLDataOneOf(this.t(node.values())));
        }

        @Override
        public Object visit(OWLDataIntersectionOf node) {
            return this.visit(node, () -> this.df.getOWLDataIntersectionOf(this.t(node.operands())));
        }

        @Override
        public Object visit(OWLDataUnionOf node) {
            return this.visit(node, () -> this.df.getOWLDataUnionOf(this.t(node.operands())));
        }

        @Override
        public Object visit(OWLDatatypeRestriction node) {
            return this.visit(node, () -> this.df.getOWLDatatypeRestriction(this.t(node.getDatatype()), this.t(node.facetRestrictions())));
        }

        @Override
        public Object visit(OWLLiteral node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.test(node)) {
                return node;
            }
            if (node.isRDFPlainLiteral()) {
                return node;
            }
            return this.df.getOWLLiteral(node.getLiteral(), this.t(node.getDatatype()));
        }

        @Override
        public Object visit(OWLFacetRestriction node) {
            return this.visit(node, () -> this.df.getOWLFacetRestriction(this.t(node.getFacet()), this.t(node.getFacetValue())));
        }

        @Override
        public Object visit(OWLObjectProperty property) {
            return this.visit(property, () -> this.df.getOWLObjectProperty(this.t(property.getIRI())));
        }

        @Override
        public Object visit(OWLObjectInverseOf property) {
            return this.visit(property, () -> this.df.getOWLObjectInverseOf(this.t(property.getNamedProperty())));
        }

        @Override
        public Object visit(OWLDataProperty property) {
            return this.visit(property, () -> this.df.getOWLDataProperty(this.t(property.getIRI())));
        }

        @Override
        public Object visit(OWLAnnotationProperty property) {
            return this.visit(property, () -> this.df.getOWLAnnotationProperty(this.t(property.getIRI())));
        }

        @Override
        public Object visit(OWLNamedIndividual individual) {
            return this.visit(individual, () -> this.df.getOWLNamedIndividual(this.t(individual.getIRI())));
        }

        @Override
        public Object visit(OWLAnnotation node) {
            return this.visit(node, () -> this.df.getOWLAnnotation(this.t(node.getProperty()), this.t(node.getValue()), this.t(node.annotations())));
        }

        @Override
        public Object visit(IRI iri) {
            OWLObject transform = this.check(iri);
            if (transform != null) {
                return transform;
            }
            return iri;
        }

        @Override
        public Object visit(OWLAnonymousIndividual individual) {
            OWLObject transform = this.check(individual);
            if (transform != null) {
                return transform;
            }
            return individual;
        }

        @Override
        public Object visit(SWRLClassAtom node) {
            return this.visit(node, () -> this.df.getSWRLClassAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getArgument())));
        }

        @Override
        public Object visit(SWRLDataRangeAtom node) {
            return this.visit(node, () -> this.df.getSWRLDataRangeAtom(this.t(node.getPredicate()), (SWRLDArgument)this.t((OWLObject)node.getArgument())));
        }

        @Override
        public Object visit(SWRLObjectPropertyAtom node) {
            return this.visit(node, () -> this.df.getSWRLObjectPropertyAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument())));
        }

        @Override
        public Object visit(SWRLDataPropertyAtom node) {
            return this.visit(node, () -> this.df.getSWRLDataPropertyAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLDArgument)this.t((OWLObject)node.getSecondArgument())));
        }

        @Override
        public Object visit(SWRLBuiltInAtom node) {
            return this.visit(node, () -> this.df.getSWRLBuiltInAtom(this.t(node.getPredicate()), this.t(node.getArguments())));
        }

        @Override
        public Object visit(SWRLVariable node) {
            return this.visit(node, () -> this.df.getSWRLVariable(this.t(node.getIRI())));
        }

        @Override
        public Object visit(SWRLIndividualArgument node) {
            return this.visit(node, () -> this.df.getSWRLIndividualArgument(this.t(node.getIndividual())));
        }

        @Override
        public Object visit(SWRLLiteralArgument node) {
            return this.visit(node, () -> this.df.getSWRLLiteralArgument(this.t(node.getLiteral())));
        }

        @Override
        public Object visit(SWRLSameIndividualAtom node) {
            return this.visit(node, () -> this.df.getSWRLSameIndividualAtom((SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument())));
        }

        @Override
        public Object visit(SWRLDifferentIndividualsAtom node) {
            return this.visit(node, () -> this.df.getSWRLDifferentIndividualsAtom((SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument())));
        }

        protected Object visit(OWLObject node, Supplier<Object> rebuilder) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.test(node)) {
                return node;
            }
            return rebuilder.get();
        }

        protected Object visitAxiom(OWLAxiom node, Supplier<OWLAxiom> rebuilder) {
            OWLAxiom transform = this.checkAxiom(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.test(node)) {
                return node;
            }
            return this.update(rebuilder.get(), node);
        }

        @Override
        public Object visit(OWLOntology ontology) {
            AxiomType.AXIOM_TYPES.stream().flatMap(t -> ontology.axioms(t)).forEach(ax -> ax.accept(this));
            ontology.annotations().forEach(a -> {
                OWLAnnotation transform = this.t(a);
                if (transform != a) {
                    this.ontologyChanges.add(new RemoveOntologyAnnotation(ontology, (OWLAnnotation)a));
                    this.ontologyChanges.add(new AddOntologyAnnotation(ontology, transform));
                }
            });
            ontology.importsDeclarations().forEach(id -> {
                OWLImportsDeclaration transform = this.check(id);
                if (transform != null) {
                    this.ontologyChanges.add(new RemoveImport(ontology, (OWLImportsDeclaration)id));
                    this.ontologyChanges.add(new AddImport(ontology, transform));
                }
            });
            OWLOntologyID transform = this.check(ontology.getOntologyID());
            if (transform != null) {
                this.ontologyChanges.add(new SetOntologyID(ontology, transform));
            }
            return ontology;
        }
    }
}

