/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLEntityFragmentProvider;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;

public class OWLEntityTinyURIConversionStrategy
implements OWLEntityURIConverterStrategy {
    public static final String DEFAULT_BASE = "http://tinyname.org#";
    private final String base;
    private final Map<OWLEntity, IRI> entityNameMap = new HashMap<OWLEntity, IRI>();
    private final OWLEntityFragmentProvider fragmentProvider = new OWLEntityFragmentProvider();

    public OWLEntityTinyURIConversionStrategy() {
        this(DEFAULT_BASE);
    }

    public OWLEntityTinyURIConversionStrategy(String base) {
        this.base = OWLAPIPreconditions.checkNotNull(base, "base cannot be null");
    }

    @Override
    public IRI getConvertedIRI(OWLEntity entity) {
        IRI iri = this.entityNameMap.get(entity);
        if (iri != null) {
            return iri;
        }
        if (entity instanceof OWLDatatype) {
            return entity.getIRI();
        }
        String name = this.fragmentProvider.getName(entity);
        iri = IRI.create(this.base, name);
        this.entityNameMap.put(entity, iri);
        return iri;
    }
}

