/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class UnparsableOntologyException
extends OWLOntologyCreationException {
    private final boolean includeStackTraceInMessage;
    private final IRI documentIRI;
    private final Map<OWLParser, OWLParserException> exceptions;

    public UnparsableOntologyException(IRI documentIRI, Map<OWLParser, OWLParserException> exceptions, OWLOntologyLoaderConfiguration config) {
        super("Could not parse ontology from document IRI: " + documentIRI.toQuotedString());
        this.includeStackTraceInMessage = config.isReportStackTrace();
        this.documentIRI = documentIRI;
        this.exceptions = exceptions;
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Problem parsing ").append(this.documentIRI).append("\nCould not parse ontology.  Either a suitable parser could not be found, or parsing failed.  See parser logs below for explanation.\nThe following parsers were tried:\n");
        int counter = 1;
        for (OWLParser oWLParser : this.exceptions.keySet()) {
            msg.append(counter).append(") ").append(oWLParser).append('\n');
            ++counter;
        }
        msg.append("\n\nDetailed logs:\n");
        for (Map.Entry entry : this.exceptions.entrySet()) {
            Throwable exception = (Throwable)entry.getValue();
            msg.append("--------------------------------------------------------------------------------\nParser: ").append(entry.getKey()).append('\n');
            if (!this.includeStackTraceInMessage) {
                msg.append(exception.getMessage()).append("\n\n");
                continue;
            }
            msg.append("    Stack trace:\n");
            Throwable current = exception;
            int i = 0;
            while (i < 5 && current != null) {
                current = this.addFrame(msg, current);
                ++i;
            }
            msg.append("\n\n");
        }
        return msg.toString();
    }

    @Nullable
    protected Throwable addFrame(StringBuilder msg, Throwable current) {
        msg.append(current.getMessage());
        StackTraceElement[] stackTrace = current.getStackTrace();
        int stackDepth = 0;
        while (stackDepth < 10 && stackDepth < stackTrace.length) {
            StackTraceElement element = stackTrace[stackDepth];
            msg.append("        ").append(element).append('\n');
            ++stackDepth;
        }
        if (current.getCause() != null && current.getCause() != current) {
            return current.getCause();
        }
        return null;
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    public Map<OWLParser, OWLParserException> getExceptions() {
        return Collections.unmodifiableMap(this.exceptions);
    }
}

