/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum DataRangeType implements Serializable,
HasShortForm,
HasPrefixedName,
HasIRI
{
    DATATYPE("Datatype"),
    DATA_ONE_OF("DataOneOf"),
    DATATYPE_RESTRICTION("DatatypeRestriction"),
    DATA_COMPLEMENT_OF("DataComplementOf"),
    DATA_UNION_OF("DataUnionOf"),
    DATA_INTERSECTION_OF("DataIntersectionOf");

    private final String name;
    private final String prefixedName;
    private final IRI iri;

    private DataRangeType(String name) {
        this.name = name;
        this.prefixedName = String.valueOf(Namespaces.OWL.getPrefixName()) + ':' + name;
        this.iri = IRI.create(Namespaces.OWL.getPrefixIRI(), name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getShortForm() {
        return this.name;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }
}

