/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLDocumentFormat
extends Serializable {
    public static boolean isMissingType(OWLEntity entity, OWLOntology ontology) {
        if (entity.isBuiltIn()) {
            return false;
        }
        if (!ontology.containsEntityInSignature(entity)) {
            return false;
        }
        if (ontology.isDeclared(entity, Imports.INCLUDED)) {
            return false;
        }
        Set<OWLOntology> transitiveImports = OWLAPIStreamUtils.asUnorderedSet(ontology.imports());
        if (!transitiveImports.contains(ontology)) {
            for (OWLOntology importedOntology : transitiveImports) {
                if (!importedOntology.containsEntityInSignature(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<IRI> determineIllegalPunnings(boolean add, Stream<OWLEntity> signature, Collection<IRI> punnedEntities) {
        if (!add) {
            return Collections.emptySet();
        }
        LinkedListMultimap punnings = LinkedListMultimap.create();
        signature.filter(e -> !e.isOWLNamedIndividual() && punnedEntities.contains(e.getIRI())).forEach(arg_0 -> OWLDocumentFormat.lambda$1((Multimap)punnings, arg_0));
        return OWLDocumentFormat.computeIllegals(punnings);
    }

    public static Collection<IRI> computeIllegals(Multimap<IRI, EntityType<?>> punnings) {
        HashSet<IRI> illegals = new HashSet<IRI>();
        for (IRI i : punnings.keySet()) {
            Collection puns = punnings.get((Object)i);
            if (puns.contains(EntityType.OBJECT_PROPERTY) && puns.contains(EntityType.ANNOTATION_PROPERTY)) {
                illegals.add(i);
                continue;
            }
            if (puns.contains(EntityType.DATA_PROPERTY) && puns.contains(EntityType.ANNOTATION_PROPERTY)) {
                illegals.add(i);
                continue;
            }
            if (puns.contains(EntityType.DATA_PROPERTY) && puns.contains(EntityType.OBJECT_PROPERTY)) {
                illegals.add(i);
                continue;
            }
            if (!puns.contains(EntityType.DATATYPE) || !puns.contains(EntityType.CLASS)) continue;
            illegals.add(i);
        }
        return illegals;
    }

    public boolean isAddMissingTypes();

    public void setAddMissingTypes(boolean var1);

    public void setParameter(Serializable var1, Serializable var2);

    public <T> T getParameter(Serializable var1, T var2);

    default public boolean isPrefixOWLDocumentFormat() {
        return false;
    }

    default public PrefixDocumentFormat asPrefixOWLDocumentFormat() {
        if (this.isPrefixOWLDocumentFormat()) {
            return (PrefixDocumentFormat)this;
        }
        throw new ClassCastException(String.valueOf(this.getClass().getName()) + " is not a Prefix Document Format");
    }

    public Optional<OWLOntologyLoaderMetaData> getOntologyLoaderMetaData();

    public void setOntologyLoaderMetaData(OWLOntologyLoaderMetaData var1);

    public String getKey();

    public boolean isTextual();

    private static /* synthetic */ void lambda$1(Multimap multimap, OWLEntity e) {
        boolean bl = multimap.put((Object)e.getIRI(), e.getEntityType());
    }
}

