/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.LexicalNotInLexicalSpace;
import org.semanticweb.owlapi.profiles.violations.OntologyIRINotAbsolute;
import org.semanticweb.owlapi.profiles.violations.OntologyVersionIRINotAbsolute;
import org.semanticweb.owlapi.profiles.violations.UseOfDefinedDatatypeInDatatypeRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalFacetRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfNonAbsoluteIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2Profile
implements OWLProfile {
    @Override
    public String getName() {
        return "OWL 2 Full";
    }

    @Override
    public IRI getIRI() {
        return Profiles.OWL2_FULL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWLOntologyProfileWalker walker = new OWLOntologyProfileWalker(ontology.importsClosure());
        OWL2ProfileObjectWalker visitor = new OWL2ProfileObjectWalker(walker);
        walker.walkStructure(visitor);
        Set<OWLProfileViolation> pv = visitor.getProfileViolations();
        return new OWLProfileReport(this, pv);
    }

    private static class OWL2ProfileObjectWalker
    extends OWLOntologyWalkerVisitor {
        private final Set<OWLProfileViolation> profileViolations = new HashSet<OWLProfileViolation>();

        OWL2ProfileObjectWalker(OWLOntologyWalker walker) {
            super(walker);
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        @Override
        public void visit(OWLOntology ontology) {
            OWLOntologyID id = ontology.getOntologyID();
            if (!id.isAnonymous()) {
                Optional<IRI> versionIRI;
                IRI ontologyIRI = id.getOntologyIRI().get();
                if (!ontologyIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyIRINotAbsolute(ontology));
                }
                if ((versionIRI = id.getVersionIRI()).isPresent() && !versionIRI.get().isAbsolute()) {
                    this.profileViolations.add(new OntologyVersionIRINotAbsolute(ontology));
                }
            }
        }

        @Override
        public void visit(IRI iri) {
            if (!iri.isAbsolute()) {
                this.profileViolations.add(new UseOfNonAbsoluteIRI(this.getCurrentOntology(), this.getCurrentAxiom(), iri));
            }
        }

        @Override
        public void visit(OWLLiteral node) {
            if (node.getDatatype().isBuiltIn() && !node.getDatatype().getBuiltInDatatype().isInLexicalSpace(node.getLiteral())) {
                this.profileViolations.add(new LexicalNotInLexicalSpace(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLDatatypeRestriction node) {
            OWLDatatype datatype = node.getDatatype();
            this.getCurrentOntology().importsClosure().flatMap(o -> o.axioms(AxiomType.DATATYPE_DEFINITION)).filter(ax -> datatype.equals(ax.getDatatype())).forEach(ax -> {
                boolean bl = this.profileViolations.add(new UseOfDefinedDatatypeInDatatypeRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            });
            node.facetRestrictions().forEach(r -> {
                OWL2Datatype dt = datatype.getBuiltInDatatype();
                if (!dt.getFacets().contains(r.getFacet())) {
                    this.profileViolations.add(new UseOfIllegalFacetRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node, r.getFacet()));
                }
            });
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            if (!this.getCurrentOntology().isDeclared(axiom.getDatatype(), Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDatatype()));
            }
        }
    }
}

