/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;

public final class SAXParsers {
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String ERROR_TEMPLATE = " not supported by parser type {}, error message: {}";
    private static final String DECLARATION_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private static final String EXPANSION_LIMIT = "entityExpansionLimit";
    private static final String ORACLE_EXPANSION_LIMIT = "http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit";
    private static final String GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final Logger LOGGER = LoggerFactory.getLogger(SAXParsers.class);

    private SAXParsers() {
    }

    public static SAXParserFactory initFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParsers.disableFeature(LOAD_EXTERNAL_DTD, factory);
        SAXParsers.disableFeature(VALIDATION, factory);
        SAXParsers.disableFeature(GENERAL_ENTITIES, factory);
        SAXParsers.disableFeature(PARAMETER_ENTITIES, factory);
        factory.setNamespaceAware(true);
        return factory;
    }

    private static void disableFeature(String feature, SAXParserFactory factory) {
        try {
            factory.setFeature(feature, false);
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.warn(String.valueOf(factory.getClass().getName()) + " does not support " + feature, (Throwable)e);
        }
    }

    public static SAXParser initParserWithOWLAPIStandards(@Nullable DeclHandler handler, String expansion) {
        try {
            SAXParser parser = SAXParsers.initFactory().newSAXParser();
            if (!SAXParsers.addOracleExpansionLimit(parser, expansion)) {
                SAXParsers.addExpansionLimit(parser, expansion);
            }
            SAXParsers.addHandler(handler, parser);
            return parser;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new OWLRuntimeException(e);
        }
    }

    protected static void addExpansionLimit(SAXParser parser, String expansion) {
        try {
            parser.setProperty(EXPANSION_LIMIT, expansion);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            LOGGER.warn("entityExpansionLimit not supported by parser type {}, error message: {}", (Object)parser.getClass().getName(), (Object)ex.getMessage());
        }
    }

    protected static boolean addOracleExpansionLimit(SAXParser parser, String expansion) {
        try {
            parser.setProperty(ORACLE_EXPANSION_LIMIT, expansion);
            return true;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            LOGGER.warn("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit not supported by parser type {}, error message: {}", (Object)parser.getClass().getName(), (Object)e.getMessage());
            return false;
        }
    }

    protected static void addHandler(@Nullable DeclHandler handler, SAXParser parser) {
        if (handler != null) {
            try {
                parser.setProperty(DECLARATION_HANDLER, handler);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                LOGGER.warn("http://xml.org/sax/properties/declaration-handler not supported by parser type {}, error message: {} Entity declarations will not be roundtripped.", (Object)parser.getClass().getName(), (Object)e.getMessage());
            }
        }
    }
}

