/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nullable;

public class Version {
    private final int major;
    private final int minor;
    private final int patch;
    private final int build;
    private final String buildString;

    public Version(int major, int minor, int patch, int build) {
        this(major, minor, patch, build, "");
    }

    public Version(int major, int minor, int patch, int build, @Nullable String buildString) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.buildString = buildString == null ? "" : buildString;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getBuild() {
        return this.build;
    }

    public String toString() {
        String string = String.valueOf(this.major) + "." + this.minor + "." + this.patch;
        if (this.build != 0) {
            string = String.valueOf(string) + "." + this.build;
        }
        if (!this.buildString.isEmpty()) {
            string = this.buildString.startsWith("-") ? String.valueOf(string) + this.buildString : String.valueOf(string) + "." + this.buildString;
        }
        return string;
    }
}

