/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class OWLEntityComparator
implements Comparator<OWLEntity>,
OWLEntityVisitor {
    private final ShortFormProvider shortFormProvider;
    int lastValue;

    public OWLEntityComparator(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
    }

    @Override
    public int compare(@Nullable OWLEntity o1, @Nullable OWLEntity o2) {
        OWLAPIPreconditions.verifyNotNull(o1).accept(this);
        int i1 = this.lastValue;
        OWLAPIPreconditions.verifyNotNull(o2).accept(this);
        int i2 = this.lastValue;
        int delta = i1 - i2;
        if (delta != 0) {
            return delta;
        }
        String s1 = this.getShortForm(OWLAPIPreconditions.verifyNotNull(o1));
        String s2 = this.getShortForm(OWLAPIPreconditions.verifyNotNull(o2));
        return s1.compareTo(s2);
    }

    private String getShortForm(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    @Override
    public void visit(OWLClass cls) {
        this.lastValue = 0;
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.lastValue = 1;
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.lastValue = 2;
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.lastValue = 3;
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.lastValue = 4;
    }

    @Override
    public void visit(OWLDatatype datatype) {
        this.lastValue = 5;
    }
}

