/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.List;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.change.MakeClassesMutuallyDisjoint;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class MakePrimitiveSubClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    public MakePrimitiveSubClassesMutuallyDisjoint(OWLDataFactory dataFactory, OWLClass cls, OWLOntology targetOntology) {
        this(dataFactory, cls, targetOntology, false);
    }

    public MakePrimitiveSubClassesMutuallyDisjoint(OWLDataFactory dataFactory, OWLClass cls, OWLOntology targetOntology, boolean usePairwiseDisjointAxioms) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null"), OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"), usePairwiseDisjointAxioms);
    }

    private void generateChanges(OWLClass cls, OWLOntology o, boolean usePairwiseDisjointAxioms) {
        List<OWLClassExpression> sub = OWLAPIStreamUtils.asList(Searcher.sub(o.subClassAxiomsForSuperClass(cls), OWLClassExpression.class).filter(c -> this.undefinedPrimitive(o, (OWLClassExpression)c)));
        this.addChanges(new MakeClassesMutuallyDisjoint(this.df, sub, usePairwiseDisjointAxioms, o).getChanges());
    }

    protected boolean undefinedPrimitive(OWLOntology o, OWLClassExpression subCls) {
        return !subCls.isAnonymous() && !EntitySearcher.isDefined(subCls.asOWLClass(), o);
    }
}

