/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.coode.owlapi.obo12.parser.OBO12DocumentFormat;
import org.coode.owlapi.obo12.parser.OBO12DocumentFormatFactory;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOFrame;
import org.coode.owlapi.obo12.parser.OBOParser;
import org.coode.owlapi.obo12.parser.OBOTagValuePair;
import org.coode.owlapi.obo12.parser.ParseException;
import org.coode.owlapi.obo12.parser.RawFrameHandler;
import org.coode.owlapi.obo12.parser.Token;
import org.coode.owlapi.obo12.parser.TokenMgrError;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

class OWLOBO12Parser
extends AbstractOWLParser {
    OWLOBO12Parser() {
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource source, OWLOntology ontology, OWLOntologyLoaderConfiguration config) {
        RawFrameHandler rawFrameHandler = new RawFrameHandler();
        OBOConsumer oboConsumer = new OBOConsumer(ontology, config, source.getDocumentIRI());
        try (Reader r = DocumentSources.wrapInputAsReader((OWLOntologyDocumentSource)source, (OWLOntologyLoaderConfiguration)config);){
            OBOParser parser = new OBOParser(r);
            parser.setHandler(rawFrameHandler);
            parser.parse();
            OWLOBO12Parser.parseFrames(rawFrameHandler, oboConsumer);
        }
        catch (ParseException e) {
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyChangeException) {
                throw (OWLOntologyChangeException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyAlreadyExistsException) {
                OWLOntologyAlreadyExistsException ex = (OWLOntologyAlreadyExistsException)e.getCause();
                IRI importedOntologyIRI = (IRI)ex.getOntologyID().getOntologyIRI().get();
                throw new UnloadableImportException((OWLOntologyCreationException)ex, ontology.getOWLOntologyManager().getOWLDataFactory().getOWLImportsDeclaration(importedOntologyIRI));
            }
            Token currentToken = e.currentToken;
            if (currentToken != null) {
                int beginLine = currentToken.beginLine;
                int beginColumn = currentToken.beginColumn;
                throw new OWLParserException((Throwable)((Object)e), beginLine, beginColumn);
            }
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (IOException | TokenMgrError | OWLOntologyInputSourceException e) {
            throw new OWLParserException((Throwable)e);
        }
        OBO12DocumentFormat format = new OBO12DocumentFormat();
        format.setIDSpaceManager(oboConsumer.getIdSpaceManager());
        return format;
    }

    private static void parseFrames(RawFrameHandler rawFrameHandler, OBOConsumer oboConsumer) {
        OWLOBO12Parser.parseHeaderFrame(rawFrameHandler, oboConsumer);
        OWLOBO12Parser.parseFrames(oboConsumer, rawFrameHandler.getTypeDefFrames());
        OWLOBO12Parser.parseFrames(oboConsumer, rawFrameHandler.getNonTypeDefFrames());
    }

    private static void parseHeaderFrame(RawFrameHandler rawFrameHandler, OBOConsumer consumer) {
        consumer.startHeader();
        OWLOBO12Parser.parseFrameTagValuePairs(consumer, rawFrameHandler.getHeaderFrame());
        consumer.endHeader();
    }

    private static void parseFrames(OBOConsumer oboConsumer, List<OBOFrame> frames) {
        for (OBOFrame frame : frames) {
            OWLOBO12Parser.parseFrame(oboConsumer, frame);
        }
    }

    private static void parseFrame(OBOConsumer oboConsumer, OBOFrame frame) {
        oboConsumer.startFrame(frame.getFrameType());
        OWLOBO12Parser.parseFrameTagValuePairs(oboConsumer, frame);
        oboConsumer.endFrame();
    }

    private static void parseFrameTagValuePairs(OBOConsumer oboConsumer, OBOFrame frame) {
        for (OBOTagValuePair tagValuePair : frame.getTagValuePairs()) {
            oboConsumer.handleTagValue(tagValuePair.getTagName(), tagValuePair.getValue(), tagValuePair.getQualifier(), tagValuePair.getComment());
        }
    }

    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OBO12DocumentFormatFactory();
    }
}

