/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxmlparser;

import org.coode.owlapi.owlxmlparser.AbstractClassExpressionElementHandler;
import org.coode.owlapi.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.AbstractOWLObjectPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLXMLParserElementNotFoundException;
import org.coode.owlapi.owlxmlparser.OWLXMLParserException;
import org.coode.owlapi.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class OWLObjectPropertyDomainElementHandler
extends AbstractOWLAxiomElementHandler {
    private OWLClassExpression domain;
    private OWLObjectPropertyExpression property;

    public OWLObjectPropertyDomainElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void handleChild(AbstractClassExpressionElementHandler handler) {
        this.domain = handler.getOWLObject();
    }

    @Override
    public void handleChild(AbstractOWLObjectPropertyElementHandler handler) {
        this.property = handler.getOWLObject();
    }

    @Override
    protected OWLAxiom createAxiom() throws OWLXMLParserException {
        if (this.property == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), this.getColumnNumber(), "Expected object property element");
        }
        if (this.domain == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), this.getColumnNumber(), "Expected class expression element");
        }
        return this.getOWLDataFactory().getOWLObjectPropertyDomainAxiom(this.property, this.domain, this.getAnnotations());
    }
}

