/*
 * Decompiled with CFR 0.152.
 */
package org.coode.xml;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coode.xml.XMLWriterNamespaceManager;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class OWLOntologyXMLNamespaceManager
extends XMLWriterNamespaceManager {
    private OWLOntology ontology;
    private NamespaceUtil namespaceUtil;
    private OWLOntologyFormat ontologyFormat;

    public OWLOntologyXMLNamespaceManager(OWLOntologyManager man, OWLOntology ontology) {
        this(ontology, man.getOntologyFormat(ontology));
    }

    public OWLOntologyXMLNamespaceManager(OWLOntology ontology, OWLOntologyFormat format) {
        super(OWLOntologyXMLNamespaceManager.getDefaultNamespace(ontology, format));
        this.ontology = ontology;
        this.namespaceUtil = new NamespaceUtil();
        this.ontologyFormat = format;
        this.addWellKnownNamespace("skos", Namespaces.SKOS.toString());
        this.addWellKnownNamespace("dc", "http://purl.org/dc/elements/1.1/");
        this.processOntology();
    }

    protected OWLOntology getOntology() {
        return this.ontology;
    }

    private void processOntology() {
        this.namespaceUtil = new NamespaceUtil();
        if (this.ontologyFormat instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat namespaceFormat = (PrefixOWLOntologyFormat)this.ontologyFormat;
            Map<String, String> namespacesByPrefix = namespaceFormat.getPrefixName2PrefixMap();
            for (String prefixName : namespacesByPrefix.keySet()) {
                String xmlnsPrefixName = prefixName.substring(0, prefixName.length() - 1);
                String xmlnsPrefix = namespacesByPrefix.get(prefixName);
                this.namespaceUtil.setPrefix(xmlnsPrefix, xmlnsPrefixName);
            }
        }
        if (this.ontology.getAxiomCount(AxiomType.SWRL_RULE) != 0) {
            this.namespaceUtil.setPrefix(Namespaces.SWRL.toString(), "swrl");
            this.namespaceUtil.setPrefix(Namespaces.SWRLB.toString(), "swrlb");
        }
        Set<OWLEntity> entities = this.getEntitiesThatRequireNamespaces();
        for (OWLEntity ent : entities) {
            this.processEntity(ent);
        }
        Map<String, String> ns2prefixMap = this.namespaceUtil.getNamespace2PrefixMap();
        for (String ns : ns2prefixMap.keySet()) {
            if (Namespaces.OWL11.inNamespace(ns) || Namespaces.OWL11XML.inNamespace(ns)) continue;
            this.setPrefix(ns2prefixMap.get(ns), ns);
        }
    }

    protected Set<OWLEntity> getEntitiesThatRequireNamespaces() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        result.addAll(this.ontology.getClassesInSignature());
        result.addAll(this.ontology.getObjectPropertiesInSignature());
        result.addAll(this.ontology.getDataPropertiesInSignature());
        result.addAll(this.ontology.getIndividualsInSignature());
        result.addAll(this.ontology.getAnnotationPropertiesInSignature());
        return result;
    }

    private void processEntity(OWLNamedObject entity) {
        IRI iri = entity.getIRI();
        this.processIRI(iri);
    }

    private void processIRI(IRI iri) {
        String ns = iri.getNamespace();
        if (ns != null && !ns.equals("") && iri.getFragment() != null) {
            this.namespaceUtil.getPrefix(ns);
        }
    }

    private static String getDefaultNamespace(OWLOntology ontology, OWLOntologyFormat format) {
        PrefixOWLOntologyFormat prefixOWLOntologyFormat;
        String defaultPrefix;
        if (format instanceof PrefixOWLOntologyFormat && (defaultPrefix = (prefixOWLOntologyFormat = (PrefixOWLOntologyFormat)format).getDefaultPrefix()) != null) {
            return defaultPrefix;
        }
        if (ontology.getOntologyID().isAnonymous()) {
            return Namespaces.OWL.toString();
        }
        String base = ontology.getOntologyID().getOntologyIRI().toString();
        if (!base.endsWith("#") && !base.endsWith("/")) {
            base = base + "#";
        }
        return base;
    }

    @Override
    public String getQName(String name) {
        String ns = XMLUtils.getNCNamePrefix(name);
        String fragment = XMLUtils.getNCNameSuffix(name);
        if (ns.equals(this.getDefaultNamespace())) {
            return fragment;
        }
        if (name.startsWith("xmlns") || name.startsWith("xml:")) {
            return name;
        }
        if (ns.equals("") || fragment == null || fragment.isEmpty()) {
            return name;
        }
        String prefix = this.getPrefixForNamespace(ns);
        if (prefix != null) {
            if (prefix.length() > 0) {
                return prefix + ":" + fragment;
            }
            return fragment;
        }
        return null;
    }
}

