/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.io.RDFParserMetaData;
import org.semanticweb.owlapi.io.RDFResourceParseError;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public abstract class RDFOntologyFormat
extends PrefixOWLOntologyFormat {
    private static final long serialVersionUID = 30406L;
    private boolean addMissingTypes = true;
    private final Set<RDFResourceParseError> errors = new HashSet<RDFResourceParseError>();

    public boolean isAddMissingTypes() {
        return this.addMissingTypes;
    }

    public static boolean isMissingType(OWLEntity entity, OWLOntology ontology) {
        if (entity.isBuiltIn()) {
            return false;
        }
        if (!ontology.containsEntityInSignature(entity)) {
            return false;
        }
        if (ontology.isDeclared(entity, true)) {
            return false;
        }
        Set<OWLOntology> transitiveImports = ontology.getImports();
        if (!transitiveImports.contains(ontology)) {
            for (OWLOntology importedOntology : transitiveImports) {
                if (!importedOntology.containsEntityInSignature(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public void setAddMissingTypes(boolean addMissingTypes) {
        this.addMissingTypes = addMissingTypes;
    }

    @Override
    public RDFParserMetaData getOntologyLoaderMetaData() {
        return (RDFParserMetaData)super.getOntologyLoaderMetaData();
    }

    public void addError(RDFResourceParseError error) {
        this.errors.add(error);
    }
}

