/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.semanticweb.owlapi.model.IRI;

public class NodeID
implements Comparable<NodeID>,
Serializable {
    private static final long serialVersionUID = 30406L;
    private static final AtomicLong counter = new AtomicLong();
    private static final String NODE_ID_PREFIX = "genid";
    private static final String SHARED_NODE_ID_PREFIX = "genid-nodeid-";
    private static final String PREFIX = "_:";
    private final String id;

    public static String nodeString(int id) {
        return NODE_ID_PREFIX + Integer.toString(id);
    }

    public static String getIRIFromNodeID(String nodeID) {
        return "_:genid-nodeid-" + nodeID.replace(NODE_ID_PREFIX, "");
    }

    public static String nextAnonymousIRI() {
        return "_:genid" + counter.incrementAndGet();
    }

    public static boolean isAnonymousNodeIRI(String uri) {
        return uri != null && (uri.startsWith(PREFIX) || uri.indexOf(NODE_ID_PREFIX) != -1);
    }

    public static boolean isAnonymousNodeIRI(IRI iri) {
        return iri.getNamespace() != null && iri.getNamespace().contains(NODE_ID_PREFIX);
    }

    public static boolean isAnonymousNodeID(String iri) {
        return iri != null && iri.indexOf(SHARED_NODE_ID_PREFIX) > -1;
    }

    public static NodeID getNodeID(String id) {
        String _id = id == null || id.length() == 0 ? "_:genid" + Long.toString(counter.incrementAndGet()) : id;
        return new NodeID(_id);
    }

    private NodeID(String id) {
        this.id = id.startsWith(PREFIX) ? id : PREFIX + id;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int compareTo(NodeID o) {
        return this.id.compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeID)) {
            return false;
        }
        NodeID other = (NodeID)obj;
        return this.id.equals(other.getID());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getID() {
        return this.id;
    }
}

