/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public abstract class DefaultNode<E extends OWLObject>
implements Node<E> {
    private static final OWLDataFactory DF = new OWLDataFactoryImpl(false, false);
    protected static final OWLClass TOP_CLASS = DF.getOWLThing();
    protected static final OWLClassNode TOP_NODE = new OWLClassNode(TOP_CLASS);
    protected static final OWLClass BOTTOM_CLASS = DF.getOWLNothing();
    protected static final OWLClassNode BOTTOM_NODE = new OWLClassNode(BOTTOM_CLASS);
    protected static final OWLDataProperty TOP_DATA_PROPERTY = DF.getOWLTopDataProperty();
    protected static final OWLDataPropertyNode TOP_DATA_NODE = new OWLDataPropertyNode(TOP_DATA_PROPERTY);
    protected static final OWLDataProperty BOTTOM_DATA_PROPERTY = DF.getOWLBottomDataProperty();
    protected static final OWLDataPropertyNode BOTTOM_DATA_NODE = new OWLDataPropertyNode(BOTTOM_DATA_PROPERTY);
    protected static final OWLDatatype TOP_DATATYPE = DF.getTopDatatype();
    protected static final OWLObjectProperty TOP_OBJECT_PROPERTY = DF.getOWLTopObjectProperty();
    protected static final OWLObjectPropertyNode TOP_OBJECT_NODE = new OWLObjectPropertyNode(TOP_OBJECT_PROPERTY);
    protected static final OWLObjectProperty BOTTOM_OBJECT_PROPERTY = DF.getOWLBottomObjectProperty();
    protected static final OWLObjectPropertyNode BOTTOM_OBJECT_NODE = new OWLObjectPropertyNode(BOTTOM_OBJECT_PROPERTY);
    private final Set<E> entities = new HashSet(4);

    public DefaultNode(E entity) {
        this.entities.add(entity);
    }

    public DefaultNode(Set<E> entities) {
        this.entities.addAll(entities);
    }

    protected DefaultNode() {
    }

    protected abstract E getTopEntity();

    protected abstract E getBottomEntity();

    public void add(E entity) {
        this.entities.add(entity);
    }

    @Override
    public boolean isTopNode() {
        return this.entities.contains(this.getTopEntity());
    }

    @Override
    public boolean isBottomNode() {
        return this.entities.contains(this.getBottomEntity());
    }

    @Override
    public Set<E> getEntities() {
        return this.entities;
    }

    @Override
    public int getSize() {
        return this.entities.size();
    }

    @Override
    public boolean contains(E entity) {
        return this.entities.contains(entity);
    }

    @Override
    public Set<E> getEntitiesMinus(E E) {
        HashSet<E> result = new HashSet<E>(this.entities);
        result.remove(E);
        return result;
    }

    @Override
    public Set<E> getEntitiesMinusTop() {
        return this.getEntitiesMinus(this.getTopEntity());
    }

    @Override
    public Set<E> getEntitiesMinusBottom() {
        return this.getEntitiesMinus(this.getBottomEntity());
    }

    @Override
    public boolean isSingleton() {
        return this.entities.size() == 1;
    }

    @Override
    public E getRepresentativeElement() {
        if (!this.entities.isEmpty()) {
            return (E)((OWLObject)this.entities.iterator().next());
        }
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node( ");
        for (OWLObject entity : this.entities) {
            sb.append(entity);
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return this.entities.equals(other.getEntities());
    }

    public int hashCode() {
        return this.entities.hashCode();
    }
}

