/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.net.URI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum SWRLBuiltInsVocabulary implements SWRLPredicate
{
    EQUAL("equal", 2),
    NOT_EQUAL("notEqual", 2),
    LESS_THAN("lessThan", 2),
    LESS_THAN_OR_EQUAL("lessThanOrEqual", 2),
    GREATER_THAN("greaterThan", 2),
    GREATER_THAN_OR_EQUAL("greaterThanOrEqual", 2),
    ADD("add", -1),
    SUBTRACT("subtract", 3),
    MULTIPLY("multiply", -1),
    DIVIDE("divide", 3),
    INTEGER_DIVIDE("integerDivide", 3),
    MOD("mod", 3),
    POW("pow", 3),
    UNARY_MINUS("unaryMinus", 2),
    UNARY_PLUS("unaryPlus", 2),
    ABS("abs", 2),
    CEILING("ceiling", 2),
    FLOOR("floor", 2),
    ROUND("round", 2),
    ROUND_HALF_TO_EVEN("roundHalfToEven", 2, 3),
    SIN("sin", 2),
    COS("cos", 2),
    TAN("tan", 2),
    BOOLEAN_NOT("booleanNot", 2),
    STRING_EQUALS_IGNORE_CASE("stringEqualIgnoreCase", 2),
    STRING_CONCAT("stringConcat", -1),
    SUBSTRING("substring", 3),
    STRING_LENGTH("stringLength", 2),
    NORMALIZE_SPACE("normalizeSpace", 2),
    UPPER_CASE("upperCase", 2),
    LOWER_CASE("lowerCase", 2),
    TRANSLATE("translate", 4),
    CONTAINS("contains", 2),
    CONTAINS_IGNORE_CASE("containsIgnoreCase", 2),
    STARTS_WITH("startsWith", 2),
    ENDS_WITH("endsWith", 2),
    SUBSTRING_BEFORE("substringBefore", 3),
    SUBSTRING_AFTER("substringAfter", 3),
    MATCHES("matchesLax", 2),
    REPLACE("replace", 4),
    TOKENIZE("tokenize", 3),
    YEAR_MONTH_DURATION("yearMonthDuration", 5),
    DAY_TIME_DURATION("dayTimeDuration", 5),
    DATE_TIME("dateTime", 5),
    DATE("date", 5),
    TIME("time", 5),
    SUBTRACT_DATES("subtractDates", 3),
    SUBTRACT_TIMES("subtractTimes", 3),
    RESOLVE_URI("resolveURI", 3),
    ANY_URI("anyURI", 7),
    ADD_YEAR_MONTH_DURATIONS("addYearMonthDurations", -1),
    SUBTRACT_YEAR_MONTH_DURATIONS("subtractYearMonthDurations", 3),
    MULTIPLY_YEAR_MONTH_DURATIONS("multiplyYearMonthDurations", 3),
    DIVIDE_YEAR_MONTH_DURATIONS("divideYearMonthDurations", 3),
    ADD_DAY_TIME_DURATIONS("addDayTimeDurations", -1),
    SUBTRACT_DAY_TIME_DURATIONS("subtractDayTimeDurations", 3),
    MULTIPLY_DAY_TIME_DURATIONS("multiplyDayTimeDurations", 3),
    DIVIDE_DAY_TIME_DURATIONS("divideDayTimeDurations", 3),
    ADD_DAY_TIME_DURATION_TO_DATE_TIME("addDayTimeDurationToDateTime", 3),
    SUBTRACT_YEAR_MONTH_DURATION_FROM_DATE_TIME("subtractYearMonthDurationFromDateTime", 3),
    SUBTRACT_DAY_TIME_DURATION_FROM_DATE_TIME("subtractDayTimeDurationFromDateTime", 3),
    ADD_YEAR_MONTH_DURATION_TO_DATE("addYearMonthDurationToDate", 3),
    ADD_DAY_TIME_DURATION_TO_DATE("addDayTimeDurationToDate", 3),
    SUBTRACT_YEAR_MONTH_DURATION_FROM_DATE("subtractYearMonthDurationFromDate", 3),
    SUBTRACT_DAY_TIME_DURATION_FROM_DATE("subtractDayTimeDurationFromDate", 3),
    ADD_DAY_TIME_DURATION_FROM_TIME("addDayTimeDurationToTime", 3),
    SUBTRACT_DAY_TIME_DURATION_FROM_TIME("subtractDayTimeDurationFromTime", 3),
    SUBTRACT_DATE_TIMES_YIELDING_YEAR_MONTH_DURATION("subtractDateTimesYieldingYearMonthDuration", 3),
    SUBTRACT_DATE_TIMES_YIELDING_DAY_TIME_DURATION("subtractDateTimesYieldingDayTimeDuration", 3);

    private final String shortName;
    private final IRI iri;
    private final int minArity;
    private final int maxArity;

    private SWRLBuiltInsVocabulary(String name, int arity) {
        this(name, arity, arity);
    }

    private SWRLBuiltInsVocabulary(String name, int minArity, int maxArity) {
        this.shortName = name;
        this.iri = IRI.create(Namespaces.SWRLB.toString(), name);
        this.minArity = minArity;
        this.maxArity = maxArity;
    }

    public String getShortName() {
        return this.shortName;
    }

    public IRI getIRI() {
        return this.iri;
    }

    @Deprecated
    public URI getURI() {
        return this.iri.toURI();
    }

    public int getMinArity() {
        return this.minArity;
    }

    public int getMaxArity() {
        return this.maxArity;
    }

    @Deprecated
    public int getArity() {
        return this.minArity;
    }

    public static SWRLBuiltInsVocabulary getBuiltIn(IRI iri) {
        for (SWRLBuiltInsVocabulary v : SWRLBuiltInsVocabulary.values()) {
            if (!v.iri.equals(iri)) continue;
            return v;
        }
        return null;
    }

    public static SWRLBuiltInsVocabulary getBuiltIn(URI uri) {
        for (SWRLBuiltInsVocabulary v : SWRLBuiltInsVocabulary.values()) {
            if (!v.getURI().equals(uri)) continue;
            return v;
        }
        return null;
    }
}

