/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.NNF;
import uk.ac.manchester.cs.owl.owlapi.CollectionContainer;
import uk.ac.manchester.cs.owl.owlapi.CollectionContainerVisitor;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public abstract class OWLAxiomImpl
extends OWLObjectImpl
implements OWLAxiom,
CollectionContainer<OWLAnnotation> {
    private static final long serialVersionUID = 30406L;
    private OWLAxiom nnf;
    private final List<OWLAnnotation> annotations;

    public OWLAxiomImpl(Collection<? extends OWLAnnotation> annotations) {
        if (!annotations.isEmpty()) {
            this.annotations = new ArrayList<OWLAnnotation>(annotations);
            Collections.sort(this.annotations);
        } else {
            this.annotations = Collections.emptyList();
        }
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    @Override
    public Set<OWLAnnotation> getAnnotations() {
        if (this.annotations.isEmpty()) {
            return Collections.emptySet();
        }
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.annotations);
    }

    @Override
    public void accept(CollectionContainerVisitor<OWLAnnotation> t) {
        int size = this.annotations.size();
        for (int i = 0; i < size; ++i) {
            t.visitItem(this.annotations.get(i));
        }
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty annotationProperty) {
        if (this.annotations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<OWLAnnotation> result = new HashSet<OWLAnnotation>();
        for (OWLAnnotation anno : this.annotations) {
            if (!anno.getProperty().equals(annotationProperty)) continue;
            result.add(anno);
        }
        return result;
    }

    @Override
    public boolean equalsIgnoreAnnotations(OWLAxiom axiom) {
        return this.getAxiomWithoutAnnotations().equals(axiom.getAxiomWithoutAnnotations());
    }

    @Override
    public boolean isOfType(AxiomType<?> ... axiomTypes) {
        for (AxiomType<?> type : axiomTypes) {
            if (!this.getAxiomType().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOfType(Set<AxiomType<?>> types) {
        return types.contains(this.getAxiomType());
    }

    protected Set<OWLAnnotation> mergeAnnos(Set<OWLAnnotation> annos) {
        HashSet<OWLAnnotation> merged = new HashSet<OWLAnnotation>(annos);
        merged.addAll(this.annotations);
        return merged;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLAxiom)) {
            return false;
        }
        OWLAxiom other = (OWLAxiom)obj;
        return this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public OWLAxiom getNNF() {
        if (this.nnf == null) {
            NNF con = new NNF(new OWLDataFactoryImpl());
            this.nnf = this.accept(con);
        }
        return this.nnf;
    }
}

