/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImpl;

public class OWLHasKeyAxiomImpl
extends OWLLogicalAxiomImpl
implements OWLHasKeyAxiom {
    private static final long serialVersionUID = 30406L;
    private final OWLClassExpression expression;
    private final Set<OWLPropertyExpression<?, ?>> propertyExpressions;

    public OWLHasKeyAxiomImpl(OWLClassExpression expression, Set<? extends OWLPropertyExpression<?, ?>> propertyExpressions, Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.expression = expression;
        this.propertyExpressions = new TreeSet(propertyExpressions);
    }

    @Override
    public OWLHasKeyAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLHasKeyAxiomImpl(this.getClassExpression(), this.getPropertyExpressions(), NO_ANNOTATIONS);
    }

    @Override
    public OWLHasKeyAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLHasKeyAxiomImpl(this.getClassExpression(), this.getPropertyExpressions(), this.mergeAnnos(annotations));
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.HAS_KEY;
    }

    @Override
    public boolean isLogicalAxiom() {
        return true;
    }

    @Override
    public OWLClassExpression getClassExpression() {
        return this.expression;
    }

    @Override
    public Set<OWLPropertyExpression<?, ?>> getPropertyExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.propertyExpressions);
    }

    @Override
    public Set<OWLDataPropertyExpression> getDataPropertyExpressions() {
        TreeSet<OWLDataPropertyExpression> props = new TreeSet<OWLDataPropertyExpression>();
        for (OWLPropertyExpression<?, ?> prop : this.propertyExpressions) {
            if (!prop.isDataPropertyExpression()) continue;
            props.add((OWLDataPropertyExpression)prop);
        }
        return props;
    }

    @Override
    public Set<OWLObjectPropertyExpression> getObjectPropertyExpressions() {
        TreeSet<OWLObjectPropertyExpression> props = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLPropertyExpression<?, ?> prop : this.propertyExpressions) {
            if (!prop.isObjectPropertyExpression()) continue;
            props.add((OWLObjectPropertyExpression)prop);
        }
        return props;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLHasKeyAxiom other = (OWLHasKeyAxiom)object;
        int diff = this.expression.compareTo(other.getClassExpression());
        if (diff != 0) {
            return diff;
        }
        return OWLHasKeyAxiomImpl.compareSets(this.propertyExpressions, other.getPropertyExpressions());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLHasKeyAxiom)) {
                return false;
            }
            OWLHasKeyAxiom other = (OWLHasKeyAxiom)obj;
            return this.expression.equals(other.getClassExpression()) && this.propertyExpressions.equals(other.getPropertyExpressions());
        }
        return false;
    }
}

