/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.OWLOntologyWalker;

public class OWLOntologyWalkerVisitor
extends OWLObjectVisitorAdapter {
    @Nonnull
    private final OWLOntologyWalker walker;

    public OWLOntologyWalkerVisitor(@Nonnull OWLOntologyWalker walker) {
        this.walker = OWLAPIPreconditions.checkNotNull(walker, "walker cannot be null");
    }

    @Nonnull
    public OWLAxiom getCurrentAxiom() {
        OWLAxiom axiom = this.walker.getAxiom();
        if (axiom == null) {
            throw new OWLRuntimeException("No current axiom; is the walker being used outside of an ontology visit?");
        }
        return axiom;
    }

    @Nonnull
    public OWLOntology getCurrentOntology() {
        OWLOntology ontology = this.walker.getOntology();
        if (ontology == null) {
            throw new OWLRuntimeException("No current ontology; is the walker being used outside of an ontology visit?");
        }
        return ontology;
    }

    @Nullable
    public OWLAnnotation getCurrentAnnotation() {
        return this.walker.getAnnotation();
    }
}

