/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.ByName;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OWLOntologyLoaderConfiguration
implements Serializable {
    private static final long serialVersionUID = 40000L;
    private EnumMap<ConfigurationOptions, Object> overrides = new EnumMap(ConfigurationOptions.class);
    @Nonnull
    private final Set<IRI> ignoredImports = new HashSet<IRI>();

    public OWLOntologyLoaderConfiguration addIgnoredImport(IRI ontologyDocumentIRI) {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.add(ontologyDocumentIRI);
        return configuration;
    }

    public OWLOntologyLoaderConfiguration clearIgnoredImports() {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.clear();
        return configuration;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration removeIgnoredImport(IRI ontologyDocumentIRI) {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.remove(ontologyDocumentIRI);
        return configuration;
    }

    @Nonnull
    private OWLOntologyLoaderConfiguration copyConfiguration() {
        OWLOntologyLoaderConfiguration copy = new OWLOntologyLoaderConfiguration();
        copy.overrides.putAll(this.overrides);
        copy.ignoredImports.clear();
        copy.ignoredImports.addAll(this.ignoredImports);
        return copy;
    }

    public OWLOntologyLoaderConfiguration setPriorityCollectionSorting(PriorityCollectionSorting sorting) {
        if (sorting.equals(this.getPriorityCollectionSorting())) {
            return this;
        }
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.overrides.put(ConfigurationOptions.PRIORITY_COLLECTION_SORTING, (Object)sorting);
        return configuration;
    }

    public PriorityCollectionSorting getPriorityCollectionSorting() {
        return ConfigurationOptions.PRIORITY_COLLECTION_SORTING.getValue(PriorityCollectionSorting.class, this.overrides);
    }

    public int getConnectionTimeout() {
        return ConfigurationOptions.CONNECTION_TIMEOUT.getValue(Integer.class, this.overrides);
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return ConfigurationOptions.MISSING_IMPORT_HANDLING_STRATEGY.getValue(MissingImportHandlingStrategy.class, this.overrides);
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return ConfigurationOptions.MISSING_ONTOLOGY_HEADER_STRATEGY.getValue(MissingOntologyHeaderStrategy.class, this.overrides);
    }

    public int getRetriesToAttempt() {
        return ConfigurationOptions.RETRIES_TO_ATTEMPT.getValue(Integer.class, this.overrides);
    }

    public boolean isAcceptingHTTPCompression() {
        return ConfigurationOptions.ACCEPT_HTTP_COMPRESSION.getValue(Boolean.class, this.overrides);
    }

    public boolean isFollowRedirects() {
        return ConfigurationOptions.FOLLOW_REDIRECTS.getValue(Boolean.class, this.overrides);
    }

    public boolean isIgnoredImport(IRI iri) {
        return Namespaces.isDefaultIgnoredImport(iri) || this.ignoredImports.contains(iri);
    }

    public boolean isLoadAnnotationAxioms() {
        return ConfigurationOptions.LOAD_ANNOTATIONS.getValue(Boolean.class, this.overrides);
    }

    public boolean isReportStackTrace() {
        return ConfigurationOptions.REPORT_STACK_TRACES.getValue(Boolean.class, this.overrides);
    }

    public boolean isStrict() {
        return ConfigurationOptions.PARSE_WITH_STRICT_CONFIGURATION.getValue(Boolean.class, this.overrides);
    }

    public boolean isTreatDublinCoreAsBuiltIn() {
        return ConfigurationOptions.TREAT_DUBLINCORE_AS_BUILTIN.getValue(Boolean.class, this.overrides);
    }

    public String getBannedParsers() {
        return ConfigurationOptions.BANNED_PARSERS.getValue(String.class, this.overrides);
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setAcceptingHTTPCompression(boolean b) {
        if (this.isAcceptingHTTPCompression() == b) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.ACCEPT_HTTP_COMPRESSION, (Object)b);
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setConnectionTimeout(int l) {
        if (this.getConnectionTimeout() == l) {
            return this;
        }
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.overrides.put(ConfigurationOptions.CONNECTION_TIMEOUT, (Object)l);
        return configuration;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setFollowRedirects(boolean value) {
        if (value == this.isFollowRedirects()) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.FOLLOW_REDIRECTS, (Object)value);
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setLoadAnnotationAxioms(boolean b) {
        if (this.isLoadAnnotationAxioms() == b) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.LOAD_ANNOTATIONS, (Object)b);
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setMissingImportHandlingStrategy(@Nonnull MissingImportHandlingStrategy missingImportHandlingStrategy) {
        if (this.getMissingImportHandlingStrategy() == missingImportHandlingStrategy) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.MISSING_IMPORT_HANDLING_STRATEGY, (Object)missingImportHandlingStrategy);
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setMissingOntologyHeaderStrategy(@Nonnull MissingOntologyHeaderStrategy missingOntologyHeaderStrategy) {
        if (this.getMissingOntologyHeaderStrategy() == missingOntologyHeaderStrategy) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.MISSING_ONTOLOGY_HEADER_STRATEGY, (Object)missingOntologyHeaderStrategy);
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setReportStackTraces(boolean b) {
        if (this.isReportStackTrace() == b) {
            return this;
        }
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.overrides.put(ConfigurationOptions.REPORT_STACK_TRACES, (Object)b);
        return configuration;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setRetriesToAttempt(int retries) {
        if (this.getRetriesToAttempt() == retries) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.RETRIES_TO_ATTEMPT, (Object)retries);
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setStrict(boolean strict) {
        if (this.isStrict() == strict) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.PARSE_WITH_STRICT_CONFIGURATION, (Object)strict);
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setTreatDublinCoreAsBuiltIn(boolean value) {
        if (this.isTreatDublinCoreAsBuiltIn() == value) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.overrides.put(ConfigurationOptions.TREAT_DUBLINCORE_AS_BUILTIN, (Object)value);
        return copy;
    }

    public OWLOntologyLoaderConfiguration setBannedParsers(String ban) {
        if (this.getBannedParsers().equals(ban)) {
            return this;
        }
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.overrides.put(ConfigurationOptions.BANNED_PARSERS, (Object)ban);
        return configuration;
    }

    public static enum MissingOntologyHeaderStrategy implements ByName<MissingOntologyHeaderStrategy>
    {
        INCLUDE_GRAPH,
        IMPORT_GRAPH;


        @Override
        public MissingOntologyHeaderStrategy byName(CharSequence name) {
            return MissingOntologyHeaderStrategy.valueOf(name.toString());
        }
    }
}

