/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.annotations.HasPriority;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SAXParsers;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@HasPriority(value=1.0)
public class AutoIRIMapper
extends DefaultHandler
implements OWLOntologyIRIMapper,
Serializable {
    private static final long serialVersionUID = 40000L;
    private final Set<String> fileExtensions = new HashSet<String>();
    private boolean mapped;
    private final boolean recursive;
    private final Map<String, OntologyRootElementHandler> handlerMap = new HashMap<String, OntologyRootElementHandler>();
    private final Map<IRI, IRI> ontologyIRI2PhysicalURIMap = new HashMap<IRI, IRI>();
    private final Map<String, IRI> oboFileMap = new HashMap<String, IRI>();
    private final String directoryPath;
    private transient File currentFile;
    static final Pattern pattern = Pattern.compile("Ontology\\(<([^>]+)>");

    public AutoIRIMapper(@Nonnull File rootDirectory, boolean recursive) {
        this.directoryPath = OWLAPIPreconditions.checkNotNull(rootDirectory, "rootDirectory cannot be null").getAbsolutePath();
        this.recursive = recursive;
        this.fileExtensions.add("owl");
        this.fileExtensions.add("xml");
        this.fileExtensions.add("rdf");
        this.fileExtensions.add("omn");
        this.fileExtensions.add("ofn");
        this.mapped = false;
        this.handlerMap.put((Object)((Object)Namespaces.RDF) + "RDF", new RDFXMLOntologyRootElementHandler());
        this.handlerMap.put(OWLXMLVocabulary.ONTOLOGY.toString(), new OWLXMLOntologyRootElementHandler());
    }

    protected File getDirectory() {
        return new File(this.directoryPath);
    }

    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(Set<String> extensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(extensions);
    }

    public Set<IRI> getOntologyIRIs() {
        if (!this.mapped) {
            this.mapFiles();
        }
        return new HashSet<IRI>(this.ontologyIRI2PhysicalURIMap.keySet());
    }

    public void update() {
        this.mapFiles();
    }

    @Override
    public IRI getDocumentIRI(IRI ontologyIRI) {
        int lastSepIndex;
        String name;
        IRI documentIRI;
        String path;
        if (!this.mapped) {
            this.mapFiles();
        }
        if (ontologyIRI.toString().endsWith(".obo") && (path = ontologyIRI.toURI().getPath()) != null && (documentIRI = this.oboFileMap.get(name = path.substring((lastSepIndex = path.lastIndexOf(47)) + 1, path.length()))) != null) {
            return documentIRI;
        }
        return this.ontologyIRI2PhysicalURIMap.get(ontologyIRI);
    }

    private void mapFiles() {
        this.mapped = true;
        this.ontologyIRI2PhysicalURIMap.clear();
        this.processFile(this.getDirectory());
    }

    private void processFile(File f) {
        if (f.isHidden()) {
            return;
        }
        File[] files = f.listFiles();
        if (files != null) {
            block0: for (File file : files) {
                if (file.isDirectory() && this.recursive) {
                    this.processFile(file);
                    continue;
                }
                if (file.getName().endsWith(".obo")) {
                    this.oboFileMap.put(file.getName(), IRI.create(file));
                    continue;
                }
                if (file.getName().endsWith(".ofn")) {
                    this.parseFSSFile(file);
                    continue;
                }
                if (file.getName().endsWith(".omn")) {
                    this.parseManchesterSyntaxFile(file);
                    continue;
                }
                for (String ext : this.fileExtensions) {
                    if (!file.getName().endsWith(ext)) continue;
                    this.parseFile(file);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFSSFile(@Nonnull File file) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = "";
            IRI ontologyIRI = null;
            Matcher m = pattern.matcher(line);
            int n = 0;
            while ((line = br.readLine()) != null && n++ < 100) {
                m.reset(line);
                if (!m.matches()) continue;
                ontologyIRI = IRI.create(m.group(1));
                this.addMapping(ontologyIRI, file);
                break;
            }
        }
        catch (IOException iOException) {
            Closeables.closeQuietly(br);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(br);
            throw throwable;
        }
        Closeables.closeQuietly((Reader)br);
    }

    private void parseFile(File file) {
        try (FileInputStream in = new FileInputStream(file);
             BufferedInputStream delegate = new BufferedInputStream(in);
             InputStream is = OWLOntologyDocumentSourceBase.wrap(delegate);){
            this.currentFile = file;
            SAXParsers.initParserWithOWLAPIStandards(null).parse(is, (DefaultHandler)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseManchesterSyntaxFile(@Nonnull File file) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = br.readLine();
            IRI ontologyIRI = null;
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, " \r\n", false);
                line = br.readLine();
                while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    if (!tok.startsWith("<") || !tok.endsWith(">")) continue;
                    ontologyIRI = AutoIRIMapper.unquote(tok);
                    this.addMapping(ontologyIRI, file);
                    break;
                }
                if (ontologyIRI == null) continue;
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Nonnull
    static IRI unquote(String tok) {
        return IRI.create(tok.substring(1, tok.length() - 1));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        OntologyRootElementHandler handler = this.handlerMap.get(uri + localName);
        if (handler != null) {
            IRI ontologyIRI = handler.handle(attributes);
            if (ontologyIRI != null && this.currentFile != null) {
                this.addMapping(ontologyIRI, OWLAPIPreconditions.verifyNotNull(this.currentFile));
            }
            throw new SAXException();
        }
    }

    protected void addMapping(@Nonnull IRI ontologyIRI, @Nonnull File file) {
        this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(file));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoURIMapper: (");
        sb.append(this.ontologyIRI2PhysicalURIMap.size());
        sb.append(" ontologies)\n");
        for (IRI iri : this.ontologyIRI2PhysicalURIMap.keySet()) {
            sb.append("    ");
            sb.append(iri.toQuotedString());
            sb.append(" -> ");
            sb.append(this.ontologyIRI2PhysicalURIMap.get(iri));
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class OWLXMLOntologyRootElementHandler
    implements OntologyRootElementHandler,
    Serializable {
        private static final long serialVersionUID = 40000L;

        OWLXMLOntologyRootElementHandler() {
        }

        @Override
        public IRI handle(Attributes attributes) {
            String ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
            if (ontURI == null) {
                ontURI = attributes.getValue("ontologyIRI");
            }
            if (ontURI == null) {
                return null;
            }
            return IRI.create(ontURI);
        }
    }

    private static class RDFXMLOntologyRootElementHandler
    implements OntologyRootElementHandler,
    Serializable {
        private static final long serialVersionUID = 40000L;

        RDFXMLOntologyRootElementHandler() {
        }

        @Override
        @Nullable
        public IRI handle(Attributes attributes) {
            String baseValue = attributes.getValue(Namespaces.XML.toString(), "base");
            if (baseValue == null) {
                return null;
            }
            return IRI.create(baseValue);
        }
    }

    private static interface OntologyRootElementHandler
    extends Serializable {
        public IRI handle(Attributes var1);
    }
}

