/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLOntologyDocumentSourceBase
implements OWLOntologyDocumentSource {
    protected final AtomicBoolean failedOnStreams = new AtomicBoolean(false);
    protected final AtomicBoolean failedOnIRI = new AtomicBoolean(false);
    private final IRI documentIRI;
    private final Optional<OWLDocumentFormat> format;
    private final Optional<String> mimeType;

    public OWLOntologyDocumentSourceBase(IRI iri, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        this.format = OWLAPIPreconditions.optional(format);
        this.mimeType = OWLAPIPreconditions.optional(mime);
        this.documentIRI = OWLAPIPreconditions.checkNotNull(iri, "document iri cannot be null");
    }

    public OWLOntologyDocumentSourceBase(String iriPrefix, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        this(IRI.getNextDocumentIRI(iriPrefix), format, mime);
    }

    @Override
    public final IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public boolean hasAlredyFailedOnStreams() {
        return this.failedOnStreams.get();
    }

    @Override
    public boolean hasAlredyFailedOnIRIResolution() {
        return this.failedOnIRI.get();
    }

    @Override
    public void setIRIResolutionFailed(boolean value) {
        this.failedOnIRI.set(value);
    }

    @Override
    public Optional<OWLDocumentFormat> getFormat() {
        return this.format;
    }

    @Override
    public Optional<String> getMIMEType() {
        return this.mimeType;
    }
}

