/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFGraph
implements Serializable {
    private static final Set<IRI> skippedPredicates = Collections.singleton(OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
    private final Map<RDFResource, Set<RDFTriple>> triplesBySubject = CollectionFactory.createMap();
    private final Set<RDFResourceBlankNode> rootAnonymousNodes = CollectionFactory.createLinkedSet();
    private final Set<RDFTriple> triples = CollectionFactory.createLinkedSet();
    private final Map<RDFNode, RDFNode> remappedNodes = CollectionFactory.createMap();
    @Nullable
    private RDFResource ontology;

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public void addTriple(RDFTriple triple) {
        OWLAPIPreconditions.checkNotNull(triple, "triple cannot be null");
        this.rootAnonymousNodes.clear();
        this.triples.add(triple);
        Set<RDFTriple> tripleSet = this.triplesBySubject.get(triple.getSubject());
        if (tripleSet == null) {
            tripleSet = new LinkedHashSet<RDFTriple>();
            this.triplesBySubject.put(triple.getSubject(), tripleSet);
        }
        tripleSet.add(triple);
    }

    public Collection<RDFTriple> getTriplesForSubject(RDFNode subject) {
        Set<RDFTriple> set = this.triplesBySubject.get(subject);
        if (set == null) {
            RDFNode rdfNode = this.remappedNodes.get(subject);
            if (rdfNode == null) {
                return Collections.emptyList();
            }
            return this.getTriplesForSubject(rdfNode);
        }
        return set;
    }

    public void forceIdOutput() {
        Map anonIndividualsInMultipleTriples = CollectionFactory.createMap();
        for (RDFTriple rDFTriple : this.triples) {
            if (rDFTriple.getObject().isAnonymous() && rDFTriple.getObject().isIndividual()) {
                ArrayList<RDFResourceBlankNode> list = (ArrayList<RDFResourceBlankNode>)anonIndividualsInMultipleTriples.get(rDFTriple.getObject());
                if (list == null) {
                    list = new ArrayList<RDFResourceBlankNode>(2);
                    anonIndividualsInMultipleTriples.put((RDFResourceBlankNode)rDFTriple.getObject(), list);
                }
                list.add((RDFResourceBlankNode)rDFTriple.getObject());
            }
            if (!skippedPredicates.contains(rDFTriple.getPredicate().getIRI()) || !rDFTriple.getObject().isAnonymous()) continue;
            ((RDFResourceBlankNode)rDFTriple.getObject()).setIdRequired(true);
        }
        for (Map.Entry entry : anonIndividualsInMultipleTriples.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            ((List)entry.getValue()).forEach(o -> o.setIdRequired(true));
        }
    }

    public Set<RDFResourceBlankNode> getRootAnonymousNodes() {
        if (this.rootAnonymousNodes.isEmpty()) {
            this.rebuildAnonRoots();
        }
        return this.rootAnonymousNodes;
    }

    private void rebuildAnonRoots() {
        this.rootAnonymousNodes.clear();
        for (RDFTriple triple : this.triples) {
            if (!triple.getSubject().isAnonymous()) continue;
            this.rootAnonymousNodes.add((RDFResourceBlankNode)triple.getSubject());
        }
        for (RDFTriple triple : this.triples) {
            if (!triple.getObject().isAnonymous() || triple.isSubjectSameAsObject()) continue;
            this.rootAnonymousNodes.remove(triple.getObject());
        }
    }

    public void dumpTriples(Writer w) throws IOException {
        OWLAPIPreconditions.checkNotNull(w, "w cannot be null");
        for (Set<RDFTriple> set : this.triplesBySubject.values()) {
            for (RDFTriple triple : set) {
                w.write(triple.toString());
                w.write("\n");
            }
        }
        w.flush();
    }

    public Set<RDFTriple> getAllTriples() {
        return Collections.unmodifiableSet(this.triples);
    }

    public String toString() {
        return this.triples.stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "triples            : ", "\n")) + this.triplesBySubject.entrySet().stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "triplesBySubject   : ", "\n")) + this.rootAnonymousNodes.stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "rootAnonymousNodes : ", "\n")) + this.remappedNodes.entrySet().stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "remappedNodes      : ", ""));
    }

    public List<RDFResource> getSubjectsForObject(RDFResource node) {
        List<RDFResource> current = OWLAPIStreamUtils.asList(this.triples.stream().filter(p -> p.getObject().equals(node)).map(RDFTriple::getSubject));
        HashSet<RDFResource> visited = new HashSet<RDFResource>();
        ArrayList<RDFResource> next = new ArrayList<RDFResource>();
        boolean change = true;
        while (change) {
            change = false;
            for (RDFResource n : current) {
                if (!visited.add(n)) continue;
                List<RDFResource> l = OWLAPIStreamUtils.asList(this.triples.stream().filter(p -> p.getObject().equals(n)).map(RDFTriple::getSubject));
                if (l.size() > 0) {
                    change = true;
                    next.addAll(l);
                    continue;
                }
                next.add(n);
            }
            current = next;
            next = new ArrayList();
        }
        return current;
    }

    public void setOntology(@Nullable RDFResource mappedNode) {
        this.ontology = mappedNode;
    }

    @Nullable
    public RDFResource getOntology() {
        return this.ontology;
    }
}

