/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.ByName;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConfigurationOptions {
    ACCEPT_HTTP_COMPRESSION(Boolean.TRUE),
    CONNECTION_TIMEOUT(20000),
    FOLLOW_REDIRECTS(Boolean.TRUE),
    LOAD_ANNOTATIONS(Boolean.TRUE),
    MISSING_IMPORT_HANDLING_STRATEGY(MissingImportHandlingStrategy.THROW_EXCEPTION),
    MISSING_ONTOLOGY_HEADER_STRATEGY(MissingOntologyHeaderStrategy.INCLUDE_GRAPH),
    REPORT_STACK_TRACES(Boolean.TRUE),
    RETRIES_TO_ATTEMPT(5),
    PARSE_WITH_STRICT_CONFIGURATION(Boolean.FALSE),
    TREAT_DUBLINCORE_AS_BUILTIN(Boolean.TRUE),
    PRIORITY_COLLECTION_SORTING(PriorityCollectionSorting.ON_SET_INJECTION_ONLY),
    SAVE_IDS(Boolean.FALSE),
    REMAP_IDS(Boolean.TRUE),
    USE_NAMESPACE_ENTITIES(Boolean.FALSE),
    INDENTING(Boolean.TRUE),
    INDENT_SIZE(4),
    LABELS_AS_BANNER(Boolean.FALSE),
    BANNERS_ENABLED(Boolean.FALSE),
    BANNED_PARSERS(""),
    ENTITY_EXPANSION_LIMIT("100000000"),
    REPAIR_ILLEGAL_PUNNINGS(Boolean.TRUE),
    AUTHORIZATION_VALUE(""),
    TRIM_TO_SIZE(Boolean.TRUE),
    SKIP_MODULE_ANNOTATIONS(Boolean.FALSE),
    CACHE_SIZE(2048);

    private static final String PREFIX = "org.semanticweb.owlapi.model.parameters.ConfigurationOptions.";
    private static final Logger LOGGER;
    private static final EnumMap<ConfigurationOptions, Object> owlapiProperties;
    private Object defaultValue;

    private ConfigurationOptions(Object o) {
        this.defaultValue = o;
    }

    private static EnumMap<ConfigurationOptions, Object> loadProperties() {
        EnumMap<ConfigurationOptions, Object> map = new EnumMap<ConfigurationOptions, Object>(ConfigurationOptions.class);
        Properties props = new Properties();
        try (InputStream stream = ConfigurationOptions.class.getResourceAsStream("/owlapi.properties");){
            if (stream != null) {
                props.load(stream);
            }
        }
        catch (IOException e) {
            LOGGER.error("Properties cannot be loaded", (Throwable)e);
        }
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> {
            ConfigurationOptions option = ConfigurationOptions.find(name.toString());
            if (option != null) {
                map.put(option, value);
            }
        }));
        return map;
    }

    @Nullable
    public static ConfigurationOptions find(String parameterName) {
        if (!parameterName.startsWith(PREFIX)) {
            return null;
        }
        return ConfigurationOptions.valueOf(parameterName.substring(PREFIX.length()));
    }

    protected <T> T parse(Object value, Class<T> type) {
        if (Boolean.class.equals(type)) {
            return type.cast(Boolean.valueOf(value.toString()));
        }
        if (Long.class.equals(type)) {
            return type.cast(Long.valueOf(value.toString()));
        }
        if (Integer.class.equals(type)) {
            return type.cast(Integer.valueOf(value.toString()));
        }
        if (this.defaultValue instanceof ByName) {
            return type.cast(((ByName)this.defaultValue).byName(value.toString()));
        }
        return type.cast(value);
    }

    public <T> T getValue(Class<T> type, Map<ConfigurationOptions, Object> overrides) {
        Object override = overrides.get((Object)this);
        if (override != null) {
            return this.parse(override, type);
        }
        String fromSystemProperties = System.getProperty(PREFIX + this.name());
        if (fromSystemProperties != null) {
            return this.parse(fromSystemProperties, type);
        }
        Object fromConfigFile = owlapiProperties.get((Object)this);
        if (fromConfigFile != null) {
            return this.parse(fromConfigFile, type);
        }
        return type.cast(this.defaultValue);
    }

    public <T> T getDefaultValue(Class<T> type) {
        return type.cast(this.defaultValue);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ConfigurationOptions.class);
        owlapiProperties = ConfigurationOptions.loadProperties();
    }
}

