/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomFilter;

public class OWLOntologyMerger
implements OWLAxiomFilter {
    private final OWLOntologySetProvider setProvider;
    private final OWLAxiomFilter axiomFilter;
    private final boolean mergeOnlyLogicalAxioms;

    public OWLOntologyMerger(OWLOntologySetProvider setProvider) {
        this.setProvider = OWLAPIPreconditions.checkNotNull(setProvider, "setProvider cannot be null");
        this.axiomFilter = this;
        this.mergeOnlyLogicalAxioms = false;
    }

    public OWLOntologyMerger(OWLOntologySetProvider setProvider, boolean mergeOnlyLogicalAxioms) {
        this.setProvider = OWLAPIPreconditions.checkNotNull(setProvider, "setProvider cannot be null");
        this.mergeOnlyLogicalAxioms = mergeOnlyLogicalAxioms;
        this.axiomFilter = this;
    }

    public OWLOntologyMerger(OWLOntologySetProvider setProvider, OWLAxiomFilter axiomFilter) {
        this.setProvider = OWLAPIPreconditions.checkNotNull(setProvider, "setProvider cannot be null");
        this.axiomFilter = axiomFilter;
        this.mergeOnlyLogicalAxioms = false;
    }

    public OWLOntology createMergedOntology(OWLOntologyManager ontologyManager, @Nullable IRI ontologyIRI) throws OWLOntologyCreationException {
        OWLOntology ontology = ontologyIRI != null ? ontologyManager.createOntology(ontologyIRI) : ontologyManager.createOntology();
        this.setProvider.ontologies().filter(o -> o != ontology).flatMap(this::getAxioms).filter(this.axiomFilter::passes).forEach(ontology::add);
        return ontology;
    }

    private Stream<? extends OWLAxiom> getAxioms(OWLOntology ont) {
        if (this.mergeOnlyLogicalAxioms) {
            return ont.logicalAxioms();
        }
        return ont.axioms();
    }

    @Override
    public boolean passes(OWLAxiom axiom) {
        return true;
    }
}

