/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model.providers;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

@FunctionalInterface
public interface ClassProvider
extends Serializable {
    public OWLClass getOWLClass(IRI var1);

    default public OWLClass getOWLClass(HasIRI iri) {
        return this.getOWLClass(iri.getIRI());
    }

    default public OWLClass getOWLClass(String iri) {
        return this.getOWLClass(IRI.create(iri));
    }

    default public OWLClass getOWLClass(String namespace, @Nullable String remainder) {
        return this.getOWLClass(IRI.create(namespace, remainder));
    }

    default public OWLClass getOWLClass(String abbreviatedIRI, PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "iri cannot be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLClass(prefixManager.getIRI(abbreviatedIRI));
    }
}

