/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity.locality;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.modularity.ModuleExtractor;
import org.semanticweb.owlapi.modularity.locality.LocalityClass;
import org.semanticweb.owlapi.modularity.locality.LocalityEvaluator;

public abstract class LocalityModuleExtractor
implements ModuleExtractor {
    @Nonnull
    private final Set<OWLAxiom> axiomBase;
    @Nonnull
    private final LocalityClass localityClass;
    @Nonnull
    private final Map<OWLEntity, Set<OWLAxiom>> axiomsContainingEntity = new HashMap<OWLEntity, Set<OWLAxiom>>();

    private static void addNonLocal(OWLAxiom axiom, Set<OWLEntity> signature, Set<OWLAxiom> module, Set<OWLEntity> workingSignature, LocalityEvaluator evaluator) {
        if (!module.contains(axiom) && !evaluator.isLocal(axiom, signature)) {
            module.add(axiom);
            Set axiomSignature = axiom.signature().collect(Collectors.toSet());
            axiomSignature.removeAll(signature);
            workingSignature.addAll(axiomSignature);
            axiom.signature().forEach(signature::add);
        }
    }

    protected LocalityModuleExtractor(LocalityClass localityClass, Stream<OWLAxiom> axiomBase) {
        this.axiomBase = axiomBase.collect(Collectors.toSet());
        this.localityClass = Objects.requireNonNull(localityClass, "The given locality class may not be null.");
        this.initialize();
    }

    @Override
    @Nonnull
    public final Stream<OWLAxiom> axiomBase() {
        return this.axiomBase.stream();
    }

    protected abstract LocalityEvaluator bottomEvaluator();

    @Override
    public boolean containsAxiom(OWLAxiom axiom) {
        return this.axiomBase.contains(axiom);
    }

    @Override
    public final Stream<OWLAxiom> extract(Stream<OWLEntity> signature, Optional<Predicate<OWLAxiom>> axiomFilter) {
        Set<OWLEntity> signatureSet = signature.collect(Collectors.toSet());
        if (this.localityClass == LocalityClass.STAR) {
            return this.extractStarModule(signatureSet, axiomFilter).stream();
        }
        LocalityEvaluator evaluator = this.localityClass == LocalityClass.BOTTOM ? this.bottomEvaluator() : this.topEvaluator();
        return this.extractLocalityBasedModule(signatureSet, axiomFilter, evaluator).stream();
    }

    @Nonnull
    protected final Set<OWLAxiom> extractLocalityBasedModule(Set<OWLEntity> signature, Optional<Predicate<OWLAxiom>> axiomFilter, LocalityEvaluator evaluator) {
        Function<OWLEntity, Stream> axiomsOfEntity = entity -> this.axiomsContainingEntity.get(entity).stream();
        if (axiomFilter.isPresent()) {
            axiomsOfEntity = axiomsOfEntity.andThen(stream -> stream.filter((Predicate)axiomFilter.get()));
        }
        HashSet<OWLEntity> signatureCopy = new HashSet<OWLEntity>(signature);
        HashSet<OWLAxiom> module = new HashSet<OWLAxiom>();
        HashSet<OWLEntity> workingSignature = new HashSet<OWLEntity>(signatureCopy);
        while (!workingSignature.isEmpty()) {
            OWLEntity omega = (OWLEntity)workingSignature.stream().findAny().get();
            workingSignature.remove(omega);
            axiomsOfEntity.apply(omega).forEach(alpha -> LocalityModuleExtractor.addNonLocal(alpha, signatureCopy, module, workingSignature, evaluator));
        }
        assert (!axiomFilter.isPresent() || module.stream().allMatch(axiomFilter.get()));
        return module;
    }

    @Nonnull
    protected final Set<OWLAxiom> extractStarModule(Set<OWLEntity> signature, Optional<Predicate<OWLAxiom>> axiomFilter) {
        int previousSize;
        LocalityEvaluator bottom = this.bottomEvaluator();
        LocalityEvaluator top = this.topEvaluator();
        Set<OWLAxiom> module = this.extractLocalityBasedModule(signature, axiomFilter, bottom);
        LocalityEvaluator nextExtractionType = top;
        do {
            previousSize = module.size();
            module = this.extractLocalityBasedModule(signature, Optional.of(module::contains), nextExtractionType);
            LocalityEvaluator localityEvaluator = nextExtractionType = nextExtractionType == bottom ? top : bottom;
        } while (previousSize != module.size());
        return module;
    }

    @Nonnull
    public LocalityClass getLocalityClass() {
        return this.localityClass;
    }

    private void initialize() {
        this.axiomBase().forEach(axiom -> axiom.signature().forEach(entity -> this.axiomsContainingEntity.computeIfAbsent((OWLEntity)entity, x -> new HashSet()).add(axiom)));
    }

    protected abstract LocalityEvaluator topEvaluator();
}

