/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity.locality;

import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.modularity.locality.LocalityClass;
import org.semanticweb.owlapi.modularity.locality.LocalityEvaluator;
import org.semanticweb.owlapi.modularity.locality.LocalityModuleExtractor;
import org.semanticweb.owlapi.modularity.locality.SemanticLocalityEvaluator;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public final class SemanticLocalityModuleExtractor
extends LocalityModuleExtractor {
    private final OWLReasonerFactory reasonerFactory;
    private final OWLOntologyManager ontologyManager;

    public SemanticLocalityModuleExtractor(LocalityClass localityClass, Stream<OWLAxiom> axiomBase, OWLOntologyManager ontologyManager, OWLReasonerFactory reasonerFactory) {
        super(localityClass, axiomBase);
        this.ontologyManager = ontologyManager;
        this.reasonerFactory = reasonerFactory;
    }

    @Override
    protected LocalityEvaluator bottomEvaluator() {
        return new SemanticLocalityEvaluator(LocalityClass.BOTTOM, this.ontologyManager, this.reasonerFactory);
    }

    @Override
    protected LocalityEvaluator topEvaluator() {
        return new SemanticLocalityEvaluator(LocalityClass.TOP, this.ontologyManager, this.reasonerFactory);
    }
}

