/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFXMLParserException;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParserException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFXMLParser
extends AbstractOWLParser {
    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new RDFXMLDocumentFormatFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        InputSource is = null;
        try {
            is = this.getInputSource(documentSource, configuration);
            final RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
            RDFParser parser = new RDFParser(){

                @Override
                public void startPrefixMapping(@Nullable String prefix, @Nullable String uri) throws SAXException {
                    super.startPrefixMapping(prefix, uri);
                    if (prefix != null && uri != null) {
                        format.setPrefix(prefix, uri);
                    }
                }
            };
            OWLRDFConsumer consumer = new OWLRDFConsumer(ontology, configuration);
            consumer.setIRIProvider(parser);
            consumer.setOntologyFormat(format);
            parser.parse(is, consumer);
            RDFXMLDocumentFormat rDFXMLDocumentFormat = format;
            return rDFXMLDocumentFormat;
        }
        catch (IOException | OWLOntologyInputSourceException | RDFParserException | SAXException e) {
            throw new OWLRDFXMLParserException(e);
        }
        finally {
            block36: {
                if (is != null) {
                    try (InputStream byteStream = is.getByteStream();){
                        Reader characterStream = is.getCharacterStream();
                        Throwable throwable = null;
                        if (characterStream == null) break block36;
                        if (throwable != null) {
                            try {
                                characterStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            characterStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new OWLRDFXMLParserException(e);
                    }
                }
            }
        }
    }
}

