/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;

public class ExplanationOrdererImplNoManager
implements ExplanationOrderer {
    protected static final Comparator<Tree<OWLAxiom>> COMPARATOR = (o1, o2) -> {
        OWLAxiom ax2;
        OWLAxiom ax1 = (OWLAxiom)o1.getUserObject();
        if (Objects.equals(ax1, ax2 = (OWLAxiom)o2.getUserObject())) {
            return 0;
        }
        if (ax1 instanceof OWLEquivalentClassesAxiom && !(ax2 instanceof OWLEquivalentClassesAxiom)) {
            return 1;
        }
        if (ax2 instanceof OWLEquivalentClassesAxiom && !(ax1 instanceof OWLEquivalentClassesAxiom)) {
            return -1;
        }
        if (ax1 instanceof OWLPropertyAxiom && !(ax2 instanceof OWLPropertyAxiom)) {
            return -1;
        }
        if (ax2 instanceof OWLPropertyAxiom && !(ax1 instanceof OWLPropertyAxiom)) {
            return 1;
        }
        int diff = ExplanationOrdererImplNoManager.childDiff(o1, o2);
        if (diff != 0) {
            return diff;
        }
        if (ax1 instanceof OWLSubClassOfAxiom && ax2 instanceof OWLSubClassOfAxiom) {
            return ((OWLSubClassOfAxiom)ax1).getSuperClass().compareTo(((OWLSubClassOfAxiom)ax2).getSuperClass());
        }
        return 0;
    };
    protected static final Comparator<OWLObject> PROPERTIESFIRST = (o1, o2) -> {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof OWLProperty && o2 instanceof OWLProperty) {
            return o1.compareTo(o2);
        }
        if (o1 instanceof OWLProperty) {
            return -1;
        }
        return 1;
    };
    private final Map<OWLEntity, Set<OWLAxiom>> lhs2AxiomMap = CollectionFactory.createMap();
    private final Map<OWLAxiom, Set<OWLEntity>> entitiesByAxiomRHS = CollectionFactory.createMap();
    private final SeedExtractor seedExtractor = new SeedExtractor();
    private final Map<OWLObject, Set<OWLAxiom>> mappedAxioms = CollectionFactory.createMap();
    private final Set<OWLAxiom> consumedAxioms = CollectionFactory.createLinkedSet();
    private final Set<AxiomType<?>> passTypes = CollectionFactory.createLinkedSet();
    protected Set<OWLAxiom> currentExplanation;
    private final Map<OWLEntity, Set<OWLAxiom>> axioms = new HashMap<OWLEntity, Set<OWLAxiom>>();

    public ExplanationOrdererImplNoManager() {
        this.currentExplanation = Collections.emptySet();
        this.passTypes.add(AxiomType.DISJOINT_CLASSES);
    }

    protected static void sortChildrenAxioms(ExplanationTree tree) {
        tree.sortChildren(COMPARATOR);
    }

    protected static int childDiff(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
        int childCount1 = o1.getChildCount();
        childCount1 = childCount1 > 0 ? 0 : 1;
        int childCount2 = o2.getChildCount();
        childCount2 = childCount2 > 0 ? 0 : 1;
        return childCount1 - childCount2;
    }

    protected void reset() {
        this.lhs2AxiomMap.clear();
        this.entitiesByAxiomRHS.clear();
        this.consumedAxioms.clear();
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> current) {
        this.currentExplanation = new HashSet<OWLAxiom>(current);
        this.buildIndices();
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        this.insertChildren(this.seedExtractor.getSource(entailment), root);
        OWLEntity currentTarget = this.seedExtractor.getTarget(entailment);
        Set axs = root.getUserObjectClosure();
        ArrayList<OWLAxiom> rootAxioms = new ArrayList<OWLAxiom>();
        for (OWLAxiom ax2 : current) {
            if (axs.contains(ax2)) continue;
            rootAxioms.add(ax2);
        }
        Set<OWLAxiom> targetAxioms = this.getTargetAxioms(currentTarget);
        Collections.sort(rootAxioms, (o1, o2) -> {
            boolean o2in;
            boolean o1in = targetAxioms.contains(o1);
            if (o1in == (o2in = targetAxioms.contains(o2))) {
                return 0;
            }
            if (o1in) {
                return 1;
            }
            return -1;
        });
        rootAxioms.forEach(ax -> root.addChild(new ExplanationTree((OWLAxiom)ax)));
        return root;
    }

    protected Set<OWLAxiom> getTargetAxioms(OWLEntity target) {
        return this.axioms.getOrDefault(target, Collections.emptySet());
    }

    private Stream<OWLEntity> getRHSEntitiesSorted(OWLAxiom ax) {
        return this.getRHSEntities(ax).stream().sorted(PROPERTIESFIRST);
    }

    private void insertChildren(@Nullable OWLEntity entity, ExplanationTree tree) {
        if (entity == null) {
            return;
        }
        HashSet currentPath = new HashSet(tree.getUserObjectPathToRoot());
        this.getAxioms(entity).filter(ax -> !this.passTypes.contains(ax.getAxiomType())).forEach(ax -> {
            Set mapped = this.mappedAxioms.computeIfAbsent(entity, x -> CollectionFactory.createLinkedSet());
            if (!(this.consumedAxioms.contains(ax) || mapped.contains(ax) || currentPath.contains(ax))) {
                mapped.add(ax);
                this.consumedAxioms.add((OWLAxiom)ax);
                ExplanationTree child = new ExplanationTree((OWLAxiom)ax);
                tree.addChild(child);
                this.getRHSEntitiesSorted((OWLAxiom)ax).forEach(ent -> this.insertChildren((OWLEntity)ent, child));
            }
        });
        ExplanationOrdererImplNoManager.sortChildrenAxioms(tree);
    }

    protected Stream<? extends OWLAxiom> getAxioms(OWLEntity entity) {
        return this.getTargetAxioms(entity).stream();
    }

    protected void buildIndices() {
        this.reset();
        AxiomMapBuilder builder = new AxiomMapBuilder();
        this.currentExplanation.forEach(ax -> ax.accept(builder));
        this.currentExplanation.forEach(ax -> ax.signature().forEach(c -> this.axioms.computeIfAbsent((OWLEntity)c, x -> new HashSet())));
    }

    protected Set<OWLAxiom> getAxiomsForLHS(OWLEntity lhs) {
        return this.lhs2AxiomMap.computeIfAbsent(lhs, x -> CollectionFactory.createLinkedSet());
    }

    protected void addLHS(IsAnonymous e, OWLAxiom ax) {
        if (e.isNamed()) {
            this.getAxiomsForLHS((OWLEntity)e).add(ax);
        }
    }

    protected void addLHSAndRHS(IsAnonymous a, OWLObject b, OWLAxiom ax) {
        this.addLHS(a, ax);
        this.indexAxiomsByRHSEntities(b, ax);
    }

    private Collection<OWLEntity> getRHSEntities(OWLAxiom axiom) {
        return this.entitiesByAxiomRHS.computeIfAbsent(axiom, x -> CollectionFactory.createLinkedSet());
    }

    protected void indexAxiomsByRHSEntities(OWLObject rhs, OWLAxiom axiom) {
        OWLAPIStreamUtils.add(this.entitiesByAxiomRHS.computeIfAbsent(axiom, x -> CollectionFactory.createLinkedSet()), rhs.signature());
    }

    protected class AxiomMapBuilder
    implements OWLAxiomVisitor {
        AxiomMapBuilder() {
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS(axiom.getSubClass(), axiom.getSuperClass(), axiom);
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            axiom.classExpressions().forEach(desc -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)desc, (OWLObject)desc, axiom));
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)axiom.getProperty(), (OWLObject)axiom.getDomain(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)axiom.getProperty(), (OWLObject)axiom.getDomain(), axiom);
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)prop, (OWLObject)prop, axiom));
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            axiom.individuals().forEach(ind -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)ind, (OWLObject)ind, axiom));
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)prop, (OWLObject)prop, axiom));
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)prop, (OWLObject)prop, axiom));
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)axiom.getProperty(), (OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)axiom.getSubProperty(), (OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            ExplanationOrdererImplNoManager.this.getAxiomsForLHS(axiom.getOWLClass()).add(axiom);
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)axiom.getProperty(), (OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)prop, (OWLObject)prop, axiom));
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS(axiom.getIndividual(), axiom.getClassExpression(), axiom);
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            axiom.classExpressions().forEach(desc -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)desc, (OWLObject)desc, axiom));
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)axiom.getSubProperty(), (OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHS((IsAnonymous)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            axiom.individuals().forEach(ind -> ExplanationOrdererImplNoManager.this.addLHSAndRHS((IsAnonymous)ind, (OWLObject)ind, axiom));
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            ExplanationOrdererImplNoManager.this.addLHSAndRHS(axiom.getFirstProperty(), axiom.getSecondProperty(), axiom);
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getFirstProperty(), axiom);
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }
    }

    private static class SeedExtractor
    implements OWLAxiomVisitor {
        @Nullable
        private OWLEntity source;
        @Nullable
        private OWLEntity target;

        SeedExtractor() {
        }

        @Nullable
        public OWLEntity getSource(OWLAxiom axiom) {
            axiom.accept(this);
            return this.source;
        }

        public OWLEntity getTarget(OWLAxiom axiom) {
            axiom.accept(this);
            return OWLAPIPreconditions.verifyNotNull(this.target);
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            this.setSource(axiom.getSubClass());
            if (!axiom.getSuperClass().isOWLNothing()) {
                this.setTarget(axiom.getSuperClass());
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            axiom.classExpressions().forEach(this::overrideNullSourceOrTarget);
        }

        protected void overrideNullSourceOrTarget(IsAnonymous ce) {
            if (this.source == null && this.setSource(ce)) {
                return;
            }
            if (this.target == null) {
                this.setTarget(ce);
            }
        }

        protected boolean setTarget(IsAnonymous ce) {
            if (ce.isAnonymous()) {
                return false;
            }
            this.target = (OWLEntity)ce;
            return true;
        }

        protected boolean setSource(IsAnonymous ce) {
            if (ce.isAnonymous()) {
                return false;
            }
            this.source = (OWLEntity)ce;
            return true;
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.setSource((IsAnonymous)axiom.getSubProperty());
            this.setTarget((IsAnonymous)axiom.getSuperProperty());
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                this.setSource(axiom.getIndividual());
                this.setTarget(axiom.getClassExpression());
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            axiom.namedClasses().forEach(this::overrideNullSourceOrTarget);
        }

        @Override
        public void visit(SWRLRule rule) {
        }
    }
}

