/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;

public class ExplanationOrdererImplNoManager
implements ExplanationOrderer {
    private static final AtomicLong RANDOMSTART = new AtomicLong(System.currentTimeMillis());
    private static final Comparator<Tree<OWLAxiom>> COMPARATOR = (o1, o2) -> {
        OWLAxiom ax1 = (OWLAxiom)o1.getUserObject();
        OWLAxiom ax2 = (OWLAxiom)o2.getUserObject();
        if (ax1 instanceof OWLEquivalentClassesAxiom) {
            return 1;
        }
        if (ax2 instanceof OWLEquivalentClassesAxiom || ax1 instanceof OWLPropertyAxiom) {
            return -1;
        }
        int diff = ExplanationOrdererImplNoManager.childDiff(o1, o2);
        if (diff != 0) {
            return diff;
        }
        if (ax1 instanceof OWLSubClassOfAxiom && ax2 instanceof OWLSubClassOfAxiom) {
            return ((OWLSubClassOfAxiom)ax1).getSuperClass().compareTo(((OWLSubClassOfAxiom)ax2).getSuperClass());
        }
        return 1;
    };
    private static final Comparator<OWLObject> PROPERTIESFIRST = (o1, o2) -> {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof OWLProperty && o2 instanceof OWLProperty) {
            return o1.compareTo(o2);
        }
        if (o1 instanceof OWLProperty) {
            return -1;
        }
        return 1;
    };
    private final Map<OWLEntity, Set<OWLAxiom>> lhs2AxiomMap = CollectionFactory.createMap();
    private final Map<OWLAxiom, Set<OWLEntity>> entitiesByAxiomRHS = CollectionFactory.createMap();
    private final SeedExtractor seedExtractor = new SeedExtractor();
    private final Map<OWLObject, Set<OWLAxiom>> mappedAxioms = CollectionFactory.createMap();
    private final Set<OWLAxiom> consumedAxioms = CollectionFactory.createLinkedSet();
    private final Set<AxiomType<?>> passTypes = CollectionFactory.createLinkedSet();
    private Set<OWLAxiom> currentExplanation;
    private Map<OWLEntity, Set<OWLAxiom>> axioms = new HashMap<OWLEntity, Set<OWLAxiom>>();

    public ExplanationOrdererImplNoManager() {
        this.currentExplanation = Collections.emptySet();
        this.passTypes.add(AxiomType.DISJOINT_CLASSES);
    }

    private static void sortChildrenAxioms(ExplanationTree tree) {
        tree.sortChildren(COMPARATOR);
    }

    private static <K, E> Set<E> getIndexedSet(K obj, Map<K, Set<E>> map, boolean addIfEmpty) {
        if (addIfEmpty) {
            return map.computeIfAbsent(obj, x -> CollectionFactory.createLinkedSet());
        }
        Set<E> set = map.get(obj);
        if (set == null) {
            return CollectionFactory.createLinkedSet();
        }
        return set;
    }

    private static int childDiff(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
        int childCount1 = o1.getChildCount();
        childCount1 = childCount1 > 0 ? 0 : 1;
        int childCount2 = o2.getChildCount();
        childCount2 = childCount2 > 0 ? 0 : 1;
        return childCount1 - childCount2;
    }

    private void reset() {
        this.lhs2AxiomMap.clear();
        this.entitiesByAxiomRHS.clear();
        this.consumedAxioms.clear();
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        this.currentExplanation = new HashSet<OWLAxiom>(axioms);
        this.buildIndices();
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        this.insertChildren(this.seedExtractor.getSource(entailment), root);
        OWLEntity currentTarget = this.seedExtractor.getTarget(entailment);
        Set axs = root.getUserObjectClosure();
        ArrayList<OWLAxiom> rootAxioms = new ArrayList<OWLAxiom>();
        for (OWLAxiom ax2 : axioms) {
            if (axs.contains(ax2)) continue;
            rootAxioms.add(ax2);
        }
        Set<OWLAxiom> targetAxioms = this.getTargetAxioms(currentTarget);
        Collections.sort(rootAxioms, (o1, o2) -> {
            if (targetAxioms.contains(o1)) {
                return 1;
            }
            if (targetAxioms.contains(o2)) {
                return -1;
            }
            return 0;
        });
        rootAxioms.forEach(ax -> root.addChild(new ExplanationTree((OWLAxiom)ax)));
        return root;
    }

    private Set<OWLAxiom> getTargetAxioms(OWLEntity target) {
        return this.axioms.getOrDefault(target, Collections.emptySet());
    }

    private Stream<OWLEntity> getRHSEntitiesSorted(OWLAxiom ax) {
        return this.getRHSEntities(ax).stream().sorted(PROPERTIESFIRST);
    }

    private void insertChildren(@Nullable OWLEntity entity, ExplanationTree tree) {
        if (entity == null) {
            return;
        }
        HashSet currentPath = new HashSet(tree.getUserObjectPathToRoot());
        this.getAxioms(entity).filter(ax -> !this.passTypes.contains(ax.getAxiomType())).forEach(ax -> {
            Set<OWLAxiom> mapped = ExplanationOrdererImplNoManager.getIndexedSet(entity, this.mappedAxioms, true);
            if (!(this.consumedAxioms.contains(ax) || mapped.contains(ax) || currentPath.contains(ax))) {
                mapped.add((OWLAxiom)ax);
                this.consumedAxioms.add((OWLAxiom)ax);
                ExplanationTree child = new ExplanationTree((OWLAxiom)ax);
                tree.addChild(child);
                this.getRHSEntitiesSorted((OWLAxiom)ax).forEach(ent -> this.insertChildren((OWLEntity)ent, child));
            }
        });
        ExplanationOrdererImplNoManager.sortChildrenAxioms(tree);
    }

    protected Stream<? extends OWLAxiom> getAxioms(OWLEntity entity) {
        return this.getTargetAxioms(entity).stream();
    }

    private void buildIndices() {
        this.reset();
        AxiomMapBuilder builder = new AxiomMapBuilder();
        this.currentExplanation.forEach(ax -> ax.accept(builder));
        this.currentExplanation.forEach(ax -> ax.signature().forEach(c -> this.axioms.computeIfAbsent((OWLEntity)c, x -> new HashSet())));
    }

    protected Set<OWLAxiom> getAxiomsForLHS(OWLEntity lhs) {
        return ExplanationOrdererImplNoManager.getIndexedSet(lhs, this.lhs2AxiomMap, true);
    }

    private Collection<OWLEntity> getRHSEntities(OWLAxiom axiom) {
        return ExplanationOrdererImplNoManager.getIndexedSet(axiom, this.entitiesByAxiomRHS, true);
    }

    protected void indexAxiomsByRHSEntities(OWLObject rhs, OWLAxiom axiom) {
        OWLAPIStreamUtils.add(ExplanationOrdererImplNoManager.getIndexedSet(axiom, this.entitiesByAxiomRHS, true), rhs.signature());
    }

    private class AxiomMapBuilder
    implements OWLAxiomVisitor {
        AxiomMapBuilder() {
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(axiom.getSubClass().asOWLClass()).add(axiom);
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getSuperClass(), axiom);
            }
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            axiom.classExpressions().forEach(desc -> {
                if (!desc.isAnonymous()) {
                    ExplanationOrdererImplNoManager.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)desc, axiom);
            });
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)axiom.getDomain(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)axiom.getDomain(), axiom);
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> {
                if (!prop.isAnonymous()) {
                    ExplanationOrdererImplNoManager.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)prop, axiom);
            });
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            axiom.individuals().forEach(ind -> {
                if (!ind.isAnonymous()) {
                    ExplanationOrdererImplNoManager.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                    ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)ind, axiom);
                }
            });
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)prop, axiom);
            });
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> {
                if (!prop.isAnonymous()) {
                    ExplanationOrdererImplNoManager.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)prop, axiom);
            });
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            ExplanationOrdererImplNoManager.this.getAxiomsForLHS(axiom.getOWLClass()).add(axiom);
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            axiom.properties().forEach(prop -> {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)prop, axiom);
            });
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getIndividual().isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(axiom.getIndividual().asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getClassExpression(), axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            axiom.classExpressions().forEach(desc -> {
                if (!desc.isAnonymous()) {
                    ExplanationOrdererImplNoManager.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)desc, axiom);
            });
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty()).add(axiom);
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            axiom.individuals().filter(ind -> !ind.isAnonymous()).forEach(ind -> {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities((OWLObject)ind, axiom);
            });
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (!axiom.getFirstProperty().isAnonymous()) {
                ExplanationOrdererImplNoManager.this.getAxiomsForLHS(axiom.getFirstProperty().asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getFirstProperty(), axiom);
            ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getSecondProperty(), axiom);
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                ExplanationOrdererImplNoManager.this.indexAxiomsByRHSEntities(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }
    }

    private static class SeedExtractor
    implements OWLAxiomVisitor {
        @Nullable
        private OWLEntity source;
        @Nullable
        private OWLEntity target;

        SeedExtractor() {
        }

        @Nullable
        public OWLEntity getSource(OWLAxiom axiom) {
            axiom.accept(this);
            return this.source;
        }

        public OWLEntity getTarget(OWLAxiom axiom) {
            axiom.accept(this);
            return OWLAPIPreconditions.verifyNotNull(this.target);
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression classExpression;
            if (!axiom.getSubClass().isAnonymous()) {
                this.source = axiom.getSubClass().asOWLClass();
            }
            if (!axiom.getSuperClass().isOWLNothing() && !(classExpression = axiom.getSuperClass()).isAnonymous()) {
                this.target = classExpression.asOWLClass();
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            axiom.classExpressions().filter(c -> !c.isAnonymous()).forEach(ce -> {
                if (this.source == null) {
                    this.source = ce.asOWLClass();
                } else if (this.target == null) {
                    this.target = ce.asOWLClass();
                } else {
                    return;
                }
            });
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                this.source = ((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty();
            }
            if (!((OWLObjectPropertyExpression)axiom.getSuperProperty()).isAnonymous()) {
                this.target = ((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty();
            }
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                this.source = axiom.getIndividual().asOWLNamedIndividual();
                this.target = axiom.getClassExpression().asOWLClass();
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            axiom.namedClasses().forEach(cls -> {
                if (this.source == null) {
                    this.source = cls;
                } else if (this.target == null) {
                    this.target = cls;
                }
            });
        }

        @Override
        public void visit(SWRLRule rule) {
        }
    }
}

