/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomCollection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomIndexImpl;

public class OWLImmutableOntologyImpl
extends OWLAxiomIndexImpl
implements OWLOntology,
Serializable {
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLEntity>> ontsignatures = OWLImmutableOntologyImpl.build(OWLImmutableOntologyImpl::build);
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLAnonymousIndividual>> ontanonCaches = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get().keySet().stream().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLClass>> ontclassesSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLClass.class, OWLAxiom.class).get().keySet().stream().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLDataProperty>> ontdataPropertySignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLDataProperty.class, OWLAxiom.class).get().keySet().stream().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLObjectProperty>> ontobjectPropertySignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLObjectProperty.class, OWLAxiom.class).get().keySet().stream().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLDatatype>> ontdatatypeSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLDatatype.class, OWLAxiom.class).get().keySet().stream().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLNamedIndividual>> ontindividualSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLNamedIndividual.class, OWLAxiom.class).get().keySet().stream().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLAnnotationProperty>> ontannotationPropertiesSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(Stream.concat(key.ints.get(OWLAnnotationProperty.class, OWLAxiom.class, Navigation.IN_SUB_POSITION).get().keySet().stream(), key.ints.getOntologyAnnotations().map(OWLAnnotation::getProperty)).distinct().sorted()));
    private final OWLEntityReferenceChecker entityReferenceChecker = new OWLEntityReferenceChecker();
    @Nullable
    protected OWLOntologyManager manager;
    protected OWLDataFactory df;
    protected OWLOntologyID ontologyID;

    protected static void invalidateOntologyCaches(OWLImmutableOntologyImpl o) {
        ontsignatures.invalidate((Object)o);
        ontanonCaches.invalidate((Object)o);
        ontclassesSignatures.invalidate((Object)o);
        ontdataPropertySignatures.invalidate((Object)o);
        ontobjectPropertySignatures.invalidate((Object)o);
        ontdatatypeSignatures.invalidate((Object)o);
        ontindividualSignatures.invalidate((Object)o);
        ontannotationPropertiesSignatures.invalidate((Object)o);
    }

    private static Set<OWLEntity> build(OWLImmutableOntologyImpl key) {
        Stream stream = Stream.of(key.classesInSignature(), key.objectPropertiesInSignature(), key.dataPropertiesInSignature(), key.individualsInSignature(), key.datatypesInSignature(), key.annotationPropertiesInSignature()).flatMap(x -> x);
        return OWLAPIStreamUtils.asSet(stream.distinct().sorted());
    }

    public OWLImmutableOntologyImpl(OWLOntologyManager manager, OWLOntologyID ontologyID) {
        this.manager = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        this.ontologyID = OWLAPIPreconditions.checkNotNull(ontologyID, "ontologyID cannot be null");
        this.df = manager.getOWLDataFactory();
    }

    private static void add(Set<IRI> punned, Set<IRI> test, OWLEntity e) {
        if (!test.add(e.getIRI())) {
            punned.add(e.getIRI());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("Ontology(").append(this.ontologyID).append(") [Axioms: ").append(this.ints.getAxiomCount()).append(" Logical Axioms: ").append(this.ints.getLogicalAxiomCount()).append("] First 20 axioms: {");
        this.ints.getAxioms().limit(20L).forEach(a -> sb.append(a).append(' '));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        OWLOntologyManager m = this.manager;
        if (m == null) {
            throw new IllegalStateException("Manager on ontology " + this.getOntologyID() + " is null; the ontology is no longer associated to a manager. Ensure the ontology is not being used after being removed from its manager.");
        }
        return OWLAPIPreconditions.verifyNotNull(m, "manager cannot be null at this stage");
    }

    @Override
    public void setOWLOntologyManager(@Nullable OWLOntologyManager manager) {
        this.manager = manager;
    }

    @Override
    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    @Override
    public boolean isAnonymous() {
        return this.ontologyID.isAnonymous();
    }

    @Override
    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.ints.getAxiomCount(axiomType);
    }

    @Override
    public int getAxiomCount() {
        return this.ints.getAxiomCount();
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom) {
        return Internals.contains(this.ints.getAxiomsByType(), axiom.getAxiomType(), axiom);
    }

    @Override
    public Stream<OWLAxiom> axioms() {
        return this.ints.getAxioms();
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType) {
        return this.ints.getAxiomsByType().getValues(axiomType);
    }

    @Override
    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.ints.getLogicalAxioms();
    }

    @Override
    public int getLogicalAxiomCount() {
        return this.ints.getLogicalAxiomCount();
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports imports) {
        return imports.stream(this).mapToInt(o -> o.getAxiomCount(axiomType)).sum();
    }

    @Override
    public int getAxiomCount(Imports imports) {
        return imports.stream(this).mapToInt(OWLAxiomCollection::getAxiomCount).sum();
    }

    @Override
    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        return AxiomType.TBoxAxiomTypes.stream().flatMap(t -> this.axioms(t, imports));
    }

    @Override
    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        return AxiomType.ABoxAxiomTypes.stream().flatMap(t -> this.axioms(t, imports));
    }

    @Override
    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        return AxiomType.RBoxAxiomTypes.stream().flatMap(t -> this.axioms(t, imports));
    }

    @Override
    public int getLogicalAxiomCount(Imports imports) {
        return imports.stream(this).mapToInt(OWLAxiomCollection::getLogicalAxiomCount).sum();
    }

    @Override
    public Stream<OWLAnnotation> annotations() {
        return this.ints.getOntologyAnnotations().sorted();
    }

    @Override
    public List<OWLAnnotation> annotationsAsList() {
        return OWLAPIStreamUtils.asList(this.annotations());
    }

    @Override
    public Stream<OWLClassAxiom> generalClassAxioms() {
        return this.ints.getGeneralClassAxioms();
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom, Imports imports, AxiomAnnotations ignoreAnnotations) {
        return imports.stream(this).anyMatch(o -> ignoreAnnotations.contains((OWLOntology)o, axiom));
    }

    @Override
    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom) {
        return this.axioms(axiom.getAxiomType()).map(x -> x).filter(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        if (this.containsAxiom(axiom)) {
            return true;
        }
        return this.axioms(axiom.getAxiomType()).anyMatch(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    @Override
    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axiomsIgnoreAnnotations(axiom));
    }

    @Override
    public boolean containsClassInSignature(IRI iri, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsClassInSignature(iri));
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsObjectPropertyInSignature(iri));
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsDataPropertyInSignature(iri));
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        boolean result = imports.stream(this).anyMatch(o -> o.containsAnnotationPropertyInSignature(iri));
        if (result) {
            return result;
        }
        return this.checkOntologyAnnotations(this.df.getOWLAnnotationProperty(iri));
    }

    private boolean checkOntologyAnnotations(OWLAnnotationProperty p) {
        return this.ints.getOntologyAnnotations().anyMatch(ann -> ann.getProperty().equals(p));
    }

    @Override
    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsIndividualInSignature(iri));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsDatatypeInSignature(iri));
    }

    @Override
    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        return this.ints.anyEntities(type);
    }

    @Override
    public Stream<OWLEntity> entitiesInSignature(IRI iri) {
        return this.unsortedSignature().filter(c -> c.getIRI().equals(iri)).sorted();
    }

    @Override
    public Stream<OWLEntity> unsortedSignature() {
        return Stream.of(this.ints.get(OWLClass.class, OWLAxiom.class).get().keySet().stream(), this.ints.get(OWLObjectProperty.class, OWLAxiom.class).get().keySet().stream(), this.ints.get(OWLDataProperty.class, OWLAxiom.class).get().keySet().stream(), this.ints.get(OWLNamedIndividual.class, OWLAxiom.class).get().keySet().stream(), this.ints.get(OWLDatatype.class, OWLAxiom.class).get().keySet().stream(), this.ints.get(OWLAnnotationProperty.class, OWLAxiom.class, Navigation.IN_SUB_POSITION).get().keySet().stream(), this.ints.getOntologyAnnotations().map(OWLAnnotation::getProperty)).flatMap(Function.identity());
    }

    @Override
    public Set<IRI> getPunnedIRIs(Imports includeImportsClosure) {
        HashSet<IRI> punned = new HashSet<IRI>();
        HashSet test = new HashSet();
        includeImportsClosure.stream(this).flatMap(HasSignature::unsortedSignature).forEach(e -> OWLImmutableOntologyImpl.add(punned, test, e));
        if (punned.isEmpty()) {
            return Collections.emptySet();
        }
        return punned;
    }

    @Override
    public boolean containsReference(OWLEntity entity, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsReference(entity);
        }
        return this.importsClosure().anyMatch(o -> o.containsReference(entity, Imports.EXCLUDED));
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity) {
        return this.ints.isDeclared(owlEntity);
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.entityReferenceChecker.containsReference(owlEntity);
    }

    @Override
    public Stream<OWLEntity> signature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontsignatures.get((Object)this));
    }

    @Override
    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontanonCaches.get((Object)this));
    }

    @Override
    public Stream<OWLClass> classesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontclassesSignatures.get((Object)this));
    }

    @Override
    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontdataPropertySignatures.get((Object)this));
    }

    @Override
    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontobjectPropertySignatures.get((Object)this));
    }

    @Override
    public Stream<OWLNamedIndividual> individualsInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontindividualSignatures.get((Object)this));
    }

    @Override
    public Stream<OWLDatatype> datatypesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontdatatypeSignatures.get((Object)this));
    }

    @Override
    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.anonymousIndividuals();
    }

    @Override
    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)ontannotationPropertiesSignatures.get((Object)this));
    }

    @Override
    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.ints.getImportsDeclarations();
    }

    @Override
    public Stream<IRI> directImportsDocuments() {
        return this.ints.getImportsDeclarations().map(OWLImportsDeclaration::getIRI);
    }

    @Override
    public Stream<OWLOntology> imports() {
        return this.getOWLOntologyManager().imports(this);
    }

    @Override
    public Stream<OWLOntology> directImports() {
        return this.getOWLOntologyManager().directImports(this);
    }

    @Override
    public Stream<OWLOntology> importsClosure() {
        return this.getOWLOntologyManager().importsClosure(this);
    }

    @Override
    public Stream<OWLClassAxiom> axioms(OWLClass cls) {
        return this.ints.get(OWLClass.class, OWLClassAxiom.class).get().values(cls, OWLClassAxiom.class);
    }

    @Override
    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property) {
        return Stream.of(this.asymmetricObjectPropertyAxioms(property), this.reflexiveObjectPropertyAxioms(property), this.symmetricObjectPropertyAxioms(property), this.irreflexiveObjectPropertyAxioms(property), this.transitiveObjectPropertyAxioms(property), this.inverseFunctionalObjectPropertyAxioms(property), this.functionalObjectPropertyAxioms(property), this.inverseObjectPropertyAxioms(property), this.objectPropertyDomainAxioms(property), this.equivalentObjectPropertiesAxioms(property), this.disjointObjectPropertiesAxioms(property), this.objectPropertyRangeAxioms(property), this.objectSubPropertyAxiomsForSubProperty(property)).flatMap(x -> x);
    }

    @Override
    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property) {
        return Stream.of(this.dataPropertyDomainAxioms(property), this.equivalentDataPropertiesAxioms(property), this.disjointDataPropertiesAxioms(property), this.dataPropertyRangeAxioms(property), this.functionalDataPropertyAxioms(property), this.dataSubPropertyAxiomsForSubProperty(property)).flatMap(x -> x);
    }

    @Override
    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual) {
        return Stream.of(this.classAssertionAxioms(individual), this.objectPropertyAssertionAxioms(individual), this.dataPropertyAssertionAxioms(individual), this.negativeObjectPropertyAssertionAxioms(individual), this.negativeDataPropertyAssertionAxioms(individual), this.sameIndividualAxioms(individual), this.differentIndividualAxioms(individual)).flatMap(x -> x);
    }

    @Override
    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype) {
        return this.datatypeDefinitions(datatype);
    }

    @Override
    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlEntity) {
        if (owlEntity instanceof OWLEntity) {
            return this.ints.getReferencingAxioms((OWLEntity)owlEntity);
        }
        if (owlEntity instanceof OWLAnonymousIndividual) {
            return this.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get().values((OWLAnonymousIndividual)owlEntity, OWLAxiom.class);
        }
        if (owlEntity.isIRI()) {
            HashSet axioms = new HashSet();
            String iriString = owlEntity.toString();
            this.entitiesInSignature((IRI)owlEntity).forEach(e -> OWLAPIStreamUtils.add(axioms, this.referencingAxioms((OWLPrimitive)e)));
            this.axioms(AxiomType.DATA_PROPERTY_ASSERTION).filter(ax -> OWL2Datatype.XSD_ANY_URI.matches(((OWLLiteral)ax.getObject()).getDatatype())).filter(ax -> ((OWLLiteral)ax.getObject()).getLiteral().equals(iriString)).forEach(axioms::add);
            this.axioms(AxiomType.ANNOTATION_ASSERTION).forEach(ax -> this.examineAssertion(owlEntity, axioms, (OWLAnnotationAssertionAxiom)ax));
            return axioms.stream();
        }
        if (owlEntity instanceof OWLLiteral) {
            HashSet axioms = new HashSet();
            this.axioms(AxiomType.DATA_PROPERTY_ASSERTION).filter(ax -> ((OWLLiteral)ax.getObject()).equals(owlEntity)).forEach(axioms::add);
            this.axioms(AxiomType.ANNOTATION_ASSERTION).filter(ax -> owlEntity.equals(ax.getValue().asLiteral().orElse(null))).forEach(axioms::add);
            AxiomType.AXIOM_TYPES.stream().flatMap(this::axioms).filter(ax -> this.hasLiteralInAnnotations(owlEntity, (OWLAxiom)ax)).forEach(axioms::add);
            return axioms.stream();
        }
        return OWLAPIStreamUtils.empty();
    }

    protected boolean hasLiteralInAnnotations(OWLPrimitive owlEntity, OWLAxiom ax) {
        return ax.annotations().anyMatch(a -> a.getValue().equals(owlEntity));
    }

    protected void examineAssertion(OWLPrimitive owlEntity, Set<OWLAxiom> axioms, OWLAnnotationAssertionAxiom ax) {
        if (((OWLAnnotationSubject)ax.getSubject()).equals(owlEntity)) {
            axioms.add(ax);
        } else {
            ax.getValue().asLiteral().ifPresent(lit -> {
                if (OWL2Datatype.XSD_ANY_URI.matches(lit.getDatatype()) && lit.getLiteral().equals(owlEntity.toString())) {
                    axioms.add(ax);
                }
            });
        }
    }

    public <A extends OWLAxiom> Stream<A> axioms(Class<A> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        Optional<MapPointer<OWLObject, A>> optional = this.ints.get(explicitClass, type, forSubPosition);
        if (optional.isPresent()) {
            return optional.get().values(entity, type);
        }
        if (!(entity instanceof OWLEntity)) {
            return OWLAPIStreamUtils.empty();
        }
        return this.axioms(AxiomType.getTypeForClass(type)).filter(a -> a.containsEntityInSignature((OWLEntity)entity));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axioms(filter, key));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key) {
        Collection<OWLAxiom> c = this.ints.filterAxioms(filter, key);
        return c.stream();
    }

    @Override
    public boolean contains(OWLAxiomSearchFilter filter, Object key) {
        return this.ints.contains(filter, key);
    }

    @Override
    public boolean contains(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.contains(filter, key));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI iri) {
        return this.ints.containsDatatypeInSignature(iri);
    }

    @Override
    public boolean containsClassInSignature(IRI iri) {
        return this.ints.containsClassInSignature(iri);
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI iri) {
        return this.ints.containsObjectPropertyInSignature(iri);
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI iri) {
        return this.ints.containsDataPropertyInSignature(iri);
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        return this.ints.containsAnnotationPropertyInSignature(iri);
    }

    @Override
    public boolean containsIndividualInSignature(IRI iri) {
        return this.ints.containsIndividualInSignature(iri);
    }

    @Override
    public boolean containsReference(OWLEntity entity) {
        return this.ints.containsReference(entity);
    }

    private class OWLEntityReferenceChecker
    implements OWLEntityVisitor,
    Serializable {
        private boolean ref;

        OWLEntityReferenceChecker() {
        }

        public boolean containsReference(OWLEntity entity) {
            this.ref = false;
            entity.accept(this);
            return this.ref;
        }

        @Override
        public void visit(OWLClass cls) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsClassInSignature(cls);
        }

        @Override
        public void visit(OWLDatatype datatype) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsDatatypeInSignature(datatype);
        }

        @Override
        public void visit(OWLNamedIndividual individual) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsIndividualInSignature(individual);
        }

        @Override
        public void visit(OWLDataProperty property) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsDataPropertyInSignature(property);
        }

        @Override
        public void visit(OWLObjectProperty property) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsObjectPropertyInSignature(property);
        }

        @Override
        public void visit(OWLAnnotationProperty property) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsAnnotationPropertyInSignature(property);
        }
    }
}

