/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.List;
import java.util.function.Predicate;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.HasClassesInSignature;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;

public class HiddenGCICount
extends IntegerValuedMetric {
    Predicate<OWLAxiom> equivalentOrSubclass = ax -> ax instanceof OWLEquivalentClassesAxiom || ax instanceof OWLSubClassOfAxiom;
    Predicate<OWLClass> hasEquivalent = c -> EntitySearcher.getEquivalentClasses(c, this.getOntologies()).count() > 0L;
    Predicate<OWLClass> isSubclass = c -> EntitySearcher.getSubClasses(c, this.getOntologies()).count() > 0L;

    public HiddenGCICount(OWLOntology o) {
        super(o);
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        return changes.stream().filter(OWLOntologyChange::isAxiomChange).map(OWLOntologyChange::getAxiom).anyMatch(this.equivalentOrSubclass);
    }

    @Override
    protected Integer recomputeMetric() {
        return (int)this.getOntologies().flatMap(HasClassesInSignature::classesInSignature).distinct().filter(this.hasEquivalent).filter(this.isSubclass).count();
    }

    @Override
    public String getName() {
        return "Hidden GCI Count";
    }
}

