/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.LocalityChecker;
import org.semanticweb.owlapitools.decomposition.SigIndex;
import org.semanticweb.owlapitools.decomposition.Signature;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class Modularizer {
    private final SigIndex sigIndex;
    private Signature sig;
    private LocalityChecker checker;
    private List<AxiomWrapper> module = new ArrayList<AxiomWrapper>();
    private Deque<OWLEntity> workQueue;
    private long nChecks = 0L;
    private long nNonLocal = 0L;

    public Modularizer(LocalityChecker c) {
        this.checker = c;
        this.sig = c.getSignature();
        this.sigIndex = new SigIndex(this.checker);
    }

    public Signature getSignature() {
        return this.sig;
    }

    private void addAxiomSig(AxiomWrapper axiom) {
        axiom.getAxiom().signature().filter(this.sig::add).forEach(this.workQueue::add);
    }

    private void addAxiomToModule(AxiomWrapper axiom) {
        axiom.setInModule(true);
        this.module.add(axiom);
        this.addAxiomSig(axiom);
    }

    private boolean isNonLocal(AxiomWrapper ax) {
        boolean b = !this.checker.local(ax.getAxiom());
        ++this.nChecks;
        if (b) {
            ++this.nNonLocal;
        }
        return b;
    }

    private void addNonLocal(AxiomWrapper ax, boolean noCheck) {
        if (noCheck || this.isNonLocal(ax)) {
            this.addAxiomToModule(ax);
        }
    }

    private void addNonLocal(Collection<AxiomWrapper> axSet, boolean noCheck) {
        for (AxiomWrapper q : axSet) {
            if (q.isInModule() || !q.isInSearchSpace()) continue;
            this.addNonLocal(q, noCheck);
        }
    }

    private void extractModuleQueue() {
        this.workQueue.addAll(this.sig.getSignature());
        this.addNonLocal(this.sigIndex.getNonLocal(this.sig.topCLocal()), true);
        while (!this.workQueue.isEmpty()) {
            Collection<AxiomWrapper> axioms = this.sigIndex.getAxioms(this.workQueue.poll());
            this.addNonLocal(axioms, false);
        }
    }

    private void extractModule(Collection<AxiomWrapper> list) {
        this.module.clear();
        list.forEach(p -> p.setInModule(false));
        list.stream().filter(AxiomWrapper::isUsed).forEach(p -> p.setInSearchSpace(true));
        this.extractModuleQueue();
        list.forEach(p -> p.setInSearchSpace(false));
    }

    public void preprocessOntology(Collection<AxiomWrapper> axioms) {
        this.checker.preprocessOntology(axioms);
        this.sigIndex.clear();
        this.sigIndex.preprocessOntology(axioms);
        this.workQueue = new ArrayDeque<OWLEntity>(axioms.size());
        this.nChecks += (long)(2 * axioms.size());
    }

    public void extract(List<AxiomWrapper> axioms, Signature signature, ModuleType type) {
        int size;
        boolean topLocality = type == ModuleType.TOP;
        this.sig = signature;
        this.checker.setSignatureValue(this.sig);
        this.sig.setLocality(topLocality);
        this.extractModule(axioms);
        if (type != ModuleType.STAR) {
            return;
        }
        do {
            size = this.module.size();
            ArrayList<AxiomWrapper> oldModule = new ArrayList<AxiomWrapper>(this.module);
            topLocality = !topLocality;
            this.sig = signature;
            this.sig.setLocality(topLocality);
            this.extractModule(oldModule);
        } while (size != this.module.size());
    }

    public boolean isTautology(OWLAxiom ax, ModuleType type) {
        boolean topLocality = type == ModuleType.TOP;
        this.sig = new Signature(ax.signature());
        this.sig.setLocality(topLocality);
        boolean toReturn = this.checker.local(ax);
        if (type != ModuleType.STAR || !toReturn) {
            return toReturn;
        }
        this.sig.setLocality(!topLocality);
        return this.checker.local(ax);
    }

    public LocalityChecker getLocalityChecker() {
        return this.checker;
    }

    public Collection<AxiomWrapper> getModule() {
        return this.module;
    }

    long getNChecks() {
        return this.nChecks;
    }

    long getNNonLocal() {
        return this.nNonLocal;
    }

    public void extract(AxiomWrapper axiom, Signature signature, ModuleType type) {
        this.extract(Collections.singletonList(axiom), signature, type);
    }
}

