/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.atomicdecomposition.ModuleMethod;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import uk.ac.manchester.cs.factplusplusad.LocalityChecker;
import uk.ac.manchester.cs.factplusplusad.SigIndex;
import uk.ac.manchester.cs.factplusplusad.Signature;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class Modularizer {
    private final SigIndex sigIndex;
    private Signature sig = new Signature();
    private LocalityChecker checker;
    private List<AxiomWrapper> module = new ArrayList<AxiomWrapper>();
    private Deque<OWLEntity> workQueue;
    private long nChecks = 0L;
    private long nNonLocal = 0L;
    private boolean noAtomsProcessing = true;

    Modularizer(ModuleMethod moduleMethod) {
        this.checker = LocalityChecker.createLocalityChecker(moduleMethod, this.sig);
        this.sigIndex = new SigIndex(this.checker);
    }

    void addAxiomSig(Stream<OWLEntity> axiomSig) {
        axiomSig.filter(p -> !this.sig.contains((OWLEntity)p)).forEach(p -> {
            this.workQueue.push((OWLEntity)p);
            this.sig.add((OWLEntity)p);
        });
    }

    private void addAxiomToModule(AxiomWrapper axiom) {
        axiom.setInModule(true);
        this.module.add(axiom);
        this.addAxiomSig(axiom.signature());
    }

    private boolean isNonLocal(AxiomWrapper ax) {
        boolean b = !this.checker.local(ax.getAxiom());
        ++this.nChecks;
        if (b) {
            ++this.nNonLocal;
        }
        return b;
    }

    void addNonLocal(AxiomWrapper ax, boolean noCheck) {
        if (noCheck || this.isNonLocal(ax)) {
            this.addAxiomToModule(ax);
            if (this.noAtomsProcessing && ax.getAtom().isPresent()) {
                this.noAtomsProcessing = false;
                this.addNonLocal(ax.getAtom().get().getModule(), true);
                this.noAtomsProcessing = true;
            }
        }
    }

    void addNonLocal(Collection<AxiomWrapper> axSet, boolean noCheck) {
        for (AxiomWrapper q : axSet) {
            if (q.isInModule() || !q.isInSearchSpace()) continue;
            this.addNonLocal(q, noCheck);
        }
    }

    private void extractModuleQueue() {
        OWLAPIStreamUtils.add(this.workQueue, this.sig.getSignature());
        this.addNonLocal(this.sigIndex.getNonLocal(this.sig.topCLocal()), true);
        while (!this.workQueue.isEmpty()) {
            Collection<AxiomWrapper> axioms = this.sigIndex.getAxioms(this.workQueue.pop());
            this.addNonLocal(axioms, false);
        }
    }

    private void extractModule(Collection<AxiomWrapper> list) {
        this.module.clear();
        list.forEach(p -> {
            p.setInModule(false);
            if (p.isUsed()) {
                p.setInSearchSpace(true);
            }
        });
        this.extractModuleQueue();
        list.forEach(p -> p.setInSearchSpace(false));
    }

    public void preprocessOntology(Collection<AxiomWrapper> axioms) {
        this.checker.preprocessOntology(axioms);
        this.sigIndex.clear();
        this.sigIndex.preprocessOntology(axioms);
        this.workQueue = new ArrayDeque<OWLEntity>(axioms.size());
        this.nChecks += (long)(2 * axioms.size());
    }

    void extract(Collection<AxiomWrapper> axioms, Signature signature, ModuleType type) {
        int size;
        boolean topLocality = type == ModuleType.TOP;
        this.sig.setSignature(signature);
        this.sig.setLocality(topLocality);
        this.extractModule(axioms);
        if (type != ModuleType.STAR) {
            return;
        }
        ArrayList<AxiomWrapper> oldModule = new ArrayList<AxiomWrapper>();
        do {
            size = this.module.size();
            oldModule.clear();
            oldModule.addAll(this.module);
            topLocality = !topLocality;
            this.sig.setSignature(signature);
            this.sig.setLocality(topLocality);
            this.extractModule(oldModule);
        } while (size != this.module.size());
    }

    public boolean isTautology(OWLAxiom ax, ModuleType type) {
        boolean topLocality = type == ModuleType.TOP;
        this.sig.setSignature(ax.signature());
        this.sig.setLocality(topLocality);
        boolean toReturn = this.checker.local(ax);
        if (type != ModuleType.STAR || !toReturn) {
            return toReturn;
        }
        this.sig.setLocality(!topLocality);
        return this.checker.local(ax);
    }

    public LocalityChecker getLocalityChecker() {
        return this.checker;
    }

    public Collection<AxiomWrapper> getModule() {
        return this.module;
    }

    long getNChecks() {
        return this.nChecks;
    }

    long getNNonLocal() {
        return this.nNonLocal;
    }
}

