/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.util.AbstractCollector;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.ClassAxiomByClassPointer;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;

public class Internals
implements Serializable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Internals.class);
    private final AddAxiomVisitor addChangeVisitor = new AddAxiomVisitor();
    private final RemoveAxiomVisitor removeChangeVisitor = new RemoveAxiomVisitor();
    private final ReferenceChecker refChecker = new ReferenceChecker();
    private final ReferencedAxiomsCollector refAxiomsCollector = new ReferencedAxiomsCollector();
    protected transient MapPointer<OWLClassExpression, OWLClassAssertionAxiom> classAssertionAxiomsByClass = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.CLASSEXPRESSIONS);
    protected transient MapPointer<OWLAnnotationSubject, OWLAnnotationAssertionAxiom> annotationAssertionAxiomsBySubject = this.buildLazy(AxiomType.ANNOTATION_ASSERTION, InitVisitorFactory.ANNOTSUPERNAMED);
    protected transient MapPointer<OWLClass, OWLSubClassOfAxiom> subClassAxiomsBySubPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUBNAMED);
    protected transient MapPointer<OWLClass, OWLSubClassOfAxiom> subClassAxiomsBySuperPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUPERNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUPERNAMED);
    protected transient MapPointer<OWLDataPropertyExpression, OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
    protected transient MapPointer<OWLDataPropertyExpression, OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUPERNAMED);
    protected transient MapPointer<OWLClass, OWLClassAxiom> classAxiomsByClass = this.buildClassAxiomByClass();
    protected transient MapPointer<OWLClass, OWLEquivalentClassesAxiom> equivalentClassesAxiomsByClass = this.buildLazy(AxiomType.EQUIVALENT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
    protected transient MapPointer<OWLClass, OWLDisjointClassesAxiom> disjointClassesAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
    protected transient MapPointer<OWLClass, OWLDisjointUnionAxiom> disjointUnionAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_UNION, InitVisitorFactory.CLASSCOLLECTIONS);
    protected transient MapPointer<OWLClass, OWLHasKeyAxiom> hasKeyAxiomsByClass = this.buildLazy(AxiomType.HAS_KEY, InitVisitorFactory.CLASSSUPERNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLDisjointObjectPropertiesAxiom> disjointObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLObjectPropertyDomainAxiom> objectPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_DOMAIN, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLObjectPropertyRangeAxiom> objectPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_RANGE, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalPropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSymmetricObjectPropertyAxiom> symmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.SYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLAsymmetricObjectPropertyAxiom> asymmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLReflexiveObjectPropertyAxiom> reflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.REFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLIrreflexiveObjectPropertyAxiom> irreflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLTransitiveObjectPropertyAxiom> transitivePropertyAxiomsByProperty = this.buildLazy(AxiomType.TRANSITIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    protected transient MapPointer<OWLObjectPropertyExpression, OWLInverseObjectPropertiesAxiom> inversePropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
    protected transient MapPointer<OWLDataPropertyExpression, OWLEquivalentDataPropertiesAxiom> equivalentDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
    protected transient MapPointer<OWLDataPropertyExpression, OWLDisjointDataPropertiesAxiom> disjointDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
    protected transient MapPointer<OWLDataPropertyExpression, OWLDataPropertyDomainAxiom> dataPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_DOMAIN, InitVisitorFactory.DPSUBNAMED);
    protected transient MapPointer<OWLDataPropertyExpression, OWLDataPropertyRangeAxiom> dataPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_RANGE, InitVisitorFactory.DPSUBNAMED);
    protected transient MapPointer<OWLDataPropertyExpression, OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
    protected transient MapPointer<OWLIndividual, OWLClassAssertionAxiom> classAssertionAxiomsByIndividual = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    protected transient MapPointer<OWLIndividual, OWLObjectPropertyAssertionAxiom> objectPropertyAssertionsByIndividual = this.buildLazy(AxiomType.OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    protected transient MapPointer<OWLIndividual, OWLDataPropertyAssertionAxiom> dataPropertyAssertionsByIndividual = this.buildLazy(AxiomType.DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    protected transient MapPointer<OWLIndividual, OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    protected transient MapPointer<OWLIndividual, OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    protected transient MapPointer<OWLIndividual, OWLDifferentIndividualsAxiom> differentIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.DIFFERENT_INDIVIDUALS, InitVisitorFactory.ICOLLECTIONS);
    protected transient MapPointer<OWLIndividual, OWLSameIndividualAxiom> sameIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.SAME_INDIVIDUAL, InitVisitorFactory.ICOLLECTIONS);
    protected SetPointer<OWLImportsDeclaration> importsDeclarations = new SetPointer();
    protected SetPointer<OWLAnnotation> ontologyAnnotations = new SetPointer();
    protected SetPointer<OWLClassAxiom> generalClassAxioms = new SetPointer();
    protected SetPointer<OWLSubPropertyChainOfAxiom> propertyChainSubPropertyAxioms = new SetPointer();
    protected transient MapPointer<AxiomType<?>, OWLAxiom> axiomsByType = this.build();
    protected transient MapPointer<OWLClass, OWLAxiom> owlClassReferences = this.build();
    protected transient MapPointer<OWLObjectProperty, OWLAxiom> owlObjectPropertyReferences = this.build();
    protected transient MapPointer<OWLDataProperty, OWLAxiom> owlDataPropertyReferences = this.build();
    protected transient MapPointer<OWLNamedIndividual, OWLAxiom> owlIndividualReferences = this.build();
    protected transient MapPointer<OWLAnonymousIndividual, OWLAxiom> owlAnonymousIndividualReferences = this.build();
    protected transient MapPointer<OWLDatatype, OWLAxiom> owlDatatypeReferences = this.build();
    protected transient MapPointer<OWLAnnotationProperty, OWLAxiom> owlAnnotationPropertyReferences = this.build();
    protected transient MapPointer<OWLEntity, OWLDeclarationAxiom> declarationsByEntity = this.build();
    @Nullable
    private List<OWLAxiom> axiomsForSerialization;

    public static <K, V extends OWLAxiom> boolean contains(MapPointer<K, V> p, K k, V v) {
        return p.contains(k, v);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.axiomsByType = this.build();
        this.owlClassReferences = this.build();
        this.owlObjectPropertyReferences = this.build();
        this.owlDataPropertyReferences = this.build();
        this.owlIndividualReferences = this.build();
        this.owlAnonymousIndividualReferences = this.build();
        this.owlDatatypeReferences = this.build();
        this.owlAnnotationPropertyReferences = this.build();
        this.declarationsByEntity = this.build();
        this.classAssertionAxiomsByClass = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.CLASSEXPRESSIONS);
        this.annotationAssertionAxiomsBySubject = this.buildLazy(AxiomType.ANNOTATION_ASSERTION, InitVisitorFactory.ANNOTSUPERNAMED);
        this.subClassAxiomsBySubPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUBNAMED);
        this.subClassAxiomsBySuperPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUPERNAMED);
        this.objectSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.objectSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUPERNAMED);
        this.dataSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
        this.dataSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUPERNAMED);
        this.classAxiomsByClass = this.buildClassAxiomByClass();
        this.equivalentClassesAxiomsByClass = this.buildLazy(AxiomType.EQUIVALENT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
        this.disjointClassesAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
        this.disjointUnionAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_UNION, InitVisitorFactory.CLASSCOLLECTIONS);
        this.hasKeyAxiomsByClass = this.buildLazy(AxiomType.HAS_KEY, InitVisitorFactory.CLASSSUPERNAMED);
        this.equivalentObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
        this.disjointObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
        this.objectPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_DOMAIN, InitVisitorFactory.OPSUBNAMED);
        this.objectPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_RANGE, InitVisitorFactory.OPSUBNAMED);
        this.functionalObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.inverseFunctionalPropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.symmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.SYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.asymmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.reflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.REFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.irreflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.transitivePropertyAxiomsByProperty = this.buildLazy(AxiomType.TRANSITIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.inversePropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
        this.equivalentDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
        this.disjointDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
        this.dataPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_DOMAIN, InitVisitorFactory.DPSUBNAMED);
        this.dataPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_RANGE, InitVisitorFactory.DPSUBNAMED);
        this.functionalDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
        this.classAssertionAxiomsByIndividual = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.objectPropertyAssertionsByIndividual = this.buildLazy(AxiomType.OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.dataPropertyAssertionsByIndividual = this.buildLazy(AxiomType.DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.negativeObjectPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.negativeDataPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.differentIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.DIFFERENT_INDIVIDUALS, InitVisitorFactory.ICOLLECTIONS);
        this.sameIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.SAME_INDIVIDUAL, InitVisitorFactory.ICOLLECTIONS);
        this.axiomsForSerialization.forEach(this::addAxiom);
        this.axiomsForSerialization = null;
    }

    public boolean anyEntities(EntityType<?> type) {
        if (EntityType.CLASS.equals(type)) {
            return !this.owlClassReferences.isEmpty();
        }
        if (EntityType.DATA_PROPERTY.equals(type)) {
            return !this.owlDataPropertyReferences.isEmpty();
        }
        if (EntityType.OBJECT_PROPERTY.equals(type)) {
            return !this.owlObjectPropertyReferences.isEmpty();
        }
        if (EntityType.ANNOTATION_PROPERTY.equals(type)) {
            return !this.owlAnnotationPropertyReferences.isEmpty();
        }
        if (EntityType.DATATYPE.equals(type)) {
            return !this.owlDatatypeReferences.isEmpty();
        }
        if (EntityType.NAMED_INDIVIDUAL.equals(type)) {
            return !this.owlIndividualReferences.isEmpty();
        }
        return false;
    }

    public void trimToSize() {
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.axiomsForSerialization = OWLAPIStreamUtils.asList(this.axiomsByType.getAllValues());
        stream.defaultWriteObject();
    }

    public boolean containsClassInSignature(IRI i) {
        return this.owlClassReferences.containsReference(i);
    }

    public boolean containsObjectPropertyInSignature(IRI i) {
        return this.owlObjectPropertyReferences.containsReference(i);
    }

    public boolean containsDataPropertyInSignature(IRI i) {
        return this.owlDataPropertyReferences.containsReference(i);
    }

    public boolean containsAnnotationPropertyInSignature(IRI i) {
        return this.owlAnnotationPropertyReferences.containsReference(i);
    }

    public boolean containsIndividualInSignature(IRI i) {
        return this.owlIndividualReferences.containsReference(i);
    }

    public boolean containsDatatypeInSignature(IRI i) {
        return this.owlDatatypeReferences.containsReference(i);
    }

    public boolean containsClassInSignature(OWLClass i) {
        return this.owlClassReferences.containsReference(i);
    }

    public boolean containsObjectPropertyInSignature(OWLObjectProperty i) {
        return this.owlObjectPropertyReferences.containsReference(i);
    }

    public boolean containsDataPropertyInSignature(OWLDataProperty i) {
        return this.owlDataPropertyReferences.containsReference(i);
    }

    public boolean containsAnnotationPropertyInSignature(OWLAnnotationProperty i) {
        return this.owlAnnotationPropertyReferences.containsReference(i);
    }

    public boolean containsIndividualInSignature(OWLNamedIndividual i) {
        return this.owlIndividualReferences.containsReference(i);
    }

    public boolean containsDatatypeInSignature(OWLDatatype i) {
        return this.owlDatatypeReferences.containsReference(i);
    }

    <T extends OWLObject, A extends OWLAxiom> Optional<MapPointer<T, A>> get(Class<T> type, Class<A> axiom) {
        return this.get(type, axiom, Navigation.IN_SUB_POSITION);
    }

    <T extends OWLObject, A extends OWLAxiom> Optional<MapPointer<T, A>> get(Class<T> type, Class<A> axiom, Navigation position) {
        if (OWLEntity.class.isAssignableFrom(type) && axiom.equals(OWLDeclarationAxiom.class)) {
            return OWLAPIPreconditions.optional(this.declarationsByEntity);
        }
        if (type.equals(OWLClass.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlClassReferences);
        }
        if (type.equals(OWLObjectProperty.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlObjectPropertyReferences);
        }
        if (type.equals(OWLDataProperty.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlDataPropertyReferences);
        }
        if (type.equals(OWLNamedIndividual.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlIndividualReferences);
        }
        if (type.equals(OWLAnonymousIndividual.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlAnonymousIndividualReferences);
        }
        if (type.equals(OWLDatatype.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlDatatypeReferences);
        }
        if (type.equals(OWLAnnotationProperty.class) && axiom.equals(OWLAxiom.class)) {
            return OWLAPIPreconditions.optional(this.owlAnnotationPropertyReferences);
        }
        if (type.equals(OWLClassExpression.class)) {
            return OWLAPIPreconditions.optional(this.classAssertionAxiomsByClass);
        }
        if (type.equals(OWLObjectPropertyExpression.class)) {
            if (axiom.equals(OWLSubObjectPropertyOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return OWLAPIPreconditions.optional(this.objectSubPropertyAxiomsBySuperPosition);
                }
                return OWLAPIPreconditions.optional(this.objectSubPropertyAxiomsBySubPosition);
            }
            if (axiom.equals(OWLEquivalentObjectPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.equivalentObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDisjointObjectPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLObjectPropertyDomainAxiom.class)) {
                return OWLAPIPreconditions.optional(this.objectPropertyDomainAxiomsByProperty);
            }
            if (axiom.equals(OWLObjectPropertyRangeAxiom.class)) {
                return OWLAPIPreconditions.optional(this.objectPropertyRangeAxiomsByProperty);
            }
            if (axiom.equals(OWLFunctionalObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.functionalObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLInverseFunctionalObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.inverseFunctionalPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLSymmetricObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.symmetricPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLAsymmetricObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.asymmetricPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLReflexiveObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.reflexivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLIrreflexiveObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.irreflexivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLTransitiveObjectPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.transitivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLInverseObjectPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.inversePropertyAxiomsByProperty);
            }
        }
        if (type.equals(OWLDataPropertyExpression.class)) {
            if (axiom.equals(OWLSubDataPropertyOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return OWLAPIPreconditions.optional(this.dataSubPropertyAxiomsBySuperPosition);
                }
                return OWLAPIPreconditions.optional(this.dataSubPropertyAxiomsBySubPosition);
            }
            if (axiom.equals(OWLEquivalentDataPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.equivalentDataPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDisjointDataPropertiesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointDataPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDataPropertyDomainAxiom.class)) {
                return OWLAPIPreconditions.optional(this.dataPropertyDomainAxiomsByProperty);
            }
            if (axiom.equals(OWLDataPropertyRangeAxiom.class)) {
                return OWLAPIPreconditions.optional(this.dataPropertyRangeAxiomsByProperty);
            }
            if (axiom.equals(OWLFunctionalDataPropertyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.functionalDataPropertyAxiomsByProperty);
            }
        }
        if (type.equals(OWLAnnotationSubject.class) || type.equals(IRI.class)) {
            return OWLAPIPreconditions.optional(this.annotationAssertionAxiomsBySubject);
        }
        if (type.equals(OWLIndividual.class)) {
            if (axiom.equals(OWLClassAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.classAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLObjectPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.objectPropertyAssertionsByIndividual);
            }
            if (axiom.equals(OWLDataPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.dataPropertyAssertionsByIndividual);
            }
            if (axiom.equals(OWLNegativeObjectPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.negativeObjectPropertyAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLNegativeDataPropertyAssertionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.negativeDataPropertyAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLDifferentIndividualsAxiom.class)) {
                return OWLAPIPreconditions.optional(this.differentIndividualsAxiomsByIndividual);
            }
            if (axiom.equals(OWLSameIndividualAxiom.class)) {
                return OWLAPIPreconditions.optional(this.sameIndividualsAxiomsByIndividual);
            }
        }
        if (type.equals(OWLClass.class)) {
            if (axiom.equals(OWLSubClassOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return OWLAPIPreconditions.optional(this.subClassAxiomsBySuperPosition);
                }
                return OWLAPIPreconditions.optional(this.subClassAxiomsBySubPosition);
            }
            if (axiom.equals(OWLClassAxiom.class)) {
                return OWLAPIPreconditions.optional(this.classAxiomsByClass);
            }
            if (axiom.equals(OWLEquivalentClassesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.equivalentClassesAxiomsByClass);
            }
            if (axiom.equals(OWLDisjointClassesAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointClassesAxiomsByClass);
            }
            if (axiom.equals(OWLDisjointUnionAxiom.class)) {
                return OWLAPIPreconditions.optional(this.disjointUnionAxiomsByClass);
            }
            if (axiom.equals(OWLHasKeyAxiom.class)) {
                return OWLAPIPreconditions.optional(this.hasKeyAxiomsByClass);
            }
        }
        return OWLAPIPreconditions.emptyOptional();
    }

    protected <K, V extends OWLAxiom> MapPointer<K, V> build() {
        return this.build(null, null);
    }

    protected <K, V extends OWLAxiom> MapPointer<K, V> buildLazy(AxiomType<?> t, OWLAxiomVisitorEx<?> v) {
        return new MapPointer(t, v, false, this);
    }

    protected ClassAxiomByClassPointer buildClassAxiomByClass() {
        return new ClassAxiomByClassPointer(null, null, false, this);
    }

    protected <K, V extends OWLAxiom> MapPointer<K, V> build(@Nullable AxiomType<?> t, @Nullable OWLAxiomVisitorEx<?> v) {
        return new MapPointer(t, v, true, this);
    }

    public boolean addAxiom(final OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        if (this.getAxiomsByType().put(axiom.getAxiomType(), axiom)) {
            axiom.accept(this.addChangeVisitor);
            AbstractCollector referenceAdder = new AbstractCollector(){

                @Override
                public void visit(OWLClass ce) {
                    Internals.this.owlClassReferences.put(ce, axiom);
                }

                @Override
                public void visit(OWLObjectProperty property) {
                    Internals.this.owlObjectPropertyReferences.put(property, axiom);
                }

                @Override
                public void visit(OWLDataProperty property) {
                    Internals.this.owlDataPropertyReferences.put(property, axiom);
                }

                @Override
                public void visit(OWLNamedIndividual individual) {
                    Internals.this.owlIndividualReferences.put(individual, axiom);
                }

                @Override
                public void visit(OWLAnnotationProperty property) {
                    Internals.this.owlAnnotationPropertyReferences.put(property, axiom);
                }

                @Override
                public void visit(OWLDatatype node) {
                    Internals.this.owlDatatypeReferences.put(node, axiom);
                }

                @Override
                public void visit(OWLAnonymousIndividual individual) {
                    Internals.this.owlAnonymousIndividualReferences.put(individual, axiom);
                }
            };
            axiom.accept(referenceAdder);
            return true;
        }
        return false;
    }

    public boolean removeAxiom(final OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        if (this.getAxiomsByType().remove(axiom.getAxiomType(), axiom)) {
            axiom.accept(this.removeChangeVisitor);
            AbstractCollector referenceRemover = new AbstractCollector(){

                @Override
                public void visit(OWLClass ce) {
                    Internals.this.owlClassReferences.remove(ce, axiom);
                }

                @Override
                public void visit(OWLObjectProperty property) {
                    Internals.this.owlObjectPropertyReferences.remove(property, axiom);
                }

                @Override
                public void visit(OWLDataProperty property) {
                    Internals.this.owlDataPropertyReferences.remove(property, axiom);
                }

                @Override
                public void visit(OWLNamedIndividual individual) {
                    Internals.this.owlIndividualReferences.remove(individual, axiom);
                }

                @Override
                public void visit(OWLAnnotationProperty property) {
                    Internals.this.owlAnnotationPropertyReferences.remove(property, axiom);
                }

                @Override
                public void visit(OWLDatatype node) {
                    Internals.this.owlDatatypeReferences.remove(node, axiom);
                }

                @Override
                public void visit(OWLAnonymousIndividual individual) {
                    Internals.this.owlAnonymousIndividualReferences.remove(individual, axiom);
                }
            };
            axiom.accept(referenceRemover);
            return true;
        }
        return false;
    }

    public boolean isDeclared(OWLEntity e) {
        return this.declarationsByEntity.containsKey(e);
    }

    public boolean isEmpty() {
        return this.axiomsByType.isEmpty() && this.ontologyAnnotations.isEmpty();
    }

    public <K> Collection<? extends OWLAxiom> filterAxioms(OWLAxiomSearchFilter filter, K key) {
        Optional<MapPointer<OWLAnnotationSubject, OWLAnnotationAssertionAxiom>> mapPointerOptional;
        if (filter == Filters.annotations && (mapPointerOptional = this.get(OWLAnnotationSubject.class, OWLAnnotationAssertionAxiom.class)).isPresent()) {
            return mapPointerOptional.get().getValuesAsCollection((OWLAnnotationSubject)key);
        }
        return this.getAxiomsByType().filterAxioms(filter, key);
    }

    public <K> boolean contains(OWLAxiomSearchFilter filter, K key) {
        MapPointer<AxiomType<?>, OWLAxiom> types = this.getAxiomsByType();
        for (AxiomType<?> at : filter.getAxiomTypes()) {
            if (!types.matchOnValues(at, t -> filter.pass((OWLAxiom)t, key))) continue;
            return true;
        }
        return false;
    }

    public Stream<OWLImportsDeclaration> getImportsDeclarations() {
        return this.importsDeclarations.stream();
    }

    public boolean addImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        return this.importsDeclarations.add(importDeclaration);
    }

    public boolean removeImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        return this.importsDeclarations.remove(importDeclaration);
    }

    Stream<OWLAnnotation> getOntologyAnnotations() {
        return this.ontologyAnnotations.stream();
    }

    public boolean addOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.add(ann);
    }

    public boolean removeOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.remove(ann);
    }

    public int getAxiomCount() {
        return this.axiomsByType.size();
    }

    public Stream<OWLAxiom> getAxioms() {
        return this.axiomsByType.getAllValues();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        if (!this.axiomsByType.isInitialized()) {
            return 0;
        }
        return this.axiomsByType.countValues(axiomType);
    }

    public Stream<OWLLogicalAxiom> getLogicalAxioms() {
        return AxiomType.LOGICAL_AXIOM_TYPES.stream().map(type -> this.axiomsByType.values((AxiomType<?>)type, OWLLogicalAxiom.class)).flatMap(x -> x);
    }

    public int getLogicalAxiomCount() {
        int count = 0;
        for (AxiomType<?> type : AxiomType.LOGICAL_AXIOM_TYPES) {
            count += this.axiomsByType.countValues(type);
        }
        return count;
    }

    public Stream<OWLClassAxiom> getGeneralClassAxioms() {
        return this.generalClassAxioms.stream().sorted();
    }

    public boolean addGeneralClassAxioms(OWLClassAxiom ax) {
        return this.generalClassAxioms.add(ax);
    }

    public boolean removeGeneralClassAxioms(OWLClassAxiom ax) {
        return this.generalClassAxioms.remove(ax);
    }

    public boolean addPropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        return this.propertyChainSubPropertyAxioms.add(ax);
    }

    public boolean removePropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        return this.propertyChainSubPropertyAxioms.remove(ax);
    }

    public MapPointer<AxiomType<?>, OWLAxiom> getAxiomsByType() {
        return this.axiomsByType;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Internals{(first 20 axioms) ");
        this.axiomsByType.getAllValues().limit(20L).forEach(a -> b.append(a).append('\n'));
        b.append('}');
        return b.toString();
    }

    public boolean containsReference(OWLEntity entity) {
        return entity.accept(this.refChecker);
    }

    public Stream<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        return owlEntity.accept(this.refAxiomsCollector);
    }

    private class ReferencedAxiomsCollector
    implements OWLEntityVisitorEx<Stream<OWLAxiom>>,
    Serializable {
        ReferencedAxiomsCollector() {
        }

        @Override
        public Stream<OWLAxiom> visit(OWLClass cls) {
            return Internals.this.owlClassReferences.values(cls, OWLAxiom.class);
        }

        @Override
        public Stream<OWLAxiom> visit(OWLObjectProperty property) {
            return Internals.this.owlObjectPropertyReferences.values(property, OWLAxiom.class);
        }

        @Override
        public Stream<OWLAxiom> visit(OWLDataProperty property) {
            return Internals.this.owlDataPropertyReferences.values(property, OWLAxiom.class);
        }

        @Override
        public Stream<OWLAxiom> visit(OWLNamedIndividual individual) {
            return Internals.this.owlIndividualReferences.values(individual, OWLAxiom.class);
        }

        @Override
        public Stream<OWLAxiom> visit(OWLDatatype datatype) {
            return Internals.this.owlDatatypeReferences.values(datatype, OWLAxiom.class);
        }

        @Override
        public Stream<OWLAxiom> visit(OWLAnnotationProperty property) {
            return Internals.this.owlAnnotationPropertyReferences.values(property, OWLAxiom.class);
        }
    }

    class RemoveAxiomVisitor
    implements OWLAxiomVisitor,
    Serializable {
        RemoveAxiomVisitor() {
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                Internals.this.subClassAxiomsBySubPosition.remove(subClass, axiom);
                Internals.this.classAxiomsByClass.remove(subClass, axiom);
            } else {
                Internals.this.removeGeneralClassAxioms(axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                Internals.this.subClassAxiomsBySuperPosition.remove(axiom.getSuperClass().asOWLClass(), axiom);
            }
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            Internals.this.negativeObjectPropertyAssertionAxiomsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            Internals.this.asymmetricPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            Internals.this.reflexivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(c -> !c.isAnonymous()).map(AsOWLClass::asOWLClass).forEach(c -> {
                Internals.this.disjointClassesAxiomsByClass.remove((OWLClass)c, axiom);
                Internals.this.classAxiomsByClass.remove((OWLClass)c, axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.removeGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            Internals.this.dataPropertyDomainAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
                Internals.this.objectPropertyDomainAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentObjectPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            Internals.this.inversePropertyAxiomsByProperty.remove(axiom.getFirstProperty(), axiom);
            Internals.this.inversePropertyAxiomsByProperty.remove(axiom.getSecondProperty(), axiom);
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            Internals.this.negativeDataPropertyAssertionAxiomsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            axiom.individuals().forEach(i -> Internals.this.differentIndividualsAxiomsByIndividual.remove((OWLIndividual)i, axiom));
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointDataPropertyAxiomsByProperty.remove((OWLDataPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointObjectPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            Internals.this.objectPropertyRangeAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            Internals.this.objectPropertyAssertionsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            Internals.this.functionalObjectPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            Internals.this.objectSubPropertyAxiomsBySubPosition.remove((OWLObjectPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.objectSubPropertyAxiomsBySuperPosition.remove((OWLObjectPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            Internals.this.disjointUnionAxiomsByClass.remove(axiom.getOWLClass(), axiom);
            Internals.this.classAxiomsByClass.remove(axiom.getOWLClass(), axiom);
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
            Internals.this.declarationsByEntity.remove(axiom.getEntity(), axiom);
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
            Internals.this.annotationAssertionAxiomsBySubject.remove((OWLAnnotationSubject)axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.hasKeyAxiomsByClass.remove(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            Internals.this.symmetricPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            Internals.this.dataPropertyRangeAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            Internals.this.functionalDataPropertyAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentDataPropertyAxiomsByProperty.remove((OWLDataPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            Internals.this.classAssertionAxiomsByIndividual.remove(axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.classAssertionAxiomsByClass.remove(axiom.getClassExpression(), axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(c -> !c.isAnonymous()).map(AsOWLClass::asOWLClass).forEach(c -> {
                Internals.this.equivalentClassesAxiomsByClass.remove((OWLClass)c, axiom);
                Internals.this.classAxiomsByClass.remove((OWLClass)c, axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.removeGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            Internals.this.dataPropertyAssertionsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            Internals.this.transitivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            Internals.this.irreflexivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            Internals.this.dataSubPropertyAxiomsBySubPosition.remove((OWLDataPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.dataSubPropertyAxiomsBySuperPosition.remove((OWLDataPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            Internals.this.inverseFunctionalPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            axiom.individuals().forEach(i -> Internals.this.sameIndividualsAxiomsByIndividual.remove((OWLIndividual)i, axiom));
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            Internals.this.removePropertyChainSubPropertyAxioms(axiom);
        }
    }

    class AddAxiomVisitor
    implements OWLAxiomVisitor,
    Serializable {
        AddAxiomVisitor() {
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                Internals.this.subClassAxiomsBySubPosition.put(subClass, axiom);
                Internals.this.classAxiomsByClass.put(subClass, axiom);
            } else {
                Internals.this.addGeneralClassAxioms(axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                Internals.this.subClassAxiomsBySuperPosition.put((OWLClass)axiom.getSuperClass(), axiom);
            }
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            Internals.this.negativeObjectPropertyAssertionAxiomsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            Internals.this.asymmetricPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            Internals.this.reflexivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(d -> !d.isAnonymous()).forEach(desc -> {
                OWLClass cls = (OWLClass)desc;
                Internals.this.disjointClassesAxiomsByClass.put(cls, axiom);
                Internals.this.classAxiomsByClass.put(cls, axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.addGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            Internals.this.dataPropertyDomainAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
                Internals.this.objectPropertyDomainAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentObjectPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            Internals.this.inversePropertyAxiomsByProperty.put(axiom.getFirstProperty(), axiom);
            Internals.this.inversePropertyAxiomsByProperty.put(axiom.getSecondProperty(), axiom);
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            Internals.this.negativeDataPropertyAssertionAxiomsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            axiom.individuals().forEach(ind -> Internals.this.differentIndividualsAxiomsByIndividual.put((OWLIndividual)ind, axiom));
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointDataPropertyAxiomsByProperty.put((OWLDataPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.disjointObjectPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            Internals.this.objectPropertyRangeAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            Internals.this.objectPropertyAssertionsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            Internals.this.functionalObjectPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            Internals.this.objectSubPropertyAxiomsBySubPosition.put((OWLObjectPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.objectSubPropertyAxiomsBySuperPosition.put((OWLObjectPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            Internals.this.disjointUnionAxiomsByClass.put(axiom.getOWLClass(), axiom);
            Internals.this.classAxiomsByClass.put(axiom.getOWLClass(), axiom);
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
            Internals.this.declarationsByEntity.put(axiom.getEntity(), axiom);
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
            Internals.this.annotationAssertionAxiomsBySubject.put((OWLAnnotationSubject)axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.hasKeyAxiomsByClass.put(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            Internals.this.symmetricPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            Internals.this.dataPropertyRangeAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            Internals.this.functionalDataPropertyAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            axiom.properties().forEach(p -> Internals.this.equivalentDataPropertyAxiomsByProperty.put((OWLDataPropertyExpression)p, axiom));
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            Internals.this.classAssertionAxiomsByIndividual.put(axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.classAssertionAxiomsByClass.put(axiom.getClassExpression(), axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            AtomicBoolean allAnon = new AtomicBoolean(true);
            axiom.classExpressions().filter(d -> !d.isAnonymous()).forEach(desc -> {
                Internals.this.equivalentClassesAxiomsByClass.put((OWLClass)desc, axiom);
                Internals.this.classAxiomsByClass.put((OWLClass)desc, axiom);
                allAnon.set(false);
            });
            if (allAnon.get()) {
                Internals.this.addGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            Internals.this.dataPropertyAssertionsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            Internals.this.transitivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            Internals.this.irreflexivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            Internals.this.dataSubPropertyAxiomsBySubPosition.put((OWLDataPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.dataSubPropertyAxiomsBySuperPosition.put((OWLDataPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            Internals.this.inverseFunctionalPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            axiom.individuals().forEach(i -> Internals.this.sameIndividualsAxiomsByIndividual.put((OWLIndividual)i, axiom));
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            Internals.this.addPropertyChainSubPropertyAxioms(axiom);
        }
    }

    protected class SetPointer<K extends Serializable>
    implements Serializable {
        private final Set<K> set = CollectionFactory.createSyncSet();

        protected SetPointer() {
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public boolean add(K k) {
            return this.set.add(k);
        }

        public boolean remove(K k) {
            return this.set.remove(k);
        }

        public Stream<K> stream() {
            if (this.set.isEmpty()) {
                return Stream.empty();
            }
            ArrayList<K> toReturn = new ArrayList<K>(this.set);
            try {
                toReturn.sort(null);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Misbehaving triple comparator, leaving triples unsorted", (Throwable)e);
            }
            return toReturn.stream();
        }
    }

    private class ReferenceChecker
    implements OWLEntityVisitorEx<Boolean>,
    Serializable {
        ReferenceChecker() {
        }

        @Override
        public Boolean visit(OWLClass cls) {
            return Internals.this.owlClassReferences.containsKey(cls);
        }

        @Override
        public Boolean visit(OWLObjectProperty property) {
            return Internals.this.owlObjectPropertyReferences.containsKey(property);
        }

        @Override
        public Boolean visit(OWLDataProperty property) {
            return Internals.this.owlDataPropertyReferences.containsKey(property);
        }

        @Override
        public Boolean visit(OWLNamedIndividual individual) {
            return Internals.this.owlIndividualReferences.containsKey(individual);
        }

        @Override
        public Boolean visit(OWLDatatype datatype) {
            return Internals.this.owlDatatypeReferences.containsKey(datatype);
        }

        @Override
        public Boolean visit(OWLAnnotationProperty property) {
            return Internals.this.owlAnnotationPropertyReferences.containsKey(property);
        }
    }
}

