/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.PriorityCollection;
import uk.ac.manchester.cs.AcceptHeaderBuilder;

public class OWLOntologyFactoryImpl
implements OWLOntologyFactory {
    private final Set<String> parsableSchemes = Sets.newHashSet((Object[])new String[]{"http", "https", "file", "ftp", "jar"});
    private final OWLOntologyBuilder ontologyBuilder;

    @Inject
    public OWLOntologyFactoryImpl(OWLOntologyBuilder ontologyBuilder) {
        this.ontologyBuilder = OWLAPIPreconditions.verifyNotNull(ontologyBuilder);
    }

    private static PriorityCollection<OWLParserFactory> getParsers(OWLOntologyDocumentSource documentSource, PriorityCollection<OWLParserFactory> parsers) {
        if (parsers.isEmpty()) {
            return parsers;
        }
        Optional<OWLDocumentFormat> format = documentSource.getFormat();
        Optional<String> mimeType = documentSource.getMIMEType();
        if (!format.isPresent() && !mimeType.isPresent()) {
            return parsers;
        }
        PriorityCollection<OWLParserFactory> candidateParsers = parsers;
        if (format.isPresent()) {
            candidateParsers = OWLOntologyFactoryImpl.getParsersByFormat(format.get(), parsers);
        }
        if (candidateParsers.isEmpty() && mimeType.isPresent()) {
            candidateParsers = OWLOntologyFactoryImpl.getParserCandidatesByMIME(mimeType.get(), parsers);
        }
        if (candidateParsers.isEmpty()) {
            return parsers;
        }
        return candidateParsers;
    }

    private static PriorityCollection<OWLParserFactory> getParsersByFormat(OWLDocumentFormat format, PriorityCollection<OWLParserFactory> parsers) {
        PriorityCollection<OWLParserFactory> candidateParsers = new PriorityCollection<OWLParserFactory>(PriorityCollectionSorting.NEVER);
        for (OWLParserFactory parser : parsers) {
            if (!parser.getSupportedFormat().getKey().equals(format.getKey())) continue;
            candidateParsers.add(parser);
        }
        return candidateParsers;
    }

    private static PriorityCollection<OWLParserFactory> getParserCandidatesByMIME(String mimeType, PriorityCollection<OWLParserFactory> parsers) {
        return parsers.getByMIMEType(mimeType);
    }

    @Override
    public boolean canCreateFromDocumentIRI(IRI documentIRI) {
        return true;
    }

    @Override
    public boolean canAttemptLoading(OWLOntologyDocumentSource source) {
        return !source.hasAlredyFailedOnStreams() || !source.hasAlredyFailedOnIRIResolution() && this.parsableSchemes.contains(source.getDocumentIRI().getScheme());
    }

    @Override
    public OWLOntology createOWLOntology(OWLOntologyManager manager, OWLOntologyID ontologyID, IRI documentIRI, OWLOntologyFactory.OWLOntologyCreationHandler handler) {
        OWLOntology ont = this.ontologyBuilder.createOWLOntology(manager, ontologyID);
        handler.ontologyCreated(ont);
        handler.setOntologyFormat(ont, new RDFXMLDocumentFormat());
        return ont;
    }

    @Override
    public OWLOntology loadOWLOntology(OWLOntologyManager manager, OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler handler, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        LinkedHashMap<OWLParser, OWLParserException> exceptions = new LinkedHashMap<OWLParser, OWLParserException>();
        OWLOntology existingOntology = null;
        IRI iri = documentSource.getDocumentIRI();
        if (manager.contains(iri)) {
            existingOntology = manager.getOntology(iri);
        }
        OWLOntologyID ontologyID = new OWLOntologyID();
        OWLOntology ont = this.createOWLOntology(manager, ontologyID, documentSource.getDocumentIRI(), handler);
        HashSet bannedParsers = Sets.newHashSet((Object[])configuration.getBannedParsers().split(" "));
        PriorityCollection<OWLParserFactory> parsers = OWLOntologyFactoryImpl.getParsers(documentSource, manager.getOntologyParsers());
        if (documentSource.getAcceptHeaders().isPresent()) {
            documentSource.setAcceptHeaders(AcceptHeaderBuilder.headersFromParsers(parsers));
        }
        for (OWLParserFactory parserFactory : parsers) {
            if (bannedParsers.contains(parserFactory.getClass().getName())) continue;
            OWLParser parser = parserFactory.createParser();
            try {
                if (existingOntology == null && !ont.isEmpty()) {
                    manager.removeOntology(ont);
                    ont = this.createOWLOntology(manager, ontologyID, documentSource.getDocumentIRI(), handler);
                }
                OWLDocumentFormat format = parser.parse(documentSource, ont, configuration);
                handler.setOntologyFormat(ont, format);
                return ont;
            }
            catch (UnloadableImportException e) {
                manager.removeOntology(ont);
                throw e;
            }
            catch (OWLParserException e) {
                if (e.getCause() instanceof IOException || e.getCause() instanceof OWLOntologyInputSourceException) {
                    manager.removeOntology(ont);
                    throw new OWLOntologyCreationIOException(e.getCause());
                }
                exceptions.put(parser, e);
            }
            catch (RuntimeException e) {
                exceptions.put(parser, new OWLParserException(e));
                manager.removeOntology(ont);
                throw e;
            }
        }
        if (existingOntology == null) {
            manager.removeOntology(ont);
        }
        throw new UnparsableOntologyException(documentSource.getDocumentIRI(), exceptions, configuration);
    }
}

