/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.turtle.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.rdf.turtle.parser.JavaCharStream;
import org.semanticweb.owlapi.rdf.turtle.parser.ParseException;
import org.semanticweb.owlapi.rdf.turtle.parser.Provider;
import org.semanticweb.owlapi.rdf.turtle.parser.StreamProvider;
import org.semanticweb.owlapi.rdf.turtle.parser.StringProvider;
import org.semanticweb.owlapi.rdf.turtle.parser.Token;
import org.semanticweb.owlapi.rdf.turtle.parser.TokenMgrException;
import org.semanticweb.owlapi.rdf.turtle.parser.TripleHandler;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParserConstants;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParserTokenManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class TurtleParser
implements TurtleParserConstants {
    private Map<String, IRI> string2IRI;
    private IRI base;
    private TripleHandler handler;
    private PrefixManager pm = new DefaultPrefixManager();
    public TurtleParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[21];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private int trace_indent = 0;
    private boolean trace_enabled;

    public TurtleParser(Reader reader, TripleHandler handler, IRI base) throws IOException {
        this(new StreamProvider(reader));
        this.handler = handler;
        this.base = base;
        this.string2IRI = new HashMap<String, IRI>();
        this.pm.setDefaultPrefix("http://www.semanticweb.org/owl/owlapi/turtle#");
    }

    public TurtleParser(InputStream is, TripleHandler handler, IRI base) throws IOException {
        this(new StreamProvider(is));
        this.handler = handler;
        this.base = base;
        this.string2IRI = new HashMap<String, IRI>();
        this.pm.setDefaultPrefix("http://www.semanticweb.org/owl/owlapi/turtle#");
    }

    public PrefixManager getPrefixManager() {
        return this.pm;
    }

    public void setTripleHandler(TripleHandler handler) {
        this.handler = handler;
    }

    protected IRI getNextBlankNode(String id) {
        String string = id == null ? NodeID.nextAnonymousIRI() : (NodeID.isAnonymousNodeID(id) ? id : NodeID.getIRIFromNodeID(id));
        IRI iri = this.string2IRI.get(string);
        if (iri == null) {
            iri = IRI.create(string);
            this.string2IRI.put(string, iri);
        }
        return iri;
    }

    protected IRI getIRIFromQName(String qname) throws ParseException {
        int colonIndex = qname.indexOf(58);
        if (colonIndex == -1) {
            throw new ParseException("Not a valid qname (missing ':') " + qname);
        }
        String prefix = qname.substring(0, colonIndex + 1);
        if (prefix.equals("_:")) {
            return this.getIRI("genid" + qname.substring(colonIndex + 1));
        }
        if (!this.pm.containsPrefixMapping(prefix)) {
            throw new ParseException("Prefix not declared: " + prefix);
        }
        return this.pm.getIRI(qname);
    }

    public IRI getIRI(String s) {
        IRI iri;
        if (s.charAt(0) == '<') {
            s = s.substring(1, s.length() - 1);
        }
        if ((iri = this.string2IRI.get(s)) == null) {
            iri = IRI.create(s);
            if (!iri.isAbsolute()) {
                iri = IRI.create(this.base.getNamespace().substring(0, this.base.getNamespace().lastIndexOf(47) + 1), s);
            }
            this.string2IRI.put(s, iri);
        }
        return iri;
    }

    public final void parseDocument() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 34: 
                case 36: {
                    this.parseDirective();
                    this.jj_consume_token(32);
                    break;
                }
                case 27: 
                case 29: 
                case 39: 
                case 47: 
                case 48: 
                case 50: 
                case 55: {
                    this.parseStatement();
                    this.jj_consume_token(32);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 29: 
                case 34: 
                case 36: 
                case 39: 
                case 47: 
                case 48: 
                case 50: 
                case 55: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(0);
        this.handler.handleEnd();
    }

    public final void parseDirective() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 34: {
                this.parsePrefixDirective();
                break;
            }
            case 36: {
                this.parseBaseDirective();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void parsePrefixDirective() throws ParseException {
        this.jj_consume_token(34);
        Token t = this.jj_consume_token(48);
        IRI ns = this.parseIRI();
        this.pm.setPrefix(t.image, ns.toString());
        this.handler.handlePrefixDirective(t.image, ns.toString());
    }

    public final void parseBaseDirective() throws ParseException {
        this.jj_consume_token(36);
        Token t = this.jj_consume_token(47);
        this.base = IRI.create(t.image.substring(1, t.image.length() - 1));
        this.handler.handleBaseDirective(this.base);
    }

    public final void parseStatement() throws ParseException {
        this.parseTriples();
    }

    public final void parseTriples() throws ParseException {
        IRI subject = this.parseSubject();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 47: 
            case 48: 
            case 50: {
                this.parsePredicateObjectList(subject);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
    }

    public final IRI parseSubject() throws ParseException {
        IRI iri;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 47: 
            case 48: 
            case 50: {
                iri = this.parseResource();
                break;
            }
            case 27: 
            case 29: 
            case 39: 
            case 55: {
                iri = this.parseBlankNode();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return iri;
    }

    public final IRI parseLoneNS() throws ParseException {
        Token t = this.jj_consume_token(48);
        return this.getIRIFromQName(t.image);
    }

    public final IRI parseAbbreviatedIRI() throws ParseException {
        Token t = this.jj_consume_token(50);
        return this.getIRIFromQName(t.image);
    }

    public final IRI parseIRI() throws ParseException {
        Token t = this.jj_consume_token(47);
        return this.getIRI(t.image);
    }

    public final IRI parseBlankNode() throws ParseException {
        IRI iri = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                iri = this.parseNodeID();
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                if (iri != null) break;
                iri = this.getNextBlankNode(null);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 38: 
                    case 47: 
                    case 48: 
                    case 50: {
                        if (iri == null) {
                            iri = this.getNextBlankNode(null);
                        }
                        this.parsePredicateObjectList(iri);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 32: {
                                this.jj_consume_token(32);
                                break block6;
                            }
                        }
                        this.jj_la1[5] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                this.jj_consume_token(30);
                if (iri != null) break;
                iri = this.getNextBlankNode(null);
                break;
            }
            case 27: {
                iri = this.parseCollection();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return iri;
    }

    public final IRI parseNodeID() throws ParseException {
        Token t = this.jj_consume_token(55);
        return this.getNextBlankNode(t.image);
    }

    public final void parsePredicateObjectList(IRI subject) throws ParseException {
        IRI predicate = this.parseVerb();
        this.parseObjectList(subject, predicate);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(33);
            predicate = this.parseVerb();
            this.parseObjectList(subject, predicate);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
    }

    public final IRI parseVerb() throws ParseException {
        IRI iri;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                iri = OWLRDFVocabulary.RDF_TYPE.getIRI();
                break;
            }
            case 47: 
            case 48: 
            case 50: {
                iri = this.parsePredicate();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return iri;
    }

    public final IRI parsePredicate() throws ParseException {
        IRI iri = this.parseResource();
        return iri;
    }

    public final IRI parseResource() throws ParseException {
        IRI iri;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 47: {
                iri = this.parseIRI();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                if (this.jj_2_2(2)) {
                    iri = this.parseAbbreviatedIRI();
                    break;
                }
                if (this.jj_2_3(2)) {
                    iri = this.parseLoneNS();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return iri;
    }

    public final void parseObjectList(IRI subject, IRI predicate) throws ParseException {
        this.parseObject(subject, predicate);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(31);
            this.parseObject(subject, predicate);
        }
    }

    public final void parseObject(IRI subject, IRI predicate) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 41: 
            case 42: {
                this.parseLiteral(subject, predicate);
                break;
            }
            case 27: 
            case 29: 
            case 39: 
            case 47: 
            case 48: 
            case 50: 
            case 55: {
                IRI resObject;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 47: 
                    case 48: 
                    case 50: {
                        resObject = this.parseResource();
                        break;
                    }
                    case 27: 
                    case 29: 
                    case 39: 
                    case 55: {
                        resObject = this.parseBlankNode();
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.handler.handleTriple(subject, predicate, resObject);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final IRI parseCollection() throws ParseException {
        this.jj_consume_token(27);
        IRI iri = this.parseItemList();
        this.jj_consume_token(28);
        return iri;
    }

    public final IRI parseItemList() throws ParseException {
        IRI firstSubject = OWLRDFVocabulary.RDF_NIL.getIRI();
        IRI subject = null;
        IRI type = OWLRDFVocabulary.RDF_TYPE.getIRI();
        IRI first = OWLRDFVocabulary.RDF_FIRST.getIRI();
        IRI rest = OWLRDFVocabulary.RDF_REST.getIRI();
        IRI list = OWLRDFVocabulary.RDF_LIST.getIRI();
        IRI nil = OWLRDFVocabulary.RDF_NIL.getIRI();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 13: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 29: 
                case 39: 
                case 41: 
                case 42: 
                case 47: 
                case 48: 
                case 50: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            IRI prevSubject = subject;
            subject = this.getNextBlankNode(null);
            if (prevSubject != null) {
                this.handler.handleTriple(prevSubject, rest, subject);
            } else {
                firstSubject = subject;
            }
            if (subject != null) {
                this.handler.handleTriple(subject, type, list);
            }
            this.parseObject(subject, first);
        }
        if (subject != null) {
            this.handler.handleTriple(subject, rest, nil);
        }
        return firstSubject;
    }

    public final void parseLiteral(IRI subject, IRI predicate) throws ParseException {
        String lang = null;
        IRI datatype = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 13: 
            case 17: 
            case 21: {
                String literal = this.parseQuotedString();
                block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 37: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 35: {
                                this.jj_consume_token(35);
                                datatype = this.parseResource();
                                break block7;
                            }
                            case 37: {
                                this.jj_consume_token(37);
                                Token t = this.jj_consume_token(49);
                                lang = t.image;
                                break block7;
                            }
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                if (datatype != null) {
                    this.handler.handleTriple(subject, predicate, literal, datatype);
                    break;
                }
                if (lang != null) {
                    this.handler.handleTriple(subject, predicate, literal, lang);
                    break;
                }
                this.handler.handleTriple(subject, predicate, literal);
                break;
            }
            case 22: 
            case 23: {
                String literal = this.parseInteger();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.INTEGER.getIRI());
                break;
            }
            case 24: {
                String literal = this.parseDouble();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.DOUBLE.getIRI());
                break;
            }
            case 25: {
                String literal = this.parseDecimal();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.DECIMAL.getIRI());
                break;
            }
            case 41: 
            case 42: {
                String literal = this.parseBoolean();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.BOOLEAN.getIRI());
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String parseInteger() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final String parseDouble() throws ParseException {
        Token t = this.jj_consume_token(24);
        return t.image;
    }

    public final String parseDecimal() throws ParseException {
        Token t = this.jj_consume_token(25);
        return t.image;
    }

    public final String parseBoolean() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                t = this.jj_consume_token(41);
                break;
            }
            case 42: {
                t = this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final String parseQuotedString() throws ParseException {
        String s = this.parseString();
        return s;
    }

    public final String parseString() throws ParseException {
        String rawString = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                Token t = this.jj_consume_token(9);
                rawString = t.image.substring(1, t.image.length() - 1);
                break;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                rawString = t.image.substring(1, t.image.length() - 1);
                break;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                rawString = t.image.substring(3, t.image.length() - 3);
                break;
            }
            case 21: {
                Token t = this.jj_consume_token(21);
                rawString = t.image.substring(3, t.image.length() - 3);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return EscapeUtils.unescapeString(rawString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private boolean jj_3R_6() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3_3() {
        return this.jj_3R_7();
    }

    private boolean jj_3R_7() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3R_12() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_2()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_3()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_10() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_9() {
        return this.jj_3R_10();
    }

    private boolean jj_3_2() {
        return this.jj_3R_6();
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_8() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_9()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x28000000, 0x28000000, 0, 0, 0x28000000, 0, 0, 0x28000000, 0, 0, 0, Integer.MIN_VALUE, 0x28000000, 736240128, 736240128, 0, 0, 65151488, 0xC00000, 0, 0x222200};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{8749204, 8749204, 20, 360512, 0x858080, 1, 360512, 0x800080, 2, 360512, 32768, 0, 0x858080, 8750720, 8750720, 40, 40, 1536, 0, 1536, 0};
    }

    public TurtleParser(Provider stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new TurtleParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TurtleParser(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new TurtleParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TurtleParser(TurtleParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(TurtleParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[57];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 21; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 57; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : TurtleParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        TurtleParser.jj_la1_init_0();
        TurtleParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }
}

